/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.FileAppender;
import de.peeeq.wurstscript.WLoggerDefault;
import de.peeeq.wurstscript.WLoggerI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.slf4j.LoggerFactory;

public abstract class WLogger {
    private static WLoggerI instance = new WLoggerDefault("default");

    public static void info(Throwable e) {
        instance.info(e);
    }

    public static void trace(String msg) {
        instance.trace(msg);
    }

    public static void info(String msg) {
        instance.info(msg);
    }

    public static void setLevel(Level level) {
        instance.setLevel(level);
    }

    public static void severe(Throwable e) {
        instance.severe(e);
    }

    public static void severe(String msg) {
        instance.severe(msg);
    }

    public static void warning(String msg) {
        instance.warning(msg);
    }

    public static void warning(String msg, Throwable e) {
        instance.warning(msg, e);
    }

    public static String getLog() {
        FileAppender fileAppender = null;
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger logger : context.getLoggerList()) {
            Iterator index = logger.iteratorForAppenders();
            while (index.hasNext()) {
                Object enumElement = index.next();
                if (!(enumElement instanceof FileAppender)) continue;
                fileAppender = (FileAppender)enumElement;
            }
        }
        File clientLogFile = fileAppender != null ? new File(fileAppender.getFile()) : null;
        if (clientLogFile != null) {
            try {
                return WLogger.getLast100Lines(clientLogFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "no logs...";
    }

    private static String getLast100Lines(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel channel = fileInputStream.getChannel();
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        ((ByteBuffer)buffer).position((int)channel.size());
        int count = 0;
        StringBuilder builder = new StringBuilder();
        for (long i = channel.size() - 1L; i >= 0L; --i) {
            char c = (char)buffer.get((int)i);
            builder.append(c);
            if (c != '\n') continue;
            if (count == 100) break;
            ++count;
        }
        channel.close();
        return builder.toString();
    }

    public static void setLogger(String loggerName) {
        instance = new WLoggerDefault(loggerName);
    }
}

