/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.antlr.FDFLexer;
import net.moonlightflower.wc3libs.antlr.FDFParser;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.txt.TXT;
import net.moonlightflower.wc3libs.txt.UTF8;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;

public class FDF
extends UTF8 {
    private final Map<String, String> _map = new LinkedHashMap<String, String>();

    private static String stripComments(@Nullable String val) {
        if (val == null) {
            return null;
        }
        val = val.replaceAll("//.*", "");
        Pattern pattern = Pattern.compile(String.format("%s.*%s", Pattern.quote("/*"), Pattern.quote("*/")), 32);
        Matcher matcher = pattern.matcher(val);
        val = matcher.replaceAll("");
        return val;
    }

    private static String dequote(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static int indexOfRegex(@Nonnull String input, @Nonnull String regex, int startPos) {
        Matcher matcher = Pattern.compile(regex).matcher(input);
        if (!matcher.find(startPos)) {
            return -1;
        }
        return matcher.start(1);
    }

    @Nullable
    public static List<String> tokenize(@Nonnull String line) {
        if (line.length() == 0) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        int startPos = 0;
        while (startPos < line.length()) {
            String val;
            int endPos;
            if (line.charAt(startPos) == '\"') {
                endPos = line.indexOf(34, startPos + 1);
                if (endPos == -1) {
                    endPos = line.length() - 1;
                }
                val = line.substring(startPos, endPos + 1);
                val = FDF.dequote(val);
                ret.add(val);
                startPos = endPos + 1;
                continue;
            }
            endPos = line.indexOf(44, startPos);
            if (endPos == -1) {
                endPos = FDF.indexOfRegex(line, "\\s", startPos);
                if (endPos == -1) {
                    endPos = line.length() - 1;
                }
            } else {
                --endPos;
            }
            val = endPos < startPos ? "" : line.substring(startPos, endPos + 1);
            ret.add(val);
            startPos = endPos + 2;
        }
        return ret;
    }

    @Nonnull
    public TXT toTXT() {
        TXT txt = new TXT();
        for (Map.Entry<String, String> entry : this._map.entrySet()) {
            txt.set(entry.getKey(), entry.getValue());
        }
        return txt;
    }

    private void read(@Nonnull InputStream inStream) throws IOException {
        UTF8 reader = new UTF8(inStream);
        String input = FDF.stripComments(reader.readAll());
        CodePointCharStream antlrStream = CharStreams.fromString((String)input);
        FDFLexer lexer = new FDFLexer((CharStream)antlrStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FDFParser parser = new FDFParser((TokenStream)tokens);
        final LinkedHashMap newEntries = new LinkedHashMap();
        parser.addParseListener(new ParseTreeListener(){

            public void enterEveryRule(ParserRuleContext arg0) {
            }

            public void exitEveryRule(ParserRuleContext context) {
                if (context instanceof FDFParser.StringAssignContext) {
                    FDFParser.StringAssignContext stringAssignContext = (FDFParser.StringAssignContext)context;
                    newEntries.put(stringAssignContext.id.getText(), FDF.dequote(stringAssignContext.val.getText()));
                }
            }

            public void visitErrorNode(ErrorNode arg0) {
            }

            public void visitTerminal(TerminalNode arg0) {
            }
        });
        parser.root();
        this._map.putAll(newEntries);
    }

    private void read2(@Nonnull InputStream inStream) throws IOException {
        UTF8 reader = new UTF8(inStream);
        String input = FDF.stripComments(reader.readAll());
        int escapedBackslashReplaceChar = 1;
        while (input.indexOf(escapedBackslashReplaceChar) != -1) {
            ++escapedBackslashReplaceChar;
        }
        int escapedQuoteReplaceChar = escapedBackslashReplaceChar + 1;
        while (input.indexOf(escapedQuoteReplaceChar) != -1) {
            ++escapedQuoteReplaceChar;
        }
        input = input.replaceAll("\\\\", Character.toString((char)escapedBackslashReplaceChar));
        input = input.replaceAll("\\\\\"", Character.toString((char)escapedQuoteReplaceChar));
        BufferedWriter out = new BufferedWriter(new FileWriter(new File("D:\\fdf.txt")));
        out.write(input);
        out.close();
        input = input.replaceAll("\\p{Cntrl}", "");
        Pattern pattern = Pattern.compile("StringList\\s*\\{(.*)\\}");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            String content = matcher.group(1);
            Matcher contentMatcher = Pattern.compile("[\\s*(\\w+)\\s+\\\"(.*)\\\"]+").matcher(input);
            if (contentMatcher.find()) {
                for (int i = 0; i < contentMatcher.groupCount() / 2; ++i) {
                    String key = contentMatcher.group(i * 2);
                    String val = contentMatcher.group(i * 2 + 1);
                    this._map.put(key, val);
                }
            }
        }
    }

    public FDF(@Nonnull File file) throws IOException {
        this(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public FDF(@Nonnull InputStream inStream) throws IOException {
        this.read(inStream);
    }

    @Nonnull
    protected static MpqPort getMpqPort() {
        return Context.getService(MpqPort.class);
    }

    @Nonnull
    public static FDF ofGameFile(@Nonnull File inFile) throws Exception {
        MpqPort.Out.Result portResult = FDF.getMpqPort().getGameFiles(inFile);
        if (!portResult.getExports().containsKey(inFile)) {
            throw new IOException(String.format("could not extract %s file", inFile.toString()));
        }
        byte[] bytes = portResult.getExports().get(inFile).getOutBytes();
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        FDF fdf = new FDF(inStream);
        ((InputStream)inStream).close();
        return fdf;
    }
}

