/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.Track;
import net.moonlightflower.wc3libs.misc.model.mdx.TrackChunk;

public class GeosetAnim
extends MDXObject {
    private long _inclusiveSize = 0L;
    private float _alpha;
    private long _flags;
    private Color _color;
    private long _geosetId = 0L;
    private final LinkedHashSet<Chunk> _chunks = new ObservableLinkedHashSet<Chunk>();
    private final LinkedHashSet<AlphaTrackChunk> _alphaTrackChunks = new ObservableLinkedHashSet<AlphaTrackChunk>();
    private final LinkedHashSet<ColorTrackChunk> _colorTrackChunks = new ObservableLinkedHashSet<ColorTrackChunk>();

    public long getInclusiveSize() {
        return this._inclusiveSize;
    }

    public float getAlpha() {
        return this._alpha;
    }

    public void setAlpha(float alpha) {
        this._alpha = alpha;
    }

    public long getFlags() {
        return this._flags;
    }

    public void setFlags(long flags) {
        this._flags = flags;
    }

    @Nonnull
    public Color getColor() {
        return this._color;
    }

    public void setColor(@Nonnull Color color) {
        this._color = color;
    }

    public long getGeosetId() {
        return this._geosetId;
    }

    public LinkedHashSet<Chunk> getChunks() {
        return this._chunks;
    }

    public LinkedHashSet<AlphaTrackChunk> getAlphaTrackChunks() {
        return this._alphaTrackChunks;
    }

    public void addAlphaTrackChunk(@Nonnull AlphaTrackChunk val) {
        this._chunks.add(val);
        this._alphaTrackChunks.add(val);
    }

    public LinkedHashSet<ColorTrackChunk> getColorTrackChunks() {
        return this._colorTrackChunks;
    }

    public void addColorTrackChunk(@Nonnull ColorTrackChunk val) {
        this._chunks.add(val);
        this._colorTrackChunks.add(val);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        MDXObject.SizeWriter sizeWriter = new MDXObject.SizeWriter();
        sizeWriter.write(stream);
        stream.writeFloat32(this._alpha);
        stream.writeUInt32(this._flags);
        stream.writeFloat32((float)this._color.getBlue255() / 255.0f);
        stream.writeFloat32((float)this._color.getGreen255() / 255.0f);
        stream.writeFloat32((float)this._color.getRed255() / 255.0f);
        stream.writeUInt32(this._geosetId);
        for (Chunk chunk : this.getChunks()) {
            chunk.write(stream);
        }
        sizeWriter.rewrite();
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public GeosetAnim(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        this._inclusiveSize = stream.readUInt32("inclusiveSize");
        this._alpha = stream.readFloat32("alpha").floatValue();
        this._flags = stream.readUInt32("flags");
        float blue = stream.readFloat32("blue").floatValue();
        float green = stream.readFloat32("green").floatValue();
        float red = stream.readFloat32("red").floatValue();
        this._color = Color.fromBGR255((int)(blue * 255.0f), (int)(green * 255.0f), (int)(red * 255.0f));
        this._geosetId = stream.readInt32("geosetId").intValue();
        LinkedHashMap<Id, MDX.TokenHandler> _tokenMap = new LinkedHashMap<Id, MDX.TokenHandler>();
        _tokenMap.put(AlphaTrackChunk.TOKEN, () -> this.addAlphaTrackChunk(new AlphaTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        _tokenMap.put(ColorTrackChunk.TOKEN, () -> this.addColorTrackChunk(new ColorTrackChunk(stream, MDX.EncodingFormat.MDX_0x0)));
        while (!stream.eof()) {
            Id trackToken = stream.readId("trackToken");
            stream.rewind(4L);
            if (!_tokenMap.containsKey(trackToken)) break;
            MDX.TokenHandler handler = (MDX.TokenHandler)_tokenMap.get(trackToken);
            handler.run();
        }
    }

    public GeosetAnim() {
        this._color = Color.fromBGRA255(0, 0, 0, 0);
    }

    public static class ColorTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KGAC");
        private final LinkedHashSet<ColorTrack> _colorTracks = new ObservableLinkedHashSet<ColorTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._colorTracks;
        }

        public LinkedHashSet<ColorTrack> getAlphaTracks() {
            return this._colorTracks;
        }

        public ColorTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._colorTracks.add(new ColorTrack(stream, this.getInterpolationType(), format));
            }
        }

        public ColorTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class ColorTrack
        extends Track {
            private Color _color;
            private Color _inTan_color;
            private Color _outTan_color;

            @Nonnull
            public Color getColor() {
                return this._color;
            }

            public void setColor(@Nonnull Color color) {
                this._color = color;
            }

            public Color getInTanColor() {
                return this._inTan_color;
            }

            public void setInTanColor(@Nonnull Color color) {
                this._inTan_color = color;
            }

            public Color getOutTanColor() {
                return this._outTan_color;
            }

            public void setOutTanColor(@Nonnull Color color) {
                this._outTan_color = color;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._color = Color.fromBGR255((int)(stream.readFloat32("colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("colorRed").floatValue() * 255.0f));
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_color = Color.fromBGR255((int)(stream.readFloat32("inTan_colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("inTan_colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("inTan_colorRed").floatValue() * 255.0f));
                    this._outTan_color = Color.fromBGR255((int)(stream.readFloat32("outTan_colorBlue").floatValue() * 255.0f), (int)(stream.readFloat32("outTan_colorGreen").floatValue() * 255.0f), (int)(stream.readFloat32("outTan_colorRed").floatValue() * 255.0f));
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32((float)this._color.getBlue255() / 255.0f);
                stream.writeFloat32((float)this._color.getGreen255() / 255.0f);
                stream.writeFloat32((float)this._color.getRed255() / 255.0f);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32((float)this._inTan_color.getBlue255() / 255.0f);
                    stream.writeFloat32((float)this._inTan_color.getGreen255() / 255.0f);
                    stream.writeFloat32((float)this._inTan_color.getRed255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getBlue255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getGreen255() / 255.0f);
                    stream.writeFloat32((float)this._outTan_color.getRed255() / 255.0f);
                }
            }

            public ColorTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static class AlphaTrackChunk
    extends TrackChunk {
        public static final Id TOKEN = Id.valueOf("KGAO");
        private final LinkedHashSet<AlphaTrack> _alphaTracks = new ObservableLinkedHashSet<AlphaTrack>();

        @Override
        public Id getToken() {
            return TOKEN;
        }

        @Override
        public Set<? extends Track> getTracks() {
            return this._alphaTracks;
        }

        public LinkedHashSet<AlphaTrack> getAlphaTracks() {
            return this._alphaTracks;
        }

        public AlphaTrackChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
            for (long tracksCount = this.getTracksCount(); tracksCount > 0L; --tracksCount) {
                this._alphaTracks.add(new AlphaTrack(stream, this.getInterpolationType(), format));
            }
        }

        public AlphaTrackChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this(stream, MDX.EncodingFormat.AUTO);
        }

        public static class AlphaTrack
        extends Track {
            private float _alpha;
            private float _inTan_alpha;
            private float _outTan_alpha;

            public float getAlpha() {
                return this._alpha;
            }

            public void setAlpha(float alpha) {
                this._alpha = alpha;
            }

            public float getInTanAlpha() {
                return this._inTan_alpha;
            }

            public void setInTanAlpha(float alpha) {
                this._inTan_alpha = alpha;
            }

            public void setOutTanAlpha(float alpha) {
                this._outTan_alpha = alpha;
            }

            public float getOutTanAlpha() {
                return this._outTan_alpha;
            }

            @Override
            protected void readSpec(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                this._alpha = stream.readFloat32("alpha").floatValue();
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    this._inTan_alpha = stream.readFloat32("inTan_alpha").floatValue();
                    this._outTan_alpha = stream.readFloat32("outTan_alpha").floatValue();
                }
            }

            @Override
            protected void writeSpec(@Nonnull Wc3BinOutputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType) throws BinStream.StreamException {
                stream.writeFloat32(this._alpha);
                if (interpolationType.equals((Object)TrackChunk.InterpolationType.HERMITE) || interpolationType.equals((Object)TrackChunk.InterpolationType.BEZIER)) {
                    stream.writeFloat32(this._inTan_alpha);
                    stream.writeFloat32(this._outTan_alpha);
                }
            }

            public AlphaTrack(@Nonnull Wc3BinInputStream stream, @Nonnull TrackChunk.InterpolationType interpolationType, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
                super(stream, interpolationType, format);
            }
        }
    }

    public static enum Flag {
        DROP_SHADOW(1),
        COLOR(2);

        private int _index;

        public int getIndex() {
            return this._index;
        }

        private Flag(int index) {
            this._index = index;
        }
    }
}

