/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imoptimizer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarRead;
import de.peeeq.wurstscript.jassIm.ImVarWrite;
import java.util.Collection;

public class VariableUses {
    public static Uses calcVarUses(ImProg imProg) {
        final Uses result = new Uses();
        imProg.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(final ImSet imSet) {
                final 1 thiz = this;
                imSet.getRight().accept(this);
                imSet.getLeft().match(new ImLExpr.MatcherVoid(){

                    @Override
                    public void case_ImVarAccess(ImVarAccess e) {
                        result.addWrite(e.getVar(), imSet);
                    }

                    @Override
                    public void case_ImStatementExpr(ImStatementExpr e) {
                        e.getStatements().accept(thiz);
                        ((ImLExpr)e.getExpr()).match(this);
                    }

                    @Override
                    public void case_ImTupleSelection(ImTupleSelection e) {
                        ((ImLExpr)e.getTupleExpr()).match(this);
                    }

                    @Override
                    public void case_ImTupleExpr(ImTupleExpr e) {
                        for (ImExpr expr : e.getExprs()) {
                            ((ImLExpr)expr).match(this);
                        }
                    }

                    @Override
                    public void case_ImVarArrayAccess(ImVarArrayAccess e) {
                        result.addWrite(e.getVar(), imSet);
                        e.getIndexes().accept(thiz);
                    }

                    @Override
                    public void case_ImMemberAccess(ImMemberAccess e) {
                        e.getReceiver().accept(thiz);
                        result.addWrite(e.getVar(), imSet);
                    }
                });
            }

            @Override
            public void visit(ImVarAccess r) {
                super.visit(r);
                result.addRead(r.getVar(), r);
            }

            @Override
            public void visit(ImVarArrayAccess r) {
                super.visit(r);
                result.addRead(r.getVar(), r);
            }
        });
        return result;
    }

    public static Collection<ImVarWrite> getVarWrites(ImVar imVar) {
        return imVar.attrProg().attrVariableUses().writes.get((Object)imVar);
    }

    public static Collection<ImVarRead> getVarReads(ImVar imVar) {
        return imVar.attrProg().attrVariableUses().reads.get((Object)imVar);
    }

    public static class Uses {
        final Multimap<ImVar, ImVarRead> reads = ArrayListMultimap.create();
        final Multimap<ImVar, ImVarWrite> writes = ArrayListMultimap.create();

        public void addWrite(ImVar v, ImVarWrite w) {
            this.writes.put((Object)v, (Object)w);
        }

        public void addRead(ImVar v, ImVarRead r) {
            this.reads.put((Object)v, (Object)r);
        }
    }
}

