/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.attributes.AttrClosureAbstractMethod;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.FunctionSignature;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeCode;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class WurstTypeClosure
extends WurstType {
    private final List<WurstType> paramTypes;
    private final WurstType returnType;

    public WurstTypeClosure(List<WurstType> paramTypes, WurstType returnType) {
        this.paramTypes = paramTypes;
        this.returnType = returnType;
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType other, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if (other instanceof WurstTypeClosure) {
            WurstTypeClosure o = (WurstTypeClosure)other;
            if (this.paramTypes.size() != o.paramTypes.size()) {
                return null;
            }
            for (int i = 0; i < this.paramTypes.size(); ++i) {
                mapping = o.paramTypes.get(i).matchAgainstSupertype(this.paramTypes.get(i), location, mapping, variablePosition.inverse());
                if (mapping != null) continue;
                return null;
            }
            return this.returnType.matchAgainstSupertype(o.returnType, location, mapping, variablePosition);
        }
        if (other instanceof WurstTypeCode) {
            if (this.paramTypes.size() == 0) {
                return mapping;
            }
        } else {
            FunctionSignature abstractMethod = AttrClosureAbstractMethod.getAbstractMethodSignature(other);
            if (abstractMethod != null) {
                return this.closureImplementsAbstractMethod(abstractMethod, location, mapping, variablePosition);
            }
        }
        return null;
    }

    private VariableBinding closureImplementsAbstractMethod(FunctionSignature abstractMethod, Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if (this.paramTypes.size() != abstractMethod.getParamTypes().size()) {
            return null;
        }
        for (int i = 0; i < this.paramTypes.size(); ++i) {
            mapping = abstractMethod.getParamTypes().get(i).normalize().matchAgainstSupertype(this.paramTypes.get(i), location, mapping, variablePosition.inverse());
            if (mapping != null) continue;
            return null;
        }
        if (abstractMethod.getReturnType() instanceof WurstTypeVoid) {
            return mapping;
        }
        return this.returnType.matchAgainstSupertype(abstractMethod.getReturnType().normalize(), location, mapping, variablePosition);
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (WurstType t : this.paramTypes) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(t.getName());
            first = false;
        }
        sb.append(") -> ");
        sb.append(this.returnType.getName());
        return sb.toString();
    }

    @Override
    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (WurstType t : this.paramTypes) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(t.getFullName());
            first = false;
        }
        sb.append(") -> ");
        sb.append(this.returnType.getFullName());
        return sb.toString();
    }

    @Override
    public ImType imTranslateType(ImTranslator tr) {
        return WurstTypeInt.instance().imTranslateType(tr);
    }

    @Override
    public ImExprOpt getDefaultValue(ImTranslator tr) {
        return JassIm.ImIntVal(0);
    }

    @Override
    protected boolean isNullable() {
        return false;
    }

    public List<WurstType> getParamTypes() {
        return this.paramTypes;
    }

    public WurstType getReturnType() {
        return this.returnType;
    }
}

