/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript;

import com.google.common.base.Preconditions;
import de.peeeq.wurstscript.ModuleExpander;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.validation.TRVEHelper;
import de.peeeq.wurstscript.validation.WurstValidator;
import java.util.Collection;

public class WurstChecker {
    private final WurstGui gui;
    private final ErrorHandler errorHandler;

    public WurstChecker(WurstGui gui, ErrorHandler errorHandler) {
        this.gui = gui;
        this.errorHandler = errorHandler;
    }

    public void checkProg(WurstModel root, Collection<CompilationUnit> toCheck) {
        Preconditions.checkNotNull((Object)root);
        Preconditions.checkNotNull(toCheck);
        if (root.isEmpty()) {
            return;
        }
        TRVEHelper.protectedVariables.clear();
        this.gui.sendProgress("Checking Files");
        if (this.errorHandler.getErrorCount() > 0) {
            return;
        }
        this.attachErrorHandler(root);
        this.expandModules(root);
        if (this.errorHandler.getErrorCount() > 0) {
            return;
        }
        for (CompilationUnit cu : toCheck) {
            WurstValidator.computeFlowAttributes(cu);
        }
        WurstValidator validator = new WurstValidator(root);
        validator.validate(toCheck);
        WLogger.info("debug - finished checkProg");
    }

    private void attachErrorHandler(WurstModel root) {
        for (CompilationUnit cu : root) {
            cu.getCuInfo().setCuErrorHandler(this.errorHandler);
        }
    }

    private void expandModules(WurstModel root) {
        for (CompilationUnit cu : root) {
            ModuleExpander.expandModules(cu);
        }
    }
}

