/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.meta;

import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataList;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.AbilId;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Char;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.MetaSLK;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.SLKState;
import net.moonlightflower.wc3libs.slk.app.doodads.DoodSLK;
import net.moonlightflower.wc3libs.slk.app.objs.AbilSLK;
import net.moonlightflower.wc3libs.slk.app.objs.BuffSLK;
import net.moonlightflower.wc3libs.slk.app.objs.DestructableSLK;
import net.moonlightflower.wc3libs.slk.app.objs.ItemSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitAbilsSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitBalanceSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitDataSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitUISLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitWeaponsSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UpgradeSLK;

public class CommonMetaSLK
extends MetaSLK<CommonMetaSLK, ObjId, Obj> {
    public static final int DATA_PT_MIN = 1;
    public static final int DATA_PT_MAX = 9;

    @Override
    @Nonnull
    protected Obj createObj(@Nonnull ObjId id) {
        return new Obj(id);
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
    }

    @Nullable
    public static File convertSLKName(@Nonnull String slkName) {
        switch (slkName) {
            case "AbilityData": {
                return AbilSLK.GAME_PATH;
            }
            case "AbilityBuffData": {
                return BuffSLK.GAME_PATH;
            }
            case "DestructableData": {
                return DestructableSLK.GAME_PATH;
            }
            case "DoodadData": {
                return DoodSLK.GAME_PATH;
            }
            case "ItemData": {
                return ItemSLK.GAME_PATH;
            }
            case "UnitAbilities": {
                return UnitAbilsSLK.GAME_PATH;
            }
            case "UnitBalance": {
                return UnitBalanceSLK.GAME_PATH;
            }
            case "UnitData": {
                return UnitDataSLK.GAME_PATH;
            }
            case "UnitUI": {
                return UnitUISLK.GAME_PATH;
            }
            case "UnitWeapons": {
                return UnitWeaponsSLK.GAME_PATH;
            }
            case "UpgradeData": {
                return UpgradeSLK.GAME_PATH;
            }
        }
        return null;
    }

    public static Integer getDataI(@Nonnull SLK.Obj metaObj) {
        Integer repeatI = null;
        try {
            War3Int repeatVal = War3Int.valueOf(metaObj.get(FieldId.valueOf("data")));
            if (repeatVal != null) {
                repeatI = repeatVal.toInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return repeatI;
    }

    public static Integer getRepeatI(@Nonnull SLK.Obj metaObj) {
        Integer repeatI = null;
        try {
            War3Int repeatVal = War3Int.valueOf(metaObj.get(FieldId.valueOf("repeat")));
            if (repeatVal != null) {
                repeatI = repeatVal.toInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return repeatI;
    }

    public static int getSLKFieldRepeatPlaces(@Nonnull File slkFile, int repeat) {
        int places = 1;
        if (slkFile.equals(DoodSLK.GAME_PATH)) {
            if (repeat > 10) {
                return -1;
            }
            places = 2;
        } else {
            if (repeat > 4) {
                return -1;
            }
            places = 1;
        }
        return places;
    }

    public static FieldId getSLKField(@Nonnull File slkFile, @Nonnull SLK.Obj metaObj, @Nullable Integer level) {
        int places;
        Integer repeatI;
        FieldId retFieldId = FieldId.valueOf(metaObj.getS(FieldId.valueOf("field")));
        if (retFieldId.toString().equals("Data")) {
            Integer dataPt = CommonMetaSLK.getDataI(metaObj);
            if (dataPt < 1) {
                throw new RuntimeException("dataPt < 1");
            }
            if (dataPt > 9) {
                throw new RuntimeException("dataPt > 9");
            }
            retFieldId = FieldId.valueOf(retFieldId.toString() + (char)(65 + dataPt - 1));
        }
        if ((repeatI = CommonMetaSLK.getRepeatI(metaObj)) != null && repeatI > 0 && level != null && (places = CommonMetaSLK.getSLKFieldRepeatPlaces(slkFile, repeatI)) > -1) {
            StringBuilder add = new StringBuilder(Integer.toString(level));
            while (add.length() < places) {
                add.insert(0, "0");
            }
            retFieldId = FieldId.valueOf(retFieldId.toString() + add);
        }
        return retFieldId;
    }

    public static class Obj
    extends SLK.Obj<ObjId> {
        public Obj(@Nonnull ObjId id) {
            super(id);
        }

        @Override
        public Map<? extends SLKState, DataType> getStateVals() {
            return null;
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
        }

        @Override
        protected void on_clear() {
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<ObjId> ID = new State<ObjId>("ID", ObjId.class);
        public static final State<War3String> FIELD = new State<War3String>("field", War3String.class);
        public static final State<War3String> SLK = new State<War3String>("slk", War3String.class);
        public static final State<War3String> INDEX = new State<War3String>("index", War3String.class);
        public static final State<War3Int> REPEAT = new State<War3Int>("repeat", War3Int.class);
        public static final State<War3String> CATEGORY = new State<War3String>("category", War3String.class);
        public static final State<War3String> DISPLAY_NAME = new State<War3String>("displayName", War3String.class);
        public static final State<War3String> SORT = new State<War3String>("sort", War3String.class);
        public static final State<War3String> TYPE = new State<War3String>("type", War3String.class);
        public static final State<War3Char> CHANGE_FLAGS = new State<War3Char>("changeFlags", War3Char.class);
        public static final State<War3String> IMPORT_TYPE = new State<War3String>("importType", War3String.class);
        public static final State<War3Bool> STRING_EXT = new State<War3Bool>("stringExt", War3Bool.class);
        public static final State<War3Bool> CASE_SENS = new State<War3Bool>("caseSens", War3Bool.class);
        public static final State<War3Bool> CAN_BE_EMPTY = new State<War3Bool>("canBeEmpty", War3Bool.class);
        public static final State<War3String> MIN_VAL = new State<War3String>("minVal", War3String.class);
        public static final State<War3String> MAX_VAL = new State<War3String>("maxVal", War3String.class);
        public static final State<War3Bool> FORCE_NON_NEG = new State<War3Bool>("forceNonNeg", War3Bool.class);
        public static final State<War3Int> USE_SPECIFIC = new State<War3Int>("useSpecific", War3Int.class);
        public static final State<War3Int> NOT_SPECIFIC = new State("notSpecific", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)AbilId.class));
        public static final State<War3Int> VERSION = new State<War3Int>("version", War3Int.class);
        public static final State<War3Int> SECTION = new State<War3Int>("section", War3Int.class);
        public static final State<War3Bool> IN_BETA = new State<War3Bool>("InBeta", War3Bool.class);
        public static final State<War3Int> DATA = new State<War3Int>("data", War3Int.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

