/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port.mac;

import java.io.File;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.AlreadyTriedException;
import net.moonlightflower.wc3libs.port.GameDirFinder;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.MapsDirFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.mac.MacGameDirFinder;
import net.moonlightflower.wc3libs.port.mac.MacGameVersionFinder;

public class MacMapsDirFinder
extends MapsDirFinder {
    public static File LOCAL_MAPS_DIR = new File("~/Library/Application Support/Blizzard/Warcraft III/Maps/");
    public static File GAME_SUB_DIR = new File("Maps");

    protected GameDirFinder getMacGameDirFinder() {
        return new MacGameDirFinder();
    }

    protected GameVersionFinder getMacGameVersionFinder() {
        return new MacGameVersionFinder();
    }

    public File find(@Nonnull GameVersion gameVersion) throws NotFoundException {
        if (gameVersion.compareTo(GameVersion.VERSION_1_29) > 0) {
            if (!LOCAL_MAPS_DIR.exists()) {
                throw new NotFoundException(new Exception(LOCAL_MAPS_DIR + " does not exist"));
            }
            return LOCAL_MAPS_DIR;
        }
        GameDirFinder macGameDirFinder = this.getMacGameDirFinder();
        try {
            File gameDir = (File)macGameDirFinder.find();
            File mapsDir = new File(gameDir, GAME_SUB_DIR.toString());
            if (!mapsDir.exists()) {
                throw new NotFoundException(new Exception(mapsDir + " does not exist"));
            }
            return mapsDir;
        }
        catch (NotFoundException notFoundException) {
            throw new NotFoundException();
        }
    }

    @Override
    @Nonnull
    public File find() throws NotFoundException {
        GameVersionFinder macGameVersionFinder = this.getMacGameVersionFinder();
        try {
            GameVersion gameVersion = (GameVersion)macGameVersionFinder.get();
            return this.find(gameVersion);
        }
        catch (AlreadyTriedException e) {
            throw new NotFoundException(e);
        }
    }
}

