/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.peeeq.wurstscript.ast.AstElementWithNameId;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImVar;

public class NormalizeNames {
    public static void normalizeNames(ImProg prog) {
        Multimap<ImMethod, ImMethod> superMethods = NormalizeNames.calculateSuperMethods(prog);
        for (ImClass c : prog.getClasses()) {
            for (ImVar g : c.getFields()) {
                NormalizeNames.normalizeName(g);
            }
            for (ImMethod m : c.getMethods()) {
                Element trace = m.attrTrace();
                if (trace instanceof AstElementWithNameId) {
                    m.setName(((AstElementWithNameId)trace).getNameId().getName());
                }
                if (trace instanceof OnDestroyDef) {
                    m.setName("__onDestroy");
                }
                if (!superMethods.get((Object)m).isEmpty()) continue;
                for (ImMethod subMethod : m.getSubMethods()) {
                    subMethod.setName(m.getName());
                }
            }
        }
    }

    private static void normalizeName(ImVar g) {
        Element trace = g.attrTrace();
        if (trace instanceof AstElementWithNameId) {
            g.setName(((AstElementWithNameId)trace).getNameId().getName());
        }
    }

    private static Multimap<ImMethod, ImMethod> calculateSuperMethods(ImProg prog) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (ImClass c : prog.getClasses()) {
            for (ImMethod m : c.getMethods()) {
                for (ImMethod subMethod : m.getSubMethods()) {
                    builder.put((Object)subMethod, (Object)m);
                }
            }
        }
        return builder.build();
    }
}

