/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang;

import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstAbstract;
import de.peeeq.wurstscript.intermediatelang.ILconstAddable;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstNum;
import de.peeeq.wurstscript.intermediatelang.ILconstReal;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeInt;
import java.util.Objects;

public class ILconstInt
extends ILconstAbstract
implements ILconstNum {
    private final int val;

    public ILconstInt(int intVal) {
        this.val = intVal;
    }

    @Override
    public String print() {
        return "" + this.val;
    }

    public WurstType getType() {
        return WurstTypeInt.instance();
    }

    @Override
    public ILconstNum negate() {
        return ILconstInt.create(-this.val);
    }

    public static ILconstInt create(int i) {
        return new ILconstInt(i);
    }

    @Override
    public ILconstNum add(ILconstAddable other) {
        if (other instanceof ILconstInt) {
            return ILconstInt.create(this.val + ((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstReal.create((float)this.val + ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstNum sub(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstInt.create(this.val - ((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstReal.create((float)this.val - ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstNum mul(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstInt.create(this.val * ((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstReal.create((float)this.val * ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstNum div(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstInt.create(this.val / ((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstReal.create((float)this.val / ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    public int getVal() {
        return this.val;
    }

    @Override
    public ILconstBool less(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstBool.instance(this.val < ((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstBool.instance((float)this.val < ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstBool lessEq(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstBool.instance(this.val <= ((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstBool.instance((float)this.val <= ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstBool greater(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstBool.instance(this.val > ((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstBool.instance((float)this.val > ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public ILconstBool greaterEq(ILconstNum other) {
        if (other instanceof ILconstInt) {
            return ILconstBool.instance(this.val >= ((ILconstInt)other).getVal());
        }
        if (other instanceof ILconstReal) {
            return ILconstBool.instance((float)this.val >= ((ILconstReal)other).getVal());
        }
        throw new Error();
    }

    @Override
    public boolean isEqualTo(ILconst other) {
        if (other instanceof ILconstInt) {
            return this.val == ((ILconstInt)other).getVal();
        }
        if (other instanceof ILconstReal) {
            return (float)this.val == ((ILconstReal)other).getVal();
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ILconstInt that = (ILconstInt)o;
        return this.val == that.val;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.val);
    }
}

