/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.datastructures;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class UnionFind<T> {
    private final Map<T, T> parent = new LinkedHashMap<T, T>();
    private final Map<T, Integer> rank = new LinkedHashMap<T, Integer>();

    public T find(T x) {
        if (!this.parent.containsKey(x)) {
            this.parent.put(x, x);
            this.rank.put(x, 0);
        }
        if (!this.parent.get(x).equals(x)) {
            this.parent.put(x, this.find(this.parent.get(x)));
        }
        return this.parent.get(x);
    }

    public void union(T x, T y) {
        T yRoot;
        T xRoot = this.find(x);
        if (xRoot.equals(yRoot = this.find(y))) {
            return;
        }
        if (this.rank.get(xRoot) < this.rank.get(yRoot)) {
            T temp = xRoot;
            xRoot = yRoot;
            yRoot = temp;
        }
        this.parent.put(yRoot, xRoot);
        if (this.rank.get(xRoot).equals(this.rank.get(yRoot))) {
            this.rank.put(xRoot, this.rank.get(xRoot));
        }
    }

    public Map<T, Set<T>> groups() {
        LinkedHashMap result = new LinkedHashMap();
        for (T t : this.parent.keySet()) {
            result.put(t, new LinkedHashSet());
        }
        for (Map.Entry entry : this.parent.entrySet()) {
            ((Set)result.get(entry.getValue())).add(entry.getKey());
        }
        return result;
    }
}

