/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.antlr.SLKLexer;
import net.moonlightflower.wc3libs.antlr.SLKParser;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.Mergeable;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.misc.Printable;
import net.moonlightflower.wc3libs.misc.Printer;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.SLKState;
import net.moonlightflower.wc3libs.slk.app.doodads.DoodSLK;
import net.moonlightflower.wc3libs.slk.app.objs.AbilSLK;
import net.moonlightflower.wc3libs.slk.app.objs.BuffSLK;
import net.moonlightflower.wc3libs.slk.app.objs.DestructableSLK;
import net.moonlightflower.wc3libs.slk.app.objs.ItemSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitAbilsSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitBalanceSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitDataSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitUISLK;
import net.moonlightflower.wc3libs.slk.app.objs.UnitWeaponsSLK;
import net.moonlightflower.wc3libs.slk.app.objs.UpgradeSLK;
import net.moonlightflower.wc3libs.txt.UTF8;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ListTokenSource;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public abstract class SLK<Self extends SLK<Self, ObjIdType, ObjType>, ObjIdType extends ObjId, ObjType extends Obj<? extends ObjIdType>>
implements Mergeable<Self>,
Printable {
    private final Map<FieldId, Field> _fields = new LinkedHashMap<FieldId, Field>();
    private FieldId _pivotField = null;
    protected final Map<ObjIdType, ObjType> _objs = new LinkedHashMap<ObjIdType, ObjType>();

    @Override
    public void print(@Nonnull Printer printer) {
        printer.beginGroup("slk");
        printer.println("pivotField " + this.getPivotField());
        printer.beginGroup("fields");
        for (Field field : this.getFields().values()) {
            field.print(printer);
        }
        printer.endGroup();
        printer.beginGroup("objs");
        for (Obj obj : this.getObjs().values()) {
            obj.print(printer);
        }
        printer.endGroup();
        printer.endGroup();
    }

    @Nonnull
    public Map<FieldId, Field> getFields() {
        return this._fields;
    }

    public boolean containsField(@Nonnull FieldId field) {
        return this._fields.containsKey(field);
    }

    @Nullable
    public FieldId getPivotField() {
        return this._pivotField;
    }

    public void addField(@Nonnull FieldId fieldId, @Nullable DataType defVal) {
        Field field = new Field(fieldId, defVal);
        this._fields.putIfAbsent(fieldId, field);
        if (this._pivotField == null) {
            this._pivotField = fieldId;
        }
    }

    public void addField(@Nonnull SLKState state, @Nullable DataType defVal) {
        this.addField((FieldId)state.getFieldId(), defVal);
    }

    public void addField(@Nonnull FieldId field) {
        this.addField(field, null);
    }

    public void addField(@Nonnull SLKState state) {
        this.addField((FieldId)state.getFieldId());
    }

    public boolean containsObj(@Nonnull ObjIdType objId) {
        return this._objs.containsKey(objId);
    }

    @Nonnull
    public Map<ObjIdType, ObjType> getObjs() {
        return this._objs;
    }

    @Nullable
    public ObjType getObj(@Nonnull ObjIdType id) {
        return (ObjType)((Obj)this.getObjs().get(id));
    }

    public void addObj(@Nonnull ObjType val) {
        this._objs.put(((Obj)val).getId(), val);
    }

    public void removeObj(@Nonnull ObjType val) {
        this._objs.remove(((Obj)val).getId());
    }

    public void removeObj(@Nonnull ObjIdType id) {
        if (this._objs.containsKey(id)) {
            this.removeObj((ObjIdType)((Obj)this._objs.get(id)));
        }
    }

    public void clearObjs() {
        this._objs.clear();
    }

    @Nonnull
    protected abstract ObjType createObj(@Nonnull ObjId var1);

    @Nonnull
    public ObjType addObj(@Nonnull ObjIdType id) {
        if (this.getObjs().containsKey(id)) {
            return this.getObj(id);
        }
        ObjType obj = this.createObj((ObjId)id);
        this.addObj((ObjIdType)obj);
        return obj;
    }

    public void merge(@Nonnull Self other, boolean overwrite) {
        if (overwrite) {
            this._pivotField = ((SLK)other).getPivotField();
        }
        for (Map.Entry<FieldId, Field> fieldEntry : ((SLK)other).getFields().entrySet()) {
            FieldId fieldId = fieldEntry.getKey();
            Field field = fieldEntry.getValue();
            if (this.containsField(fieldId)) continue;
            this.addField(fieldId, field.getDefVal());
        }
        for (Obj otherObj : ((SLK)other).getObjs().values()) {
            ObjType obj = this.addObj((ObjIdType)otherObj.getId());
            ((Obj)obj).merge(otherObj, overwrite);
        }
    }

    @Override
    public void merge(@Nonnull Self other) {
        this.merge(other, true);
    }

    protected abstract void read(@Nonnull SLK<?, ? extends ObjId, ? extends Obj<? extends ObjId>> var1);

    public void cleanEmptyColumns() {
        HashMap countMap = new HashMap();
        this._fields.keySet().forEach(key -> countMap.put(key.toString(), 0));
        this._objs.values().forEach(obj -> obj.getVals().forEach((k, v) -> {
            DataType defVal;
            if (v != null && !v.toSLKVal().toString().isEmpty() && countMap.containsKey(k.toString()) && (defVal = v.getTypeInfo().getDefVal()) != null && !defVal.toSLKVal().toString().equals(v.toSLKVal().toString())) {
                Integer val = (Integer)countMap.get(k.toString());
                countMap.put(k.toString(), val + 1);
            }
        }));
        countMap.values().removeIf(count -> count != null && count > 0);
        this._fields.entrySet().removeIf(entry -> countMap.containsKey(((FieldId)entry.getKey()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    public void read(@Nonnull File file, boolean onlyHeader) throws IOException {
        void var19_26;
        DataType[] headerData;
        InputStream inStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        UTF8 reader = new UTF8(inStream, false, true);
        String input = reader.readAll(false);
        inStream.close();
        CodePointCharStream antlrStream = CharStreams.fromString((String)input);
        SLKLexer lexer = new SLKLexer((CharStream)antlrStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        tokenStream.fill();
        List tokens = tokenStream.getTokens();
        SLKParser parser = new SLKParser((TokenStream)new CommonTokenStream((TokenSource)new ListTokenSource(tokens)));
        SLKParser.RootContext rootContext = parser.root();
        boolean foundB = false;
        int maxX = 0;
        int maxY = 0;
        for (SLKParser.RecordContext record : rootContext.record()) {
            if (!record.type.getText().equals("B")) continue;
            int x = 0;
            int y = 0;
            for (SLKParser.RecordPartContext part : record.recordPart()) {
                RecordPart partData = new RecordPart(part.getText());
                if (partData._attr.equals("X") && partData._val instanceof War3Int) {
                    x = ((War3Int)partData._val).toInt();
                }
                if (!partData._attr.equals("Y") || !(partData._val instanceof War3Int)) continue;
                y = ((War3Int)partData._val).toInt();
            }
            maxX = x;
            maxY = y;
            foundB = true;
        }
        if (!foundB) {
            throw new IllegalStateException("did not find B record");
        }
        DataType[][] data = new DataType[maxY][maxX];
        int curX = 0;
        int curY = 0;
        for (SLKParser.RecordContext recordContext : rootContext.record()) {
            if (!recordContext.type.getText().equals("C")) continue;
            int x = curX;
            int y = curY;
            DataType val = null;
            for (SLKParser.RecordPartContext part : recordContext.recordPart()) {
                RecordPart partData = new RecordPart(part.getText());
                if (partData._attr.equals("X") && partData._val instanceof War3Int) {
                    x = ((War3Int)partData._val).toInt() - 1;
                }
                if (partData._attr.equals("Y") && partData._val instanceof War3Int) {
                    y = ((War3Int)partData._val).toInt() - 1;
                }
                if (!partData._attr.equals("K")) continue;
                val = partData._val;
            }
            if (val != null) {
                data[y][x] = val;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            curX = x;
            curY = y;
        }
        this._fields.clear();
        for (DataType fieldRaw : headerData = data[0]) {
            FieldId field;
            if (fieldRaw == null || this._fields.containsKey(field = FieldId.valueOf(fieldRaw.toString()))) continue;
            this.addField(field);
        }
        this._pivotField = FieldId.valueOf(headerData[0].toString());
        if (onlyHeader) {
            return;
        }
        boolean bl = true;
        while (var19_26 < data.length) {
            DataType objIdRaw = data[var19_26][0];
            if (objIdRaw != null) {
                ObjId objId = ObjId.valueOf(objIdRaw.toString());
                ObjType obj = this.createObj(objId);
                this.addObj((ObjIdType)obj);
                for (int j = 1; j < headerData.length; ++j) {
                    FieldId field;
                    DataType fieldRaw = headerData[j];
                    if (fieldRaw == null || (field = FieldId.valueOf(fieldRaw.toString())).equals(this._pivotField)) continue;
                    ((Obj)obj).set(field, data[var19_26][j]);
                }
            }
            ++var19_26;
        }
    }

    public void read(@Nonnull File file) throws IOException {
        this.read(file, false);
    }

    public void write(@Nonnull File file) throws IOException {
        new Writer(file).exec();
    }

    public SLK(@Nonnull File file) throws IOException {
        this();
        this.read(file);
    }

    public SLK() {
    }

    @Nullable
    public static SLK createFromInFile(@Nonnull File inFile, @Nonnull File outFile) throws IOException {
        ObjSLK slk = null;
        if (inFile.equals(DoodSLK.GAME_PATH)) {
            slk = new DoodSLK(outFile);
        }
        if (inFile.equals(UnitAbilsSLK.GAME_PATH)) {
            slk = new UnitAbilsSLK(outFile);
        }
        if (inFile.equals(UnitBalanceSLK.GAME_PATH)) {
            slk = new UnitBalanceSLK(outFile);
        }
        if (inFile.equals(UnitDataSLK.GAME_PATH)) {
            slk = new UnitDataSLK(outFile);
        }
        if (inFile.equals(UnitUISLK.GAME_PATH)) {
            slk = new UnitUISLK(outFile);
        }
        if (inFile.equals(UnitWeaponsSLK.GAME_PATH)) {
            slk = new UnitWeaponsSLK(outFile);
        }
        if (inFile.equals(ItemSLK.GAME_PATH)) {
            slk = new ItemSLK(outFile);
        }
        if (inFile.equals(DestructableSLK.GAME_PATH)) {
            slk = new DestructableSLK(outFile);
        }
        if (inFile.equals(AbilSLK.GAME_PATH)) {
            slk = new AbilSLK(outFile);
        }
        if (inFile.equals(BuffSLK.GAME_PATH)) {
            slk = new BuffSLK(outFile);
        }
        if (inFile.equals(UpgradeSLK.GAME_PATH)) {
            slk = new UpgradeSLK(outFile);
        }
        return slk;
    }

    @Nullable
    public static SLK createFromInFile(@Nonnull File inFile, @Nonnull SLK sourceSlk) {
        ObjSLK slk = null;
        if (inFile.equals(DoodSLK.GAME_PATH)) {
            slk = new DoodSLK(sourceSlk);
        }
        if (inFile.equals(UnitAbilsSLK.GAME_PATH)) {
            slk = new UnitAbilsSLK(sourceSlk);
        }
        if (inFile.equals(UnitBalanceSLK.GAME_PATH)) {
            slk = new UnitBalanceSLK(sourceSlk);
        }
        if (inFile.equals(UnitDataSLK.GAME_PATH)) {
            slk = new UnitDataSLK(sourceSlk);
        }
        if (inFile.equals(UnitUISLK.GAME_PATH)) {
            slk = new UnitUISLK(sourceSlk);
        }
        if (inFile.equals(UnitWeaponsSLK.GAME_PATH)) {
            slk = new UnitWeaponsSLK(sourceSlk);
        }
        if (inFile.equals(ItemSLK.GAME_PATH)) {
            slk = new ItemSLK(sourceSlk);
        }
        if (inFile.equals(DestructableSLK.GAME_PATH)) {
            slk = new DestructableSLK(sourceSlk);
        }
        if (inFile.equals(AbilSLK.GAME_PATH)) {
            slk = new AbilSLK(sourceSlk);
        }
        if (inFile.equals(BuffSLK.GAME_PATH)) {
            slk = new BuffSLK(sourceSlk);
        }
        if (inFile.equals(UpgradeSLK.GAME_PATH)) {
            slk = new UpgradeSLK(sourceSlk);
        }
        return slk;
    }

    @Nullable
    public static SLK createFromInFile(@Nonnull File inFile) {
        ObjSLK slk = null;
        if (inFile.equals(DoodSLK.GAME_PATH)) {
            slk = new DoodSLK();
        }
        if (inFile.equals(UnitAbilsSLK.GAME_PATH)) {
            slk = new UnitAbilsSLK();
        }
        if (inFile.equals(UnitBalanceSLK.GAME_PATH)) {
            slk = new UnitBalanceSLK();
        }
        if (inFile.equals(UnitDataSLK.GAME_PATH)) {
            slk = new UnitDataSLK();
        }
        if (inFile.equals(UnitUISLK.GAME_PATH)) {
            slk = new UnitUISLK();
        }
        if (inFile.equals(UnitWeaponsSLK.GAME_PATH)) {
            slk = new UnitWeaponsSLK();
        }
        if (inFile.equals(ItemSLK.GAME_PATH)) {
            slk = new ItemSLK();
        }
        if (inFile.equals(DestructableSLK.GAME_PATH)) {
            slk = new DestructableSLK();
        }
        if (inFile.equals(AbilSLK.GAME_PATH)) {
            slk = new AbilSLK();
        }
        if (inFile.equals(BuffSLK.GAME_PATH)) {
            slk = new BuffSLK();
        }
        if (inFile.equals(UpgradeSLK.GAME_PATH)) {
            slk = new UpgradeSLK();
        }
        return slk;
    }

    public class Writer {
        private File _file;
        BufferedWriter _writer;
        private int _slkCurX;
        private int _slkCurY;

        @Nullable
        private Object formatVal(@Nullable Object val) {
            if (val == null) {
                return null;
            }
            try {
                return Integer.parseInt(val.toString());
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Float.valueOf(Float.parseFloat(val.toString()));
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        return Double.parseDouble(val.toString());
                    }
                    catch (NumberFormatException numberFormatException3) {
                        if (val instanceof Boolean) {
                            if (((Boolean)val).booleanValue()) {
                                return 1;
                            }
                        } else if (val instanceof Integer) {
                            if ((Integer)val != 0) {
                                return val;
                            }
                        } else if (val instanceof Float) {
                            if (((Float)val).floatValue() != 0.0f) {
                                return val;
                            }
                        } else if (val instanceof Double) {
                            if ((Double)val != 0.0) {
                                return val;
                            }
                        } else {
                            if ((val = val.toString()).toString().isEmpty()) {
                                return null;
                            }
                            if (val.equals("")) {
                                return null;
                            }
                            if (val.equals("\"\"")) {
                                return null;
                            }
                            return "\"" + val + "\"";
                        }
                        return null;
                    }
                }
            }
        }

        private void writeCell(int x, int y, @Nullable DataType slkVal) throws IOException {
            if (slkVal == null) {
                return;
            }
            Object val = slkVal.toSLKVal();
            if (val == null) {
                return;
            }
            if ((val = this.formatVal(val)) == null) {
                return;
            }
            ArrayList<Object> t = new ArrayList<Object>();
            t.add("C");
            if (x != this._slkCurX) {
                t.add("X" + x);
                this._slkCurX = x;
            }
            if (y != this._slkCurY) {
                t.add("Y" + y);
                this._slkCurY = y;
            }
            t.add("K" + val.toString());
            this._writer.newLine();
            this._writer.write(String.join((CharSequence)";", t));
        }

        public void exec() throws IOException {
            if (SLK.this._pivotField == null) {
                throw new RuntimeException("pivotField is null");
            }
            if (this._file.getParentFile() != null) {
                this._file.getParentFile().mkdirs();
            }
            this._writer = new BufferedWriter(new FileWriter(this._file));
            this._writer.write("ID;PWXL;N;E");
            this._writer.newLine();
            this._writer.write("B;X" + (SLK.this._fields.size() + (SLK.this._fields.containsKey(SLK.this._pivotField) ? 0 : 1)) + ";Y" + (SLK.this._objs.size() + 1) + ";D0");
            LinkedHashMap<FieldId, Integer> fieldX = new LinkedHashMap<FieldId, Integer>();
            LinkedHashMap<Integer, FieldId> fieldsByX = new LinkedHashMap<Integer, FieldId>();
            fieldX.put(SLK.this._pivotField, 1);
            int fieldC = 1;
            for (FieldId fieldId : SLK.this._fields.keySet()) {
                if (fieldId.equals(SLK.this._pivotField)) continue;
                fieldX.put(fieldId, ++fieldC);
                fieldsByX.put(fieldC, fieldId);
            }
            this._slkCurX = 0;
            this._slkCurY = 0;
            this.writeCell(1, 1, War3String.valueOf(SLK.this._pivotField.toString()));
            for (Map.Entry entry : fieldsByX.entrySet()) {
                this.writeCell((Integer)entry.getKey(), 1, War3String.valueOf(((FieldId)entry.getValue()).toString()));
            }
            int y = 1;
            for (Map.Entry entry : SLK.this.getObjs().entrySet()) {
                ObjId objId = (ObjId)entry.getKey();
                Obj obj = (Obj)entry.getValue();
                this.writeCell(1, ++y, objId);
                for (Map.Entry fieldEntry : fieldsByX.entrySet()) {
                    int x = (Integer)fieldEntry.getKey();
                    FieldId field = (FieldId)fieldEntry.getValue();
                    DataType val = obj.get(field);
                    if (val == null) {
                        val = SLK.this._fields.get(field).getDefVal();
                    }
                    if (val == null) continue;
                    this.writeCell(x, y, val);
                }
            }
            this._writer.newLine();
            this._writer.write("E\n");
            this._writer.close();
        }

        public Writer(File file) {
            this._file = file;
        }
    }

    private static class RecordPart {
        private String _attr;
        private DataType _val;

        private RecordPart(@Nonnull String s) {
            if (s.startsWith("X") || s.startsWith("Y") || s.startsWith("K")) {
                this._attr = s.substring(0, 1);
                String valS = s.substring(1);
                if (valS.startsWith("\"") && valS.endsWith("\"")) {
                    this._val = War3String.valueOf(valS.substring(1, s.length() - 2));
                } else {
                    try {
                        this._val = War3Int.valueOf(Integer.parseInt(valS));
                    }
                    catch (NumberFormatException ignored) {
                        try {
                            this._val = War3Real.valueOf(Float.parseFloat(valS));
                        }
                        catch (NumberFormatException ignored2) {
                            this._val = War3String.valueOf(valS);
                        }
                    }
                }
            } else {
                this._attr = s;
                this._val = null;
            }
        }
    }

    public static abstract class Obj<T extends ObjId> {
        private final Map<FieldId, DataType> _vals = new LinkedHashMap<FieldId, DataType>();
        private final Map<SLKState, DataType> _stateVals = new LinkedHashMap<SLKState, DataType>();
        private T _id;

        @Nonnull
        public Map<FieldId, DataType> getVals() {
            return this._vals;
        }

        public abstract Map<? extends SLKState, DataType> getStateVals();

        protected abstract void on_set(@Nonnull FieldId var1, @Nullable DataType var2);

        protected abstract void on_remove(@Nonnull FieldId var1);

        protected abstract void on_clear();

        public boolean contains(@Nonnull FieldId field) {
            return this._vals.containsKey(field);
        }

        public DataType get(@Nonnull FieldId field) {
            return this._vals.get(field);
        }

        public DataType get(@Nonnull FieldId field, @Nonnull DataType defVal) {
            if (!this._vals.containsKey(field)) {
                return defVal;
            }
            return this._vals.get(field);
        }

        public DataType get(@Nonnull SLKState state) {
            return this._vals.get(state.getFieldId());
        }

        public DataType get(@Nonnull String fieldS) {
            return this.get(FieldId.valueOf(fieldS));
        }

        public String getS(@Nonnull FieldId field) {
            if (!this.contains(field)) {
                return null;
            }
            return this.get(field).toString();
        }

        public void set(@Nonnull FieldId fieldId, DataType val) {
            this._vals.put(fieldId, val);
            this.on_set(fieldId, val);
        }

        public void remove(@Nonnull FieldId fieldId) {
            this._vals.remove(fieldId);
            this.on_remove(fieldId);
        }

        public void clear() {
            this._vals.clear();
            this.on_clear();
        }

        public void set(@Nonnull SLKState state, DataType val) {
            this.set((FieldId)state.getFieldId(), val);
            this._stateVals.put(state, val);
        }

        public void setRaw(@Nonnull FieldId field, String val) {
            this.set(field, (DataType)War3String.valueOf(val));
        }

        public void merge(@Nonnull Obj<? extends ObjId> otherObj, boolean overwrite) {
            for (Map.Entry<FieldId, DataType> entry : otherObj.getVals().entrySet()) {
                FieldId field = entry.getKey();
                DataType val = entry.getValue();
                if (!overwrite && this.get(field) != null || val == null) continue;
                this.set(field, val);
            }
        }

        public void merge(@Nonnull Obj<? extends ObjId> otherObj) {
            this.merge(otherObj, true);
        }

        public void print(@Nonnull Printer printer) {
            printer.beginGroup(this._id);
            for (Map.Entry<FieldId, DataType> valEntry : this.getVals().entrySet()) {
                FieldId fieldId = valEntry.getKey();
                DataType val = valEntry.getValue();
                printer.println(fieldId + " -> " + val);
            }
            printer.endGroup();
        }

        public abstract void reduce();

        @Nonnull
        public T getId() {
            return this._id;
        }

        public String toString() {
            return ((War3String)this._id).toString();
        }

        public Obj(@Nonnull T id) {
            this._id = id;
        }
    }

    public static class Field
    implements Printable {
        private FieldId _fieldId;
        private final DataType _defVal;

        public FieldId getFieldId() {
            return this._fieldId;
        }

        @Nullable
        public DataType getDefVal() {
            return this._defVal;
        }

        public Field(@Nonnull FieldId fieldId, @Nullable DataType defVal) {
            this._fieldId = fieldId;
            this._defVal = defVal;
        }

        @Override
        public void print(@Nonnull Printer printer) {
            printer.println(this._fieldId + " (" + this._defVal + ")");
        }
    }
}

