/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.Sys;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\u0005\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0006\u0010$\u001a\u00020\u0004J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010(\u001a\u00020\n2\b\u0010)\u001a\u0004\u0018\u00010\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldorkbox/util/MersenneTwisterFast;", "", "()V", "seed", "", "(J)V", "array", "", "([I)V", "__haveNextNextGaussian", "", "__nextNextGaussian", "", "mag01", "mt", "mti", "", "clearGaussian", "", "nextBoolean", "probability", "", "nextByte", "", "nextBytes", "bytes", "", "nextChar", "", "nextDouble", "includeZero", "includeOne", "nextFloat", "nextGaussian", "nextInt", "n", "nextLong", "nextShort", "", "setSeed", "stateEquals", "other", "Companion", "Utilities"})
public class MersenneTwisterFast {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private int[] mt;
    private int mti;
    @Nullable
    private int[] mag01;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;
    @NotNull
    private static final String version = Sys.INSTANCE.getVersion();
    private static final long serialVersionUID = -8219700664442619525L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;

    public final boolean stateEquals(@Nullable MersenneTwisterFast other) {
        int x;
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.mti != other.mti) {
            return false;
        }
        Intrinsics.checkNotNull((Object)this.mag01);
        int n = this.mag01.length;
        for (x = 0; x < n; ++x) {
            Intrinsics.checkNotNull((Object)this.mag01);
            int n2 = this.mag01[x];
            Intrinsics.checkNotNull((Object)other.mag01);
            if (n2 == other.mag01[x]) continue;
            return false;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        n = this.mt.length;
        for (x = 0; x < n; ++x) {
            Intrinsics.checkNotNull((Object)this.mt);
            int n3 = this.mt[x];
            Intrinsics.checkNotNull((Object)other.mt);
            if (n3 == other.mt[x]) continue;
            return false;
        }
        return true;
    }

    public MersenneTwisterFast() {
        this((long)(Math.random() * (double)Long.MAX_VALUE));
    }

    public MersenneTwisterFast(long seed) {
        this.setSeed(seed);
    }

    public MersenneTwisterFast(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.setSeed(array);
    }

    public final void setSeed(long seed) {
        int[] nArray;
        this.__haveNextNextGaussian = false;
        this.mt = new int[N];
        int[] nArray2 = nArray = new int[2];
        MersenneTwisterFast mersenneTwisterFast = this;
        boolean bl = false;
        it[0] = false;
        it[1] = MATRIX_A;
        mersenneTwisterFast.mag01 = nArray;
        Intrinsics.checkNotNull((Object)this.mt);
        this.mt[0] = (int)(seed & 0xFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < N) {
            Intrinsics.checkNotNull((Object)this.mt);
            Intrinsics.checkNotNull((Object)this.mt);
            int n = this.mt[this.mti - 1];
            Intrinsics.checkNotNull((Object)this.mt);
            this.mt[this.mti] = 1812433253 * (n ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            int n2 = this.mti;
            this.mti = n2 + 1;
        }
    }

    public final void setSeed(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (array.length == 0) {
            throw new IllegalArgumentException("Array length must be greater than zero");
        }
        int i = 0;
        int j = 0;
        int k = 0;
        this.setSeed(19650218L);
        i = 1;
        j = 0;
        int n = k = N > array.length ? N : array.length;
        while (k != 0) {
            Intrinsics.checkNotNull((Object)this.mt);
            Intrinsics.checkNotNull((Object)this.mt);
            int n2 = this.mt[i];
            Intrinsics.checkNotNull((Object)this.mt);
            int n3 = this.mt[i - 1];
            Intrinsics.checkNotNull((Object)this.mt);
            this.mt[i] = (n2 ^ (n3 ^ this.mt[i - 1] >>> 30) * 1664525) + array[j] + j;
            ++j;
            if (++i >= N) {
                Intrinsics.checkNotNull((Object)this.mt);
                Intrinsics.checkNotNull((Object)this.mt);
                this.mt[0] = this.mt[N - 1];
                i = 1;
            }
            if (j >= array.length) {
                j = 0;
            }
            --k;
        }
        for (k = N - 1; k != 0; --k) {
            Intrinsics.checkNotNull((Object)this.mt);
            Intrinsics.checkNotNull((Object)this.mt);
            int n4 = this.mt[i];
            Intrinsics.checkNotNull((Object)this.mt);
            int n5 = this.mt[i - 1];
            Intrinsics.checkNotNull((Object)this.mt);
            this.mt[i] = (n4 ^ (n5 ^ this.mt[i - 1] >>> 30) * 1566083941) - i;
            if (++i < N) continue;
            Intrinsics.checkNotNull((Object)this.mt);
            Intrinsics.checkNotNull((Object)this.mt);
            this.mt[0] = this.mt[N - 1];
            i = 1;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        this.mt[0] = Integer.MIN_VALUE;
    }

    public int nextInt() {
        int y = 0;
        if (this.mti >= N) {
            int kk = 0;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        y = this.mt[n];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        return y;
    }

    public short nextShort() {
        int y = 0;
        if (this.mti >= N) {
            int kk = 0;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        y = this.mt[n];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        return (short)(y >>> 16);
    }

    public char nextChar() {
        int y = 0;
        if (this.mti >= N) {
            int kk = 0;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        y = this.mt[n];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        return (char)(y >>> 16);
    }

    public boolean nextBoolean() {
        int y = 0;
        if (this.mti >= N) {
            int kk = 0;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        y = this.mt[n];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        return y >>> 31 != 0;
    }

    public boolean nextBoolean(float probability) {
        int y = 0;
        if (probability < 0.0f || probability > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0f) {
            return false;
        }
        if (probability == 1.0f) {
            return true;
        }
        if (this.mti >= N) {
            int kk = 0;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        y = this.mt[n];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        return (float)(y >>> 8) / 1.6777216E7f < probability;
    }

    public boolean nextBoolean(double probability) {
        int[] mag01;
        int[] mt;
        int kk;
        int y = 0;
        int z = 0;
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0) {
            return false;
        }
        if (probability == 1.0) {
            return true;
        }
        if (this.mti >= N) {
            kk = 0;
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        kk = this.mti;
        this.mti = kk + 1;
        y = this.mt[kk];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        if (this.mti >= N) {
            kk = 0;
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ z >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[z & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ z >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[z & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            z = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ z >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[z & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        z = this.mt[n];
        z ^= z >>> 11;
        z ^= z << 7 & TEMPERING_MASK_B;
        z ^= z << 15 & TEMPERING_MASK_C;
        z ^= z >>> 18;
        return (double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15 < probability;
    }

    public byte nextByte() {
        int y = 0;
        if (this.mti >= N) {
            int kk = 0;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        y = this.mt[n];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        return (byte)(y >>> 24);
    }

    public void nextBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int y = 0;
        int n = bytes.length;
        for (int x = 0; x < n; ++x) {
            if (this.mti >= N) {
                int kk = 0;
                int[] mt = this.mt;
                int[] mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n2 = mt[kk + M] ^ y >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n2 ^ mag01[y & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n3 = mt[kk + (M - N)] ^ y >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n3 ^ mag01[y & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n4 = mt[M - 1] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n4 ^ mag01[y & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            int n5 = this.mti;
            this.mti = n5 + 1;
            y = this.mt[n5];
            y ^= y >>> 11;
            y ^= y << 7 & TEMPERING_MASK_B;
            y ^= y << 15 & TEMPERING_MASK_C;
            y ^= y >>> 18;
            bytes[x] = (byte)(y >>> 24);
        }
    }

    public final long nextLong() {
        int[] mag01;
        int[] mt;
        int kk;
        int y = 0;
        int z = 0;
        if (this.mti >= N) {
            kk = 0;
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        kk = this.mti;
        this.mti = kk + 1;
        y = this.mt[kk];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        if (this.mti >= N) {
            kk = 0;
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ z >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[z & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ z >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[z & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            z = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ z >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[z & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        z = this.mt[n];
        z ^= z >>> 11;
        z ^= z << 7 & TEMPERING_MASK_B;
        z ^= z << 15 & TEMPERING_MASK_C;
        z ^= z >>> 18;
        return ((long)y << 32) + (long)z;
    }

    public long nextLong(long n) {
        int z;
        int y;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive, got: " + n);
        }
        long bits = 0L;
        long val = 0L;
        do {
            int[] mag01;
            int[] mt;
            int kk;
            y = 0;
            z = 0;
            if (this.mti >= N) {
                kk = 0;
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n2 = mt[kk + M] ^ y >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n2 ^ mag01[y & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n3 = mt[kk + (M - N)] ^ y >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n3 ^ mag01[y & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n4 = mt[M - 1] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n4 ^ mag01[y & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            kk = this.mti;
            this.mti = kk + 1;
            y = this.mt[kk];
            y ^= y >>> 11;
            y ^= y << 7 & TEMPERING_MASK_B;
            y ^= y << 15 & TEMPERING_MASK_C;
            y ^= y >>> 18;
            if (this.mti >= N) {
                kk = 0;
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n5 = mt[kk + M] ^ z >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n5 ^ mag01[z & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n6 = mt[kk + (M - N)] ^ z >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n6 ^ mag01[z & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                z = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n7 = mt[M - 1] ^ z >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n7 ^ mag01[z & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            int n8 = this.mti;
            this.mti = n8 + 1;
            z = this.mt[n8];
            z ^= z >>> 11;
            z ^= z << 7 & TEMPERING_MASK_B;
            z ^= z << 15 & TEMPERING_MASK_C;
        } while ((bits = ((long)y << 32) + (long)(z ^= z >>> 18) >>> 1) - (val = bits % n) + (n - 1L) < 0L);
        return val;
    }

    public double nextDouble() {
        int[] mag01;
        int[] mt;
        int kk;
        int y = 0;
        int z = 0;
        if (this.mti >= N) {
            kk = 0;
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        kk = this.mti;
        this.mti = kk + 1;
        y = this.mt[kk];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        if (this.mti >= N) {
            kk = 0;
            mt = this.mt;
            mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ z >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[z & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ z >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[z & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            z = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ z >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[z & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        z = this.mt[n];
        z ^= z >>> 11;
        z ^= z << 7 & TEMPERING_MASK_B;
        z ^= z << 15 & TEMPERING_MASK_C;
        z ^= z >>> 18;
        return (double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15;
    }

    public double nextDouble(boolean includeZero, boolean includeOne) {
        double d = 0.0;
        do {
            d = this.nextDouble();
            if (!includeOne || !this.nextBoolean()) continue;
            d += 1.0;
        } while (d > 1.0 || !includeZero && d == 0.0);
        return d;
    }

    public final void clearGaussian() {
        this.__haveNextNextGaussian = false;
    }

    public double nextGaussian() {
        int b;
        int a;
        int z;
        int y;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        double v1 = 0.0;
        double v2 = 0.0;
        double s = 0.0;
        do {
            int[] mag01;
            int[] mt;
            int kk;
            y = 0;
            z = 0;
            a = 0;
            b = 0;
            if (this.mti >= N) {
                kk = 0;
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n = mt[kk + M] ^ y >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n ^ mag01[y & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n = mt[kk + (M - N)] ^ y >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n ^ mag01[y & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n = mt[M - 1] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            kk = this.mti;
            this.mti = kk + 1;
            y = this.mt[kk];
            y ^= y >>> 11;
            y ^= y << 7 & TEMPERING_MASK_B;
            y ^= y << 15 & TEMPERING_MASK_C;
            y ^= y >>> 18;
            if (this.mti >= N) {
                kk = 0;
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n = mt[kk + M] ^ z >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n ^ mag01[z & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    z = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n = mt[kk + (M - N)] ^ z >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n ^ mag01[z & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                z = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n = mt[M - 1] ^ z >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n ^ mag01[z & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            kk = this.mti;
            this.mti = kk + 1;
            z = this.mt[kk];
            z ^= z >>> 11;
            z ^= z << 7 & TEMPERING_MASK_B;
            z ^= z << 15 & TEMPERING_MASK_C;
            z ^= z >>> 18;
            if (this.mti >= N) {
                kk = 0;
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    a = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n = mt[kk + M] ^ a >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n ^ mag01[a & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    a = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n = mt[kk + (M - N)] ^ a >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n ^ mag01[a & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                a = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n = mt[M - 1] ^ a >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n ^ mag01[a & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            kk = this.mti;
            this.mti = kk + 1;
            a = this.mt[kk];
            a ^= a >>> 11;
            a ^= a << 7 & TEMPERING_MASK_B;
            a ^= a << 15 & TEMPERING_MASK_C;
            a ^= a >>> 18;
            if (this.mti >= N) {
                kk = 0;
                mt = this.mt;
                mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    b = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n = mt[kk + M] ^ b >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n ^ mag01[b & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    b = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n = mt[kk + (M - N)] ^ b >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n ^ mag01[b & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                b = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n = mt[M - 1] ^ b >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n ^ mag01[b & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            int n = this.mti;
            this.mti = n + 1;
            b = this.mt[n];
            b ^= b >>> 11;
            b ^= b << 7 & TEMPERING_MASK_B;
            b ^= b << 15 & TEMPERING_MASK_C;
        } while ((s = (v1 = (double)2 * ((double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15) - 1.0) * v1 + (v2 = (double)2 * ((double)(((long)(a >>> 6) << 27) + (long)((b ^= b >>> 18) >>> 5)) / 9.007199254740992E15) - 1.0) * v2) >= 1.0 || s == 0.0);
        double multiplier = Math.sqrt((double)-2 * Math.log(s) / s);
        this.__nextNextGaussian = v2 * multiplier;
        this.__haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public float nextFloat() {
        int y = 0;
        if (this.mti >= N) {
            int kk = 0;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < N - M; ++kk) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + M] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
            }
            while (kk < N - 1) {
                Intrinsics.checkNotNull((Object)mt);
                y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                int n = mt[kk + (M - N)] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[kk] = n ^ mag01[y & 1];
                ++kk;
            }
            Intrinsics.checkNotNull((Object)mt);
            y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
            int n = mt[M - 1] ^ y >>> 1;
            Intrinsics.checkNotNull((Object)mag01);
            mt[MersenneTwisterFast.N - 1] = n ^ mag01[y & 1];
            this.mti = 0;
        }
        Intrinsics.checkNotNull((Object)this.mt);
        int n = this.mti;
        this.mti = n + 1;
        y = this.mt[n];
        y ^= y >>> 11;
        y ^= y << 7 & TEMPERING_MASK_B;
        y ^= y << 15 & TEMPERING_MASK_C;
        y ^= y >>> 18;
        return (float)(y >>> 8) / 1.6777216E7f;
    }

    public float nextFloat(boolean includeZero, boolean includeOne) {
        float d = 0.0f;
        do {
            d = this.nextFloat();
            if (!includeOne || !this.nextBoolean()) continue;
            d += 1.0f;
        } while (d > 1.0f || !includeZero && d == 0.0f);
        return d;
    }

    public int nextInt(int n) {
        int y;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive, got: " + n);
        }
        if ((n & -n) == n) {
            int kk;
            int y2 = 0;
            if (this.mti >= N) {
                kk = 0;
                int[] mt = this.mt;
                int[] mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    y2 = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n2 = mt[kk + M] ^ y2 >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n2 ^ mag01[y2 & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    y2 = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n3 = mt[kk + (M - N)] ^ y2 >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n3 ^ mag01[y2 & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                y2 = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n4 = mt[M - 1] ^ y2 >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n4 ^ mag01[y2 & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            kk = this.mti;
            this.mti = kk + 1;
            y2 = this.mt[kk];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & TEMPERING_MASK_B;
            y2 ^= y2 << 15 & TEMPERING_MASK_C;
            y2 ^= y2 >>> 18;
            return (int)((long)n * (long)(y2 >>> 1) >> 31);
        }
        int bits = 0;
        int val = 0;
        do {
            y = 0;
            if (this.mti >= N) {
                int kk = 0;
                int[] mt = this.mt;
                int[] mag01 = this.mag01;
                for (kk = 0; kk < N - M; ++kk) {
                    Intrinsics.checkNotNull((Object)mt);
                    y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n5 = mt[kk + M] ^ y >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n5 ^ mag01[y & 1];
                }
                while (kk < N - 1) {
                    Intrinsics.checkNotNull((Object)mt);
                    y = mt[kk] & UPPER_MASK | mt[kk + 1] & LOWER_MASK;
                    int n6 = mt[kk + (M - N)] ^ y >>> 1;
                    Intrinsics.checkNotNull((Object)mag01);
                    mt[kk] = n6 ^ mag01[y & 1];
                    ++kk;
                }
                Intrinsics.checkNotNull((Object)mt);
                y = mt[N - 1] & UPPER_MASK | mt[0] & LOWER_MASK;
                int n7 = mt[M - 1] ^ y >>> 1;
                Intrinsics.checkNotNull((Object)mag01);
                mt[MersenneTwisterFast.N - 1] = n7 ^ mag01[y & 1];
                this.mti = 0;
            }
            Intrinsics.checkNotNull((Object)this.mt);
            int n8 = this.mti;
            this.mti = n8 + 1;
            y = this.mt[n8];
            y ^= y >>> 11;
            y ^= y << 7 & TEMPERING_MASK_B;
            y ^= y << 15 & TEMPERING_MASK_C;
        } while ((bits = (y ^= y >>> 18) >>> 1) - (val = bits % n) + (n - 1) < 0);
        return val;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldorkbox/util/MersenneTwisterFast$Companion;", "", "()V", "LOWER_MASK", "", "M", "MATRIX_A", "N", "TEMPERING_MASK_B", "TEMPERING_MASK_C", "UPPER_MASK", "serialVersionUID", "", "version", "", "getVersion", "()Ljava/lang/String;", "Utilities"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVersion() {
            return version;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

