/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.gui;

import com.google.common.base.Preconditions;
import de.peeeq.wurstio.gui.WurstErrorWindow;
import de.peeeq.wurstio.gui.WurstStatusWindow;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.eclipse.jdt.annotation.Nullable;

public class WurstGuiImpl
extends WurstGui {
    private final Queue<CompileError> errorQueue = new ConcurrentLinkedQueue<CompileError>();
    private volatile double progress = 0.0;
    private volatile boolean finished = false;
    private volatile @Nullable String currentlyWorkingOn = "";
    private final GuiUpdater guiUpdater;
    private final Object progressLock = new Object();
    private String workspaceRoot;
    private static final ConcurrentHashMap<String, Long> staticLastTimes = new ConcurrentHashMap();
    private final Map<String, Long> lastTimes = new HashMap<String, Long>(staticLastTimes);
    boolean show = true;
    private final long startTime = System.currentTimeMillis();
    private final Set<String> done = new HashSet<String>();
    private long taskStartTime = this.startTime;

    public WurstGuiImpl() {
        this.guiUpdater = new GuiUpdater();
        this.guiUpdater.start();
    }

    public WurstGuiImpl(String workspaceRoot) {
        this();
        this.workspaceRoot = workspaceRoot;
    }

    @Override
    public void sendError(CompileError err) {
        super.sendError(err);
        if (err.getErrorType() == CompileError.ErrorType.ERROR) {
            this.errorQueue.add(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendProgress(String whatsRunningNow) {
        if (whatsRunningNow != null) {
            WLogger.info("progress: " + whatsRunningNow);
        }
        if (whatsRunningNow == null || this.done.contains(whatsRunningNow)) {
            return;
        }
        long overAllTime = 0L;
        long doneTime = 0L;
        for (Map.Entry<String, Long> e : staticLastTimes.entrySet()) {
            if (this.done.contains(e.getKey())) {
                doneTime += e.getValue().longValue();
            }
            overAllTime += e.getValue().longValue();
        }
        long currentTime = System.currentTimeMillis();
        this.lastTimes.put(whatsRunningNow, currentTime - this.taskStartTime);
        this.taskStartTime = currentTime;
        this.currentlyWorkingOn = whatsRunningNow;
        this.done.add(whatsRunningNow);
        this.progress = overAllTime > 0L ? (double)doneTime * 1.0 / (double)overAllTime : (double)(System.currentTimeMillis() - this.startTime) / 30000.0;
        Object object = this.progressLock;
        synchronized (object) {
            this.progressLock.notifyAll();
        }
    }

    @Override
    public void sendFinished() {
        this.finished = true;
        staticLastTimes.putAll(this.lastTimes);
    }

    @Override
    public void showInfoMessage(String message) {
        try {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, message));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    class GuiUpdater
    extends Thread {
        private @Nullable WurstStatusWindow statusWindow = null;
        private @Nullable WurstErrorWindow errorWindow = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.statusWindow = new WurstStatusWindow();
                    this.errorWindow = new WurstErrorWindow(WurstGuiImpl.this.workspaceRoot);
                    this.errorWindow.repaint();
                    this.statusWindow.repaint();
                    this.errorWindow.toFront();
                    this.statusWindow.toFront();
                    this.errorWindow.setAlwaysOnTop(true);
                    this.statusWindow.setAlwaysOnTop(true);
                    this.statusWindow.setDefaultCloseOperation(2);
                    this.errorWindow.setDefaultCloseOperation(2);
                });
                final WurstStatusWindow statusWindow = this.statusWindow;
                final WurstErrorWindow errorWindow = this.errorWindow;
                Preconditions.checkNotNull((Object)statusWindow);
                Preconditions.checkNotNull((Object)errorWindow);
                while (!WurstGuiImpl.this.finished || !WurstGuiImpl.this.errorQueue.isEmpty()) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            CompileError elem = this.pollErrorQueue();
                            while (elem != null) {
                                errorWindow.sendError(elem);
                                elem = this.pollErrorQueue();
                            }
                            statusWindow.sendProgress(WurstGuiImpl.this.currentlyWorkingOn, WurstGuiImpl.this.progress);
                        }

                        private @Nullable CompileError pollErrorQueue() {
                            return WurstGuiImpl.this.errorQueue.poll();
                        }
                    });
                    Object object = WurstGuiImpl.this.progressLock;
                    synchronized (object) {
                        WurstGuiImpl.this.progressLock.wait(300L);
                    }
                }
                SwingUtilities.invokeAndWait(() -> {
                    if (WurstGuiImpl.this.getErrorCount() == 0) {
                        errorWindow.sendFinished();
                    }
                    statusWindow.sendFinished();
                });
            }
            catch (Throwable e) {
                WLogger.severe(e);
                throw new Error(e);
            }
        }
    }
}

