/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.parser;

import com.google.common.collect.ImmutableList;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.LineOffsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class WPosWithComments
extends WPos {
    private List<Comment> commentsBefore = Collections.emptyList();
    private List<Comment> commentsAfter = Collections.emptyList();

    public WPosWithComments(String file, @Nullable LineOffsets lineOffsets, int leftPos, int rightPos) {
        super(file, lineOffsets, leftPos, rightPos);
    }

    public static List<Comment> createList(CompilationUnit cu) {
        return new ArrayList<Comment>();
    }

    public void addCommentBefore(Comment comment) {
        this.commentsBefore = ImmutableList.builder().addAll(this.commentsBefore).add((Object)comment).build();
    }

    public void addCommentAfter(Comment comment) {
        this.commentsAfter = ImmutableList.builder().addAll(this.commentsAfter).add((Object)comment).build();
    }

    public List<Comment> getCommentsBefore() {
        return this.commentsBefore;
    }

    public List<Comment> getCommentsAfter() {
        return this.commentsAfter;
    }

    public static class Comment {
        private final WPos pos;
        private final String content;
        private final boolean singleLine;

        public Comment(WPos pos, String content, boolean singleLine) {
            this.pos = pos;
            this.content = content;
            this.singleLine = singleLine;
        }

        public WPos getPos() {
            return this.pos;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isSingleLine() {
            return this.singleLine;
        }
    }
}

