/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.StmtCall;
import de.peeeq.wurstscript.types.FunctionSignature;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class SignatureInfo
extends UserRequest<SignatureHelp> {
    private final WFile filename;
    private final int line;
    private final int column;

    public SignatureInfo(TextDocumentPositionParams position) {
        this.filename = WFile.create(position.getTextDocument().getUri());
        this.line = position.getPosition().getLine() + 1;
        this.column = position.getPosition().getCharacter() + 1;
    }

    @Override
    public SignatureHelp execute(ModelManager modelManager) {
        CompilationUnit cu = modelManager.getCompilationUnit(this.filename);
        Optional<Element> e = Utils.getAstElementAtPos(cu, this.line, this.column, false);
        if (e.get() instanceof StmtCall) {
            StmtCall call = (StmtCall)e.get();
            return this.forCall(call);
        }
        while (e.isPresent()) {
            Optional parent = e.flatMap(el -> Optional.ofNullable(el.getParent()));
            if (parent.isPresent() && parent.get() instanceof Arguments) {
                Arguments args = (Arguments)parent.get();
                if (!(((Element)parent.get()).getParent() instanceof StmtCall)) break;
                StmtCall call = (StmtCall)((Element)parent.get()).getParent();
                SignatureHelp info = this.forCall(call);
                info.setActiveParameter(Integer.valueOf(args.indexOf(e)));
                return info;
            }
            if (parent.isPresent() && parent.get() instanceof StmtCall) {
                StmtCall call = (StmtCall)parent.get();
                return this.forCall(call);
            }
            e = parent;
        }
        return new SignatureHelp(Collections.emptyList(), Integer.valueOf(0), Integer.valueOf(0));
    }

    private SignatureHelp forCall(StmtCall call) {
        FunctionSignature sig = call.attrFunctionSignature();
        SignatureHelp help = new SignatureHelp();
        SignatureInformation info = new SignatureInformation();
        info.setDocumentation("(" + sig.getParameterDescription() + ")");
        if (call instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)call;
            info.setLabel(fc.getFuncName());
        } else if (call instanceof ExprNewObject) {
            ExprNewObject n = (ExprNewObject)call;
            info.setLabel(n.getTypeName());
        }
        int i = 0;
        info.setParameters(new ArrayList());
        for (WurstType t : sig.getParamTypes()) {
            String paramName = sig.getParamName(i);
            info.getParameters().add(new ParameterInformation(paramName, t + " " + paramName));
            ++i;
        }
        help.getSignatures().add(info);
        return help;
    }
}

