/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public abstract class WFile {
    private WFile() {
    }

    public static WFile create(File f) {
        return new Ok(f);
    }

    public static WFile create(Path f) {
        return new Ok(f.toFile());
    }

    public static WFile create(URI f) {
        try {
            return new Ok(new File(f));
        }
        catch (IllegalArgumentException e) {
            return new Unsupported(f.toString());
        }
    }

    public static WFile create(String uri) {
        try {
            URI u = new URI(uri);
            if (u.isAbsolute()) {
                return WFile.create(u);
            }
        }
        catch (URISyntaxException u) {
            // empty catch block
        }
        try {
            return WFile.create(Paths.get(uri, new String[0]));
        }
        catch (InvalidPathException e2) {
            throw new RuntimeException("URI string '" + uri + "' is neither a correct URI nor a correct path.", e2);
        }
    }

    public static WFile create(TextDocumentIdentifier textDocument) {
        return WFile.create(textDocument.getUri());
    }

    public abstract File getFile() throws FileNotFoundException;

    public abstract String getUriString();

    public abstract Path getPath() throws FileNotFoundException;

    private static class Ok
    extends WFile {
        private final File file;

        private Ok(File file) {
            try {
                file = file.getAbsoluteFile().getCanonicalFile();
            }
            catch (Exception e) {
                file = file.getAbsoluteFile();
            }
            this.file = file;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ok wFile = (Ok)o;
            return Objects.equals(this.file, wFile.file);
        }

        public int hashCode() {
            return Objects.hash(this.file);
        }

        public String toString() {
            return this.file.toString();
        }

        @Override
        public String getUriString() {
            return this.getFile().toURI().toString();
        }

        @Override
        public Path getPath() {
            return this.file.toPath();
        }
    }

    private static class Unsupported
    extends WFile {
        private final String uriString;

        public Unsupported(String uriString) {
            this.uriString = uriString;
        }

        @Override
        public File getFile() throws FileNotFoundException {
            throw new FileNotFoundException("URI " + this.uriString + " is not supported.");
        }

        @Override
        public String getUriString() {
            return this.uriString;
        }

        @Override
        public Path getPath() throws FileNotFoundException {
            throw new FileNotFoundException("URI " + this.uriString + " is not supported.");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unsupported that = (Unsupported)o;
            return Objects.equals(this.uriString, that.uriString);
        }

        public int hashCode() {
            return Objects.hash(this.uriString);
        }

        public String toString() {
            return this.uriString;
        }
    }
}

