/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.base.Preconditions;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import java.util.HashMap;
import java.util.Map;

public class ReferenceRewritingCopy {
    public static <T extends Element> T copy(T elem) {
        Element copy = elem.copy();
        Map<Element, Element> oldToNew = ReferenceRewritingCopy.calcOldToNew(elem, copy);
        ReferenceRewritingCopy.rewriteReferences(copy, oldToNew);
        return (T)copy;
    }

    private static <T extends Element> void rewriteReferences(T copy, final Map<Element, Element> oldToNew) {
        copy.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImVar e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getType());
                if (newChild != null) {
                    e.setType((ImType)newChild);
                }
            }

            @Override
            public void visit(ImFunction e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getReturnType());
                if (newChild != null) {
                    e.setReturnType((ImType)newChild);
                }
            }

            @Override
            public void visit(ImMethod e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getImplementation());
                if (newChild != null) {
                    e.setImplementation((ImFunction)newChild);
                }
            }

            @Override
            public void visit(ImVarargLoop e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getLoopVar());
                if (newChild != null) {
                    e.setLoopVar((ImVar)newChild);
                }
            }

            @Override
            public void visit(ImVarAccess e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getVar());
                if (newChild != null) {
                    e.setVar((ImVar)newChild);
                }
            }

            @Override
            public void visit(ImVarArrayAccess e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getVar());
                if (newChild != null) {
                    e.setVar((ImVar)newChild);
                }
            }

            @Override
            public void visit(ImMethodCall e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getMethod());
                if (newChild != null) {
                    e.setMethod((ImMethod)newChild);
                }
            }

            @Override
            public void visit(ImAlloc e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getClazz());
                if (newChild != null) {
                    e.setClazz((ImClassType)newChild);
                }
            }

            @Override
            public void visit(ImDealloc e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getClazz());
                if (newChild != null) {
                    e.setClazz((ImClassType)newChild);
                }
            }

            @Override
            public void visit(ImMemberAccess e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getVar());
                if (newChild != null) {
                    e.setVar((ImVar)newChild);
                }
            }

            @Override
            public void visit(ImInstanceof e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getClazz());
                if (newChild != null) {
                    e.setClazz((ImClassType)newChild);
                }
            }

            @Override
            public void visit(ImTypeIdOfObj e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getClazz());
                if (newChild != null) {
                    e.setClazz((ImClassType)newChild);
                }
            }

            @Override
            public void visit(ImTypeIdOfClass e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getClazz());
                if (newChild != null) {
                    e.setClazz((ImClassType)newChild);
                }
            }

            @Override
            public void visit(ImFunctionCall e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getFunc());
                if (newChild != null) {
                    e.setFunc((ImFunction)newChild);
                }
            }

            @Override
            public void visit(ImFuncRef e) {
                super.visit(e);
                Element newChild = (Element)oldToNew.get(e.getFunc());
                if (newChild != null) {
                    e.setFunc((ImFunction)newChild);
                }
            }
        });
    }

    private static <T extends Element> Map<Element, Element> calcOldToNew(T elem, T copy) {
        HashMap<Element, Element> result = new HashMap<Element, Element>();
        ReferenceRewritingCopy.calcOldToNew(elem, copy, result);
        return result;
    }

    private static <T extends Element> void calcOldToNew(T elem, T copy, HashMap<Element, Element> result) {
        Preconditions.checkArgument((elem.size() == copy.size() ? 1 : 0) != 0);
        result.put(elem, copy);
        for (int i = 0; i < elem.size(); ++i) {
            ReferenceRewritingCopy.calcOldToNew(elem.get(i), copy.get(i), result);
        }
    }
}

