/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.peeeq.datastructures.Deferred;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.NameLinkType;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeVararg;
import de.peeeq.wurstscript.utils.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;

public class VarLink
extends DefLink {
    private final NameDef def;
    private final Deferred<WurstType> type;

    public VarLink(Visibility visibility, WScope definedIn, List<TypeParamDef> typeParams, @Nullable WurstType receiverType, NameDef def, Deferred<WurstType> type) {
        super(visibility, definedIn, typeParams, receiverType);
        this.def = def;
        this.type = type;
    }

    public static VarLink create(TypeDef def, WScope definedIn) {
        Visibility visibility = VarLink.calcVisibility(definedIn, def);
        List<TypeParamDef> typeParams = Streams.concat((Stream[])new Stream[]{VarLink.typeParams(definedIn), VarLink.typeParams(def)}).collect(Collectors.toList());
        WurstType lreceiverType = VarLink.calcReceiverType(definedIn, def);
        WurstType type = def.attrTyp();
        return new VarLink(visibility, definedIn, typeParams, lreceiverType, def, new Deferred<WurstType>(type));
    }

    public static VarLink create(EnumMember def, WScope definedIn) {
        Visibility visibility = VarLink.calcVisibility(definedIn, def);
        List<TypeParamDef> typeParams = Streams.concat((Stream[])new Stream[]{VarLink.typeParams(definedIn), VarLink.typeParams(def)}).collect(Collectors.toList());
        WurstType lreceiverType = VarLink.calcReceiverType(definedIn, def);
        WurstType type = def.attrTyp();
        return new VarLink(visibility, definedIn, typeParams, lreceiverType, def, new Deferred<WurstType>(type));
    }

    public static VarLink create(VarDef def, WScope definedIn) {
        Deferred<Object> type;
        Visibility visibility = VarLink.calcVisibility(definedIn, def);
        List<TypeParamDef> typeParams = Streams.concat((Stream[])new Stream[]{VarLink.typeParams(definedIn), VarLink.typeParams(def)}).collect(Collectors.toList());
        WurstType lreceiverType = VarLink.calcReceiverType(definedIn, def);
        if (def.attrOptTypeExpr() instanceof TypeExpr) {
            TypeExpr typeExpr = (TypeExpr)def.attrOptTypeExpr();
            WurstType t = typeExpr.attrTyp().dynamic();
            if (def.attrIsVararg()) {
                t = new WurstTypeVararg(t);
            }
            type = new Deferred<WurstType>(t);
        } else {
            type = new Deferred<Supplier<WurstType>>(def::attrTyp);
        }
        return new VarLink(visibility, definedIn, typeParams, lreceiverType, def, type);
    }

    private static @Nullable WurstType calcReceiverType(WScope definedIn, NameDef nameDef) {
        if (nameDef instanceof GlobalVarDef) {
            return VarLink.getReceiverType(definedIn);
        }
        Element parent = nameDef.getParent();
        Preconditions.checkNotNull((Object)parent);
        Element grandParent = parent.getParent();
        if (nameDef instanceof WParameter) {
            if (grandParent instanceof TupleDef) {
                TupleDef tupleDef = (TupleDef)grandParent;
                return tupleDef.attrTyp();
            }
        } else if (nameDef instanceof EnumMember && grandParent instanceof EnumDef) {
            EnumDef enumDef = (EnumDef)grandParent;
            return enumDef.attrTyp();
        }
        return null;
    }

    public static OptTypeExpr getTypeExpr(WParameter p) {
        return p.getTyp();
    }

    public static OptTypeExpr getTypeExpr(WShortParameter p) {
        return p.getTypOpt();
    }

    public static OptTypeExpr getTypeExpr(GlobalVarDef p) {
        return p.getOptTyp();
    }

    public static OptTypeExpr getTypeExpr(LocalVarDef p) {
        return p.getOptTyp();
    }

    @Override
    public String getName() {
        return this.def.getName();
    }

    @Override
    public NameDef getDef() {
        return this.def;
    }

    @Override
    public VarLink withVisibility(Visibility newVis) {
        if (newVis == this.getVisibility()) {
            return this;
        }
        return new VarLink(newVis, this.getDefinedIn(), this.getTypeParams(), this.getReceiverType(), this.def, this.type);
    }

    @Override
    public NameLinkType getType() {
        return NameLinkType.VAR;
    }

    public String toString() {
        String r = this.getVisibility() + " ";
        if (this.getReceiverType() != null) {
            r = r + this.getReceiverType() + ".";
        }
        return r + Utils.printElementWithSource(Optional.of(this.def));
    }

    @Override
    public VarLink withTypeArgBinding(Element context, VariableBinding binding) {
        if (binding.isEmpty()) {
            return this;
        }
        Deferred<WurstType> newType = this.type.map(oldType -> oldType.setTypeArgs(binding));
        boolean changed = newType != this.type;
        WurstType newReceiverType = this.getReceiverType().setTypeArgs(binding);
        if (changed |= newReceiverType != this.getReceiverType()) {
            List<TypeParamDef> newTypeParams = this.getTypeParams().stream().filter(binding::contains).collect(Collectors.toList());
            return new VarLink(this.getVisibility(), this.getDefinedIn(), newTypeParams, newReceiverType, this.def, newType);
        }
        return this;
    }

    @Override
    public DefLink withGenericTypeParams(List<TypeParamDef> typeParams) {
        if (typeParams.isEmpty()) {
            return this;
        }
        ImmutableList newTypeParams = Utils.concatLists(this.getTypeParams(), typeParams);
        return new VarLink(this.getVisibility(), this.getDefinedIn(), (List<TypeParamDef>)newTypeParams, this.getReceiverType(), this.def, this.type);
    }

    @Override
    public WurstType getTyp() {
        return this.type.get();
    }

    @Override
    public VarLink withDef(NameDef def) {
        return new VarLink(this.getVisibility(), this.getDefinedIn(), this.getTypeParams(), this.getReceiverType(), def, this.type);
    }

    public VarLink withConfigDef() {
        VarDef def = (VarDef)this.def.attrConfigActualNameDef();
        return new VarLink(this.getVisibility(), this.getDefinedIn(), this.getTypeParams(), this.getReceiverType(), def, this.type);
    }

    @Override
    public VarLink hidingPrivate() {
        return (VarLink)super.hidingPrivate();
    }

    @Override
    public VarLink hidingPrivateAndProtected() {
        return (VarLink)super.hidingPrivateAndProtected();
    }

    @Override
    public VarLink adaptToReceiverType(WurstType receiverType) {
        return (VarLink)super.adaptToReceiverType(receiverType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarLink varLink = (VarLink)o;
        return Objects.equals(this.def, varLink.def);
    }

    public int hashCode() {
        return Objects.hash(this.def);
    }
}

