/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;

public class RunArgs {
    private final String[] args;
    private final RunOption optionLua;
    private final RunOption optionCompiletimeCache;
    private final List<String> files = Lists.newArrayList();
    private @Nullable String mapFile = null;
    private @Nullable String outFile = null;
    private @Nullable String workspaceroot = null;
    private @Nullable String inputmap = null;
    private @Nullable int testTimeout = 20;
    private final List<RunOption> options = Lists.newArrayList();
    private final List<File> libDirs = Lists.newArrayList();
    private final RunOption optionHelp;
    private final RunOption optionOpt;
    private final RunOption optionInline;
    private final RunOption optionLocalOptimizations;
    private final RunOption optionRuntests;
    private final RunOption optionGui;
    private final RunOption optionAbout;
    private final RunOption optionHotdoc;
    private final RunOption optionShowErrors;
    private final RunOption optionRunCompileTimeFunctions;
    private final RunOption optionStacktraces;
    private final RunOption uncheckedDispatch;
    private final RunOption optionNodebug;
    private final RunOption optionInjectCompiletimeObjects;
    private final RunOption optionExtractImports;
    private final RunOption optionStartServer;
    private final RunOption optionLanguageServer;
    private final RunOption optionNoExtractMapScript;
    private final RunOption optionFixInstall;
    private final RunOption optionCopyMap;
    private final RunOption optionDisablePjass;
    private final RunOption optionShowVersion;
    private final RunOption optionPrettyPrint;
    private final RunOption optionMeasureTimes;
    private final RunOption optionHotStartmap;
    private final RunOption optionHotReload;
    private final RunOption optionTestTimeout;
    private int functionSplitLimit = 10000;
    private final RunOption optionBuild;

    public RunArgs with(String ... additionalArgs) {
        return new RunArgs((String[])Stream.concat(Stream.of(this.args), Stream.of(additionalArgs)).toArray(String[]::new));
    }

    public static RunArgs defaults() {
        return new RunArgs(new String[0]);
    }

    public RunArgs(String ... args) {
        this.args = args;
        this.optionRuntests = this.addOption("runtests", "Run all test functions found in the scripts.");
        this.optionTestTimeout = this.addOptionWithArg("testTimeout", "Timeout in seconds after which tests will be cancelled and considered failed, if they did not yet succeed.", arg -> {
            this.testTimeout = Integer.parseInt(arg);
        });
        this.optionRunCompileTimeFunctions = this.addOption("runcompiletimefunctions", "Run all compiletime functions found in the scripts.");
        this.optionInjectCompiletimeObjects = this.addOption("injectobjects", "Injects the objects generated by compiletime functions into the map.");
        this.optionOpt = this.addOption("opt", "Enables identifier name compression and whitespace removal.");
        this.optionInline = this.addOption("inline", "Enables function inlining.");
        this.optionLocalOptimizations = this.addOption("localOptimizations", "Enables local optimizations (cpu and ram extensive, recommended for release)");
        this.optionStacktraces = this.addOption("stacktraces", "Generate stacktrace information in the script (useful for debugging).");
        this.optionNodebug = this.addOption("nodebug", "Remove all error messages from the script. (Not recommended)");
        this.uncheckedDispatch = this.addOption("uncheckedDispatch", "(dangerous) Removes checks from method-dispatch code. With unchecked dispatch some programming errors like null-pointer-dereferences or accessing of destroyed objects can no longer be detected. It is strongly recommended to not use this option, but it can give some performance benefits.");
        this.optionMeasureTimes = this.addOption("measure", "Measure how long each step of the translation process takes.");
        this.optionAbout = this.addOption("-about", "Show the 'about' window.");
        this.optionFixInstall = this.addOption("-fixInstallation", "Checks your wc3 installation and applies compatibility fixes");
        this.optionCopyMap = this.addOption("-copyMap", "copies map");
        this.optionStartServer = this.addOption("-startServer", "Starts the compilation server.");
        this.optionHotdoc = this.addOption("-hotdoc", "Generate hotdoc html documentation.");
        this.optionShowErrors = this.addOption("-showerrors", "(currently not implemented.) Show errors generated by last compile.");
        this.optionExtractImports = this.addOptionWithArg("-extractImports", "Extract all files from a map into a folder next to the mapp.", arg -> {
            this.mapFile = arg;
        });
        this.optionShowVersion = this.addOption("-version", "Shows the version of the compiler");
        this.optionNoExtractMapScript = this.addOption("noExtractMapScript", "Do not extract the map script from the map and use the one from the Wurst folder instead.");
        this.optionGui = this.addOption("gui", "Show a graphical user interface (progress bar and error window).");
        this.addOptionWithArg("lib", "The next argument should be a library folder which is lazily added to the build.", arg -> this.libDirs.add(new File((String)arg)));
        this.addOptionWithArg("out", "Outputs the compiled script to this file.", arg -> {
            this.outFile = arg;
        });
        this.optionLanguageServer = this.addOption("languageServer", "Starts a language server which can be used by editors to get services like code completion, validations, and find declaration. The communication to the language server is via standard input output.");
        this.optionHelp = this.addOption("help", "Prints this help message.");
        this.optionDisablePjass = this.addOption("noPJass", "Disables PJass checks for the generated code.");
        this.optionHotStartmap = this.addOption("hotstart", "Uses Jass Hot Code Reload (JHCR) to start the map.");
        this.optionHotReload = this.addOption("hotreload", "Reloads the mapscript after running the map with Jass Hot Code Reload (JHCR).");
        this.optionBuild = this.addOption("build", "Builds an output map from the input map and library directories.");
        this.addOptionWithArg("workspaceroot", "The next argument should be the root folder of the project to build.", arg -> {
            this.workspaceroot = arg;
        });
        this.addOptionWithArg("inputmap", "The next argument should be the input map.", arg -> {
            this.inputmap = arg;
        });
        this.optionLua = this.addOption("lua", "Choose Lua as the compilation target.");
        this.optionCompiletimeCache = this.addOption("compiletimeCache", "(Experimental) Cache results of compiletime invocations without side effects");
        this.addOptionWithArg("functionSplitLimit", "The maximum number of operations in a function before it is split by the function splitter (used for compiletime functions)", s -> {
            this.functionSplitLimit = Integer.parseInt(s, 10);
        });
        this.optionPrettyPrint = this.addOption("prettyPrint", "Pretty print the input file, or all sub-directory if the given path is: '...'");
        block0: for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.startsWith("-")) {
                for (RunOption o : this.options) {
                    if (("-" + o.name).equals(a)) {
                        Consumer<String> argHandler = o.argHandler;
                        if (argHandler != null) {
                            argHandler.accept(args[++i]);
                        }
                        o.isSet = true;
                        continue block0;
                    }
                    if (o.argHandler == null || !this.isDoubleArg(a, o)) continue;
                    continue block0;
                }
                throw new RuntimeException("Unknown option: " + a);
            }
            this.files.add(a);
            if (!a.endsWith(".w3x") && !a.endsWith(".w3m")) continue;
            this.mapFile = a;
        }
        if (this.optionHelp.isSet) {
            this.printHelpAndExit();
        }
    }

    private boolean isDoubleArg(String arg, RunOption option) {
        return arg.contains(" ") && ("-" + option.name).equals(arg.substring(0, arg.indexOf(" ")));
    }

    private RunOption addOption(String name, String descr) {
        RunOption opt = new RunOption(name, descr);
        this.options.add(opt);
        return opt;
    }

    private RunOption addOptionWithArg(String name, String descr, Consumer<String> argHandler) {
        RunOption opt = new RunOption(name, descr, argHandler);
        this.options.add(opt);
        return opt;
    }

    public RunArgs(List<String> runArgs) {
        this(runArgs.toArray(new String[0]));
    }

    public void printHelpAndExit() {
        System.out.println("Usage: ");
        System.out.println("wurst <options> <files>");
        System.out.println();
        System.out.println("Example: wurst -opt common.j Blizzard.j myMap.w3x");
        System.out.println("Compiles the given map with the two script files and optimizations enabled.");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        for (RunOption opt : this.options) {
            System.out.println("-" + opt.name);
            System.out.println("\t" + opt.descr);
            System.out.println();
        }
    }

    public List<String> getFiles() {
        return this.files;
    }

    public boolean isOptimize() {
        return this.optionOpt.isSet;
    }

    public boolean isGui() {
        return this.optionGui.isSet;
    }

    public @Nullable String getMapFile() {
        return this.mapFile;
    }

    public void setMapFile(String file) {
        this.mapFile = file;
    }

    public @Nullable String getOutFile() {
        return this.outFile;
    }

    public boolean showAbout() {
        return this.optionAbout.isSet;
    }

    public boolean isFixInstall() {
        return this.optionFixInstall.isSet;
    }

    public boolean isStartServer() {
        return this.optionStartServer.isSet;
    }

    public boolean showLastErrors() {
        return this.optionShowErrors.isSet;
    }

    public boolean isInline() {
        return this.optionInline.isSet;
    }

    public boolean runCompiletimeFunctions() {
        return this.optionRunCompileTimeFunctions.isSet;
    }

    public boolean createHotDoc() {
        return this.optionHotdoc.isSet;
    }

    public boolean isNullsetting() {
        return this.isOptimize();
    }

    public boolean isLocalOptimizations() {
        return this.optionLocalOptimizations.isSet;
    }

    public boolean isIncludeStacktraces() {
        return this.optionStacktraces.isSet;
    }

    public boolean isNoDebugMessages() {
        return this.optionNodebug.isSet;
    }

    public boolean isInjectObjects() {
        return !this.isHotReload() && this.optionInjectCompiletimeObjects.isSet;
    }

    public List<File> getAdditionalLibDirs() {
        return Collections.unmodifiableList(this.libDirs);
    }

    public void addLibs(Set<String> dependencies) {
        for (String dep : dependencies) {
            this.libDirs.add(new File(dep));
        }
    }

    public void addLibDirs(Set<File> dependencies) {
        this.libDirs.addAll(dependencies);
    }

    public boolean showHelp() {
        return this.optionHelp.isSet;
    }

    public boolean isExtractImports() {
        return this.optionExtractImports.isSet;
    }

    public boolean isShowVersion() {
        return this.optionShowVersion.isSet;
    }

    public boolean isUncheckedDispatch() {
        return this.uncheckedDispatch.isSet;
    }

    public boolean isLanguageServer() {
        return this.optionLanguageServer.isSet;
    }

    public boolean isNoExtractMapScript() {
        return this.optionNoExtractMapScript.isSet;
    }

    public boolean isCopyMap() {
        return this.optionCopyMap.isSet;
    }

    public boolean isDisablePjass() {
        return this.optionDisablePjass.isSet;
    }

    public boolean isRunTests() {
        return this.optionRuntests.isSet;
    }

    public boolean isPrettyPrint() {
        return this.optionPrettyPrint.isSet;
    }

    public int getTestTimeout() {
        return this.testTimeout;
    }

    public boolean isMeasureTimes() {
        return this.optionMeasureTimes.isSet;
    }

    public boolean isHotStartmap() {
        return this.optionHotStartmap.isSet;
    }

    public boolean isHotReload() {
        return this.optionHotReload.isSet;
    }

    public boolean isBuild() {
        return this.optionBuild.isSet;
    }

    public String getWorkspaceroot() {
        return this.workspaceroot;
    }

    public String getInputmap() {
        return this.inputmap;
    }

    public boolean isLua() {
        return this.optionLua.isSet;
    }

    public boolean isCompiletimeCache() {
        return this.optionCompiletimeCache.isSet;
    }

    public int getFunctionSplitLimit() {
        return this.functionSplitLimit;
    }

    private static class RunOption {
        final String name;
        final String descr;
        final @Nullable Consumer<String> argHandler;
        boolean isSet;

        RunOption(String name, String descr) {
            this.name = name;
            this.descr = descr;
            this.argHandler = null;
        }

        RunOption(String name, String descr, Consumer<String> argHandler2) {
            this.name = name;
            this.descr = descr;
            this.argHandler = argHandler2;
        }
    }
}

