/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DF;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DI;
import net.moonlightflower.wc3libs.misc.Boundable;
import net.moonlightflower.wc3libs.misc.Size;

public abstract class Raster<T>
implements Boundable {
    private Bounds _bounds;
    protected T[] _cells;

    @Nonnull
    public Bounds getBounds() {
        return this._bounds;
    }

    @Override
    @Nonnull
    public Coords2DF getCenter() {
        return this._bounds.getCenter();
    }

    @Override
    public float getCenterX() {
        return this.getCenter().getX().toFloat();
    }

    @Override
    public float getCenterY() {
        return this.getCenter().getY().toFloat();
    }

    @Override
    @Nonnull
    public Size getSize() {
        return this._bounds.getSize();
    }

    @Override
    public int getWidth() {
        return this.getSize().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getSize().getHeight();
    }

    public abstract void setSize(int var1);

    public void setSize(int cellsCount, boolean retainContents) {
        if (retainContents) {
            this._cells = Arrays.copyOf(this._cells, cellsCount);
        } else {
            this.setSize(cellsCount);
        }
    }

    public void setBounds(@Nonnull Bounds val, boolean retainContents, boolean retainContentsByPos) {
        this.setSize(val.getSize().getArea(), retainContents);
        if (retainContents) {
            if (retainContentsByPos) {
                Object temp = this.clone();
                this._bounds = val;
                this.mergeCellsByPos((Raster<T>)temp, new boolean[0]);
            } else {
                this._bounds = val;
            }
        } else {
            this._bounds = val;
        }
    }

    public void setBoundsByWorld(@Nonnull Bounds val, boolean retainContents, boolean retainContentsByPos) {
        val = val.scale(1.0 / (double)this.getCellSize());
        this.setBounds(val, retainContents, retainContentsByPos);
    }

    public int getIndexByXY(int x, int y) {
        return y * this.getWidth() + x;
    }

    public int size() {
        return this._cells.length;
    }

    public T get(int index) {
        return this._cells[index];
    }

    private int coordsToIndex(@Nonnull Coords2DI pos) {
        return pos.getY() * this.getWidth() + pos.getX();
    }

    public T get(@Nonnull Coords2DI pos) {
        return this.get(this.coordsToIndex(pos));
    }

    public void set(int index, T val) {
        this._cells[index] = val;
    }

    public void set(@Nonnull Coords2DI pos, T val) {
        this.set(this.coordsToIndex(pos), val);
    }

    @Nonnull
    public Coords2DI worldToLocalCoords(@Nonnull Coords2DF pos) {
        int x = (int)((pos.getX().toFloat() - this.getCenterX()) / (float)this.getCellSize() + (float)this.getWidth() / 2.0f);
        int y = (int)((pos.getY().toFloat() - this.getCenterY()) / (float)this.getCellSize() + (float)this.getHeight() / 2.0f);
        return new Coords2DI(x, y);
    }

    public T getByPos(@Nonnull Coords2DF pos) {
        return this.get(this.worldToLocalCoords(pos));
    }

    public void setByPos(@Nonnull Coords2DF pos, T val) {
        this.set(this.worldToLocalCoords(pos), val);
    }

    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this._cells[i] = null;
        }
    }

    public abstract T mergeCellVal(T var1, T var2);

    public void mergeCell(int index, @Nonnull T otherCell) {
        this.set(index, this.mergeCellVal(this.get(index), otherCell));
    }

    public void mergeCells(@Nonnull Raster<T> other) {
        for (int i = 0; i < other.size(); ++i) {
            this.set(i, this.get(i));
        }
    }

    public void mergeCellsByPos(@Nonnull Raster<T> other, boolean ... extra) {
        Coords2DF center = this.getCenter();
        Coords2DF otherCenter = other.getCenter();
        Size size = this.getSize();
        Size otherSize = other.getSize();
        int minX = (int)(otherCenter.getX().toFloat() - (float)otherSize.getWidth() / 2.0f - (center.getX().toFloat() - (float)size.getWidth() / 2.0f));
        int maxX = minX + otherSize.getWidth() - 1;
        int minY = (int)(otherCenter.getY().toFloat() - (float)otherSize.getHeight() / 2.0f - (center.getY().toFloat() - (float)size.getHeight() / 2.0f));
        int maxY = minY + otherSize.getHeight() - 1;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                T otherVal = other.get(new Coords2DI(x, y));
                this.mergeCell(this.getIndexByXY(x, y), otherVal);
            }
        }
    }

    public abstract Raster<T> clone();

    public abstract int getCellSize();

    protected Raster(@Nonnull Bounds bounds) {
        this._bounds = bounds;
    }
}

