/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.BufferManager;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.ArrayInitializer;
import de.peeeq.wurstscript.ast.ArraySizes;
import de.peeeq.wurstscript.ast.AstElementWithParameters;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassDefs;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.ConstructorDefs;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EndFunctionStatement;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.EnumMembers;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprBoolVal;
import de.peeeq.wurstscript.ast.ExprCast;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprDestroy;
import de.peeeq.wurstscript.ast.ExprEmpty;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprIfElse;
import de.peeeq.wurstscript.ast.ExprIncomplete;
import de.peeeq.wurstscript.ast.ExprInstanceOf;
import de.peeeq.wurstscript.ast.ExprIntVal;
import de.peeeq.wurstscript.ast.ExprList;
import de.peeeq.wurstscript.ast.ExprMemberArrayVarDot;
import de.peeeq.wurstscript.ast.ExprMemberArrayVarDotDot;
import de.peeeq.wurstscript.ast.ExprMemberMethodDot;
import de.peeeq.wurstscript.ast.ExprMemberMethodDotDot;
import de.peeeq.wurstscript.ast.ExprMemberVarDot;
import de.peeeq.wurstscript.ast.ExprMemberVarDotDot;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExprNull;
import de.peeeq.wurstscript.ast.ExprRealVal;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.ExprStringVal;
import de.peeeq.wurstscript.ast.ExprSuper;
import de.peeeq.wurstscript.ast.ExprThis;
import de.peeeq.wurstscript.ast.ExprTypeId;
import de.peeeq.wurstscript.ast.ExprUnary;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.ExprVarArrayAccess;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FuncDefs;
import de.peeeq.wurstscript.ast.FuncRef;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.GlobalOrLocalVarDef;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.GlobalVarDefs;
import de.peeeq.wurstscript.ast.Identifier;
import de.peeeq.wurstscript.ast.IdentifierWithTypeArgs;
import de.peeeq.wurstscript.ast.IdentifierWithTypeParamDefs;
import de.peeeq.wurstscript.ast.Indexes;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.JassGlobalBlock;
import de.peeeq.wurstscript.ast.JassToplevelDeclarations;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.ModAbstract;
import de.peeeq.wurstscript.ast.ModConstant;
import de.peeeq.wurstscript.ast.ModOverride;
import de.peeeq.wurstscript.ast.ModStatic;
import de.peeeq.wurstscript.ast.ModVararg;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.ModuleInstanciations;
import de.peeeq.wurstscript.ast.ModuleUse;
import de.peeeq.wurstscript.ast.ModuleUses;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.NativeType;
import de.peeeq.wurstscript.ast.NoDefaultCase;
import de.peeeq.wurstscript.ast.NoExpr;
import de.peeeq.wurstscript.ast.NoSuperConstructorCall;
import de.peeeq.wurstscript.ast.NoTypeExpr;
import de.peeeq.wurstscript.ast.NoTypeParamConstraints;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.SomeSuperConstructorCall;
import de.peeeq.wurstscript.ast.StartFunctionStatement;
import de.peeeq.wurstscript.ast.StmtErr;
import de.peeeq.wurstscript.ast.StmtExitwhen;
import de.peeeq.wurstscript.ast.StmtForFrom;
import de.peeeq.wurstscript.ast.StmtForIn;
import de.peeeq.wurstscript.ast.StmtForRangeDown;
import de.peeeq.wurstscript.ast.StmtForRangeUp;
import de.peeeq.wurstscript.ast.StmtIf;
import de.peeeq.wurstscript.ast.StmtLoop;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.StmtSkip;
import de.peeeq.wurstscript.ast.StmtWhile;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchCases;
import de.peeeq.wurstscript.ast.SwitchDefaultCaseStatements;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.TopLevelDeclarations;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeExprArray;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeExprResolved;
import de.peeeq.wurstscript.ast.TypeExprSimple;
import de.peeeq.wurstscript.ast.TypeExprThis;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.VarInitialization;
import de.peeeq.wurstscript.ast.VisibilityDefault;
import de.peeeq.wurstscript.ast.VisibilityPrivate;
import de.peeeq.wurstscript.ast.VisibilityProtected;
import de.peeeq.wurstscript.ast.VisibilityPublic;
import de.peeeq.wurstscript.ast.VisibilityPublicread;
import de.peeeq.wurstscript.ast.WBlock;
import de.peeeq.wurstscript.ast.WEntities;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WImports;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WPackages;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.ast.WShortParameters;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.ast.WurstDoc;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeNamedScope;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class HoverInfo
extends UserRequest<Hover> {
    private final WFile filename;
    private final String buffer;
    private final int line;
    private final int column;

    public HoverInfo(TextDocumentPositionParams position, BufferManager bufferManager) {
        this.filename = WFile.create(position.getTextDocument().getUri());
        this.buffer = bufferManager.getBuffer(position.getTextDocument());
        this.line = position.getPosition().getLine() + 1;
        this.column = position.getPosition().getCharacter() + 1;
    }

    @Override
    public Hover execute(ModelManager modelManager) {
        CompilationUnit cu = modelManager.replaceCompilationUnitContent(this.filename, this.buffer, false);
        if (cu == null) {
            return new Hover(Collections.singletonList(Either.forLeft((Object)("File " + this.filename + " is not part of the project. Move it to the wurst folder."))));
        }
        Element e = Utils.getAstElementAtPos(cu, this.line, this.column, false).get();
        WLogger.info("hovering over " + Utils.printElement(e));
        List<Either<String, MarkedString>> desription = e.match(new Description());
        desription = this.addArgumentHint(e, desription);
        return new Hover(desription);
    }

    private List<Either<String, MarkedString>> addArgumentHint(Element e, List<Either<String, MarkedString>> desription) {
        try {
            if (e.getParent() instanceof Arguments) {
                FunctionCall fc;
                FuncLink f;
                Arguments args = (Arguments)e.getParent();
                int index = args.indexOf(e);
                if (args.getParent() instanceof FunctionCall && (f = (fc = (FunctionCall)args.getParent()).attrFuncLink()) != null) {
                    WurstType parameterType = f.getParameterType(index);
                    String parameterName = f.getParameterName(index);
                    desription = Utils.append(desription, Either.forLeft((Object)("Parameter " + parameterType + " " + parameterName)));
                }
            }
        }
        catch (Exception ex) {
            WLogger.info("Could not get argument hint");
            WLogger.info(ex);
        }
        return desription;
    }

    private static List<Either<String, MarkedString>> description(Element n) {
        return n.match(new Description());
    }

    static String descriptionString(Element n) {
        List<Either<String, MarkedString>> descr = HoverInfo.description(n);
        StringBuilder res = new StringBuilder();
        for (Either<String, MarkedString> d : descr) {
            if (d.isLeft()) {
                res.append((String)d.getLeft());
            } else {
                res.append(((MarkedString)d.getRight()).getValue());
            }
            res.append("\n");
        }
        return res.toString().trim();
    }

    public static String getParameterString(AstElementWithParameters f) {
        StringBuilder descrhtml = new StringBuilder();
        boolean first = true;
        for (WParameter p : f.getParameters()) {
            if (!first) {
                descrhtml.append(", ");
            }
            descrhtml.append(HoverInfo.type(p.attrTyp())).append(" ").append(p.getName());
            first = false;
        }
        return descrhtml.toString();
    }

    private static String type(WurstType wurstType) {
        return wurstType.toString();
    }

    static class Description
    implements Element.Matcher<List<Either<String, MarkedString>>> {
        Description() {
        }

        public List<Either<String, MarkedString>> description(FunctionDefinition f) {
            ArrayList<Either<String, MarkedString>> result = new ArrayList<Either<String, MarkedString>>();
            String comment = f.attrComment();
            if (comment != null && !comment.isEmpty()) {
                result.add(Either.forLeft((Object)comment));
            }
            String params = HoverInfo.getParameterString(f);
            String returnTypeHtml = HoverInfo.type(f.attrReturnTyp());
            Object functionDescription = "";
            Object funcName = f.getName();
            if (f instanceof ExtensionFuncDef) {
                ExtensionFuncDef exf = (ExtensionFuncDef)f;
                funcName = HoverInfo.type(exf.getExtendedType().attrTyp()) + "." + (String)funcName;
            }
            functionDescription = (String)functionDescription + "function " + (String)funcName + "(" + params + ") ";
            if (!f.attrTyp().isVoid()) {
                functionDescription = (String)functionDescription + "returns " + returnTypeHtml;
            }
            result.add(Either.forRight((Object)new MarkedString("wurst", (String)functionDescription)));
            result.add(Either.forLeft((Object)("defined in " + Description.nearestScopeName(f))));
            return result;
        }

        private static String nearestScopeName(Element n) {
            if (n.attrNearestNamedScope() != null) {
                return Utils.printElement(n.attrNearestNamedScope());
            }
            return "Global";
        }

        public List<Either<String, MarkedString>> description(NameDef n) {
            if (n == null) {
                return Collections.emptyList();
            }
            ArrayList<Either<String, MarkedString>> result = new ArrayList<Either<String, MarkedString>>();
            String comment = n.attrComment();
            if (comment != null && !comment.isEmpty()) {
                result.add(Either.forLeft((Object)comment));
            }
            if (n.attrIsConstant() && n instanceof GlobalOrLocalVarDef) {
                GlobalOrLocalVarDef v = (GlobalOrLocalVarDef)n;
                VarInitialization initialExpr = v.getInitialExpr();
                String initial = Utils.prettyPrint(initialExpr);
                result.add((Either<String, MarkedString>)Either.forRight((Object)new MarkedString("wurst", " = " + initial)));
            }
            String additionalProposalInfo = HoverInfo.type(n.attrTyp()) + " " + n.getName() + " defined in " + Description.nearestScopeName(n);
            result.add(Either.forLeft((Object)additionalProposalInfo));
            return result;
        }

        public List<Either<String, MarkedString>> description(ConstructorDef f) {
            ArrayList<Either<String, MarkedString>> result = new ArrayList<Either<String, MarkedString>>();
            String comment = f.attrComment();
            if (comment != null && !comment.isEmpty()) {
                result.add(Either.forLeft((Object)comment));
            }
            String params = HoverInfo.getParameterString(f);
            Object functionDescription = "";
            ClassOrModule classOrModule = f.attrNearestClassOrModule();
            if (classOrModule != null) {
                functionDescription = (String)functionDescription + classOrModule.getName();
            }
            functionDescription = (String)functionDescription + "(" + params + ") ";
            result.add(Either.forRight((Object)new MarkedString("wurst", (String)functionDescription)));
            result.add(Either.forLeft((Object)("defined in " + Description.nearestScopeName(f))));
            return result;
        }

        public List<Either<String, MarkedString>> description(NameRef nr) {
            NameLink nameDef = nr.attrNameLink();
            if (nameDef == null) {
                return this.string(nr.getVarName() + " is not defined yet.");
            }
            return nameDef.getDef().match(this);
        }

        public List<Either<String, MarkedString>> description(FuncRef fr) {
            FuncLink def = fr.attrFuncLink();
            if (def == null) {
                return this.string(fr.getFuncName() + " is not defined yet.");
            }
            return def.getDef().match(this);
        }

        @Override
        public List<Either<String, MarkedString>> case_NativeFunc(NativeFunc nativeFunc) {
            return this.description(nativeFunc);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprEmpty(ExprEmpty exprEmpty) {
            return this.string("empty expression");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModuleDef(ModuleDef moduleDef) {
            return this.description(moduleDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtErr(StmtErr stmtErr) {
            return this.string("Error statement");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprRealVal(ExprRealVal exprRealVal) {
            return this.string("The number " + exprRealVal.getValR() + " of type real.");
        }

        @Override
        public List<Either<String, MarkedString>> case_NoExpr(NoExpr noExpr) {
            return this.string("no expression");
        }

        @Override
        public List<Either<String, MarkedString>> case_StartFunctionStatement(StartFunctionStatement startFunctionStatement) {
            return this.string("start function call");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModStatic(ModStatic modStatic) {
            return this.string("static: This function or variable is just like a function outside of a class. It is not bound to an instance. No dynamic dispatch is used.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ClassDef(ClassDef classDef) {
            return this.description(classDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprIntVal(ExprIntVal exprIntVal) {
            return this.string("integer constant");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprCast(ExprCast e) {
            return this.string("Change the type of the left expression to " + HoverInfo.type(e.getTyp().attrTyp()));
        }

        @Override
        public List<Either<String, MarkedString>> case_WImport(WImport imp) {
            WPackage imported = imp.attrImportedPackage();
            if (imported != null) {
                return this.string(imported.attrComment());
            }
            return this.string("import ...");
        }

        @Override
        public List<Either<String, MarkedString>> case_TupleDef(TupleDef tupleDef) {
            return this.description(tupleDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprVarAccess(ExprVarAccess exprVarAccess) {
            return this.description(exprVarAccess);
        }

        @Override
        public List<Either<String, MarkedString>> case_InterfaceDef(InterfaceDef interfaceDef) {
            return this.description(interfaceDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_VisibilityProtected(VisibilityProtected visibilityProtected) {
            return this.string("protected: can be used in subclasses and in the same package");
        }

        @Override
        public List<Either<String, MarkedString>> case_Annotation(Annotation annotation) {
            FunctionDefinition def = annotation.attrFuncDef();
            if (def != null) {
                return this.string(def.attrComment());
            }
            return this.string("This is an undefined annotation.");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtExitwhen(StmtExitwhen stmtExitwhen) {
            return this.string("extiwhen: Exits the current loop when the condition is true");
        }

        @Override
        public List<Either<String, MarkedString>> case_ConstructorDef(ConstructorDef constr) {
            ArrayList<Either<String, MarkedString>> result = new ArrayList<Either<String, MarkedString>>();
            NamedScope c = constr.attrNearestNamedScope();
            String comment = constr.attrComment();
            result.add(Either.forLeft((Object)comment));
            String descr = "construct(" + HoverInfo.getParameterString(constr) + ") defined in " + Utils.printElement(c);
            result.add(Either.forRight((Object)new MarkedString("wurst", descr)));
            return result;
        }

        @Override
        public List<Either<String, MarkedString>> case_WImports(WImports wImports) {
            return this.string("imports");
        }

        @Override
        public List<Either<String, MarkedString>> case_WStatements(WStatements wStatements) {
            return this.string("statements");
        }

        @Override
        public List<Either<String, MarkedString>> case_CompilationUnit(CompilationUnit compilationUnit) {
            return this.string("File " + compilationUnit.getCuInfo().getFile());
        }

        @Override
        public List<Either<String, MarkedString>> case_SwitchStmt(SwitchStmt switchStmt) {
            return this.string("A switch statement does different things depending on the value of an epxression.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExtensionFuncDef(ExtensionFuncDef extensionFuncDef) {
            return this.description(extensionFuncDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_EndFunctionStatement(EndFunctionStatement endFunctionStatement) {
            return this.string("end function");
        }

        @Override
        public List<Either<String, MarkedString>> case_ArrayInitializer(ArrayInitializer arrayInitializer) {
            return this.string("Initial values for the array.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModOverride(ModOverride modOverride) {
            return this.string("override: This function overrides an other function from a module or superclass");
        }

        @Override
        public List<Either<String, MarkedString>> case_SomeSuperConstructorCall(SomeSuperConstructorCall sc) {
            ConstructorDef constr = (ConstructorDef)sc.getParent();
            ConstructorDef superConstr = constr.attrSuperConstructor();
            if (superConstr == null) {
                return this.string("Calling an unknown super constructor");
            }
            return this.description(superConstr);
        }

        @Override
        public List<Either<String, MarkedString>> case_LocalVarDef(LocalVarDef v) {
            return this.string("Local Variable " + v.getName() + " of type " + HoverInfo.type(v.attrTyp()));
        }

        private List<Either<String, MarkedString>> string(String s) {
            return Collections.singletonList(Either.forLeft((Object)s));
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtForRangeDown(StmtForRangeDown s) {
            return this.string("Do something for all " + s.getLoopVar().getName() + " counting from _ down to _");
        }

        @Override
        public List<Either<String, MarkedString>> case_NoDefaultCase(NoDefaultCase noDefaultCase) {
            return this.string("no default case");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprSuper(ExprSuper exprSuper) {
            return this.string("super: refers to the super class (extends ...)  of this class");
        }

        @Override
        public List<Either<String, MarkedString>> case_IdentifierWithTypeArgs(IdentifierWithTypeArgs identifierWithTypeArgs) {
            return identifierWithTypeArgs.getParent().match(this);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprMemberVarDotDot(ExprMemberVarDotDot exprMemberVarDotDot) {
            return this.description(exprMemberVarDotDot);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprVarArrayAccess(ExprVarArrayAccess exprVarArrayAccess) {
            return this.description(exprVarArrayAccess);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprMemberMethodDot(ExprMemberMethodDot exprMemberMethodDot) {
            return this.description(exprMemberMethodDot);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprClosure(ExprClosure exprClosure) {
            return this.string("Closure with type " + exprClosure.attrTyp() + " (implements " + exprClosure.attrExpectedTypAfterOverloading() + ")");
        }

        @Override
        public List<Either<String, MarkedString>> case_SwitchCases(SwitchCases switchCases) {
            return this.string("A switch statement");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprBinary(ExprBinary exprBinary) {
            FuncLink funcDef = exprBinary.attrFuncLink();
            if (funcDef != null) {
                return this.description(funcDef.getDef());
            }
            return this.string("A binary operation");
        }

        @Override
        public List<Either<String, MarkedString>> case_NoTypeExpr(NoTypeExpr noTypeExpr) {
            return this.string("not type");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModuleUse(ModuleUse moduleUse) {
            return this.description(moduleUse.attrModuleDef());
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprFunctionCall(ExprFunctionCall exprFunctionCall) {
            return this.description(exprFunctionCall);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprBoolVal(ExprBoolVal exprBoolVal) {
            return this.string("A boolean value");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModConstant(ModConstant modConstant) {
            return this.string("This modifiers ensures that the variable cannot change after initialization.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprTypeId(ExprTypeId exprTypeId) {
            return this.string("Get the typeId");
        }

        @Override
        public List<Either<String, MarkedString>> case_TypeExprList(TypeExprList typeExprList) {
            return this.string("A list of type-expressions");
        }

        @Override
        public List<Either<String, MarkedString>> case_FuncDefs(FuncDefs funcDefs) {
            return this.string("A list of function definitions");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprNewObject(ExprNewObject exprNewObject) {
            ConstructorDef constr = exprNewObject.attrConstructorDef();
            if (constr == null) {
                return this.string("Constructor for " + exprNewObject.getTypeName() + " not defined yet.");
            }
            return this.description(constr);
        }

        @Override
        public List<Either<String, MarkedString>> case_VisibilityPrivate(VisibilityPrivate visibilityPrivate) {
            return this.string("Modifier private: This element can only be used in the current scope.");
        }

        @Override
        public List<Either<String, MarkedString>> case_VisibilityDefault(VisibilityDefault visibilityDefault) {
            return this.string("Default visibility.");
        }

        @Override
        public List<Either<String, MarkedString>> case_Arguments(Arguments arguments) {
            return this.string("List of arguments");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModuleInstanciations(ModuleInstanciations moduleInstanciations) {
            return this.string("List of module instantiations.");
        }

        @Override
        public List<Either<String, MarkedString>> case_WShortParameters(WShortParameters wShortParameters) {
            return this.string("Parameters of anonymous function.");
        }

        @Override
        public List<Either<String, MarkedString>> case_SwitchDefaultCaseStatements(SwitchDefaultCaseStatements switchDefaultCaseStatements) {
            return this.string("Default statements of switch-statement");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprStatementsBlock(ExprStatementsBlock exprStatementsBlock) {
            return this.string("A block of statements.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModuleUses(ModuleUses moduleUses) {
            return this.string("A list of module uses");
        }

        @Override
        public List<Either<String, MarkedString>> case_GlobalVarDef(GlobalVarDef globalVarDef) {
            return this.description(globalVarDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_JassToplevelDeclarations(JassToplevelDeclarations jassToplevelDeclarations) {
            return this.string("A list of declarations.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprIncomplete(ExprIncomplete exprIncomplete) {
            return this.string("This expression is incomplete.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprMemberArrayVarDotDot(ExprMemberArrayVarDotDot exprMemberArrayVarDotDot) {
            return this.description(exprMemberArrayVarDotDot);
        }

        @Override
        public List<Either<String, MarkedString>> case_ConstructorDefs(ConstructorDefs constructorDefs) {
            return this.string("A list of constructors");
        }

        private List<Either<String, MarkedString>> typeExpr(TypeExpr t) {
            WurstType wt = t.attrTyp();
            if (wt == null) {
                return this.string("Type " + t);
            }
            if (wt instanceof WurstTypeNamedScope) {
                WurstTypeNamedScope wtn = (WurstTypeNamedScope)wt;
                return this.description(wtn.getDef());
            }
            return this.string(HoverInfo.type(wt));
        }

        @Override
        public List<Either<String, MarkedString>> case_TypeExprArray(TypeExprArray t) {
            return this.typeExpr(t);
        }

        @Override
        public List<Either<String, MarkedString>> case_TypeExprSimple(TypeExprSimple t) {
            return this.typeExpr(t);
        }

        @Override
        public List<Either<String, MarkedString>> case_Modifiers(Modifiers modifiers) {
            return this.string("A list of modifiers");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModAbstract(ModAbstract modAbstract) {
            return this.string("Abstract members are declarations without implementations. They must be implemented in concrete subtypes.");
        }

        @Override
        public List<Either<String, MarkedString>> case_WBlock(WBlock wBlock) {
            return this.string("A block.");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtSkip(StmtSkip stmtSkip) {
            return this.string("The skip statement does nothing and can be used to fill an empty block.");
        }

        @Override
        public List<Either<String, MarkedString>> case_FuncDef(FuncDef funcDef) {
            return this.description(funcDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprList(ExprList exprList) {
            return this.string("A list of expressions.");
        }

        @Override
        public List<Either<String, MarkedString>> case_NativeType(NativeType nativeType) {
            return this.description(nativeType);
        }

        @Override
        public List<Either<String, MarkedString>> case_NoTypeParamConstraints(NoTypeParamConstraints noTypeParamConstraints) {
            return this.string("No type parameter constraints given.");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtForRangeUp(StmtForRangeUp stmtForRangeUp) {
            return this.string("Execute the body several times, counting up");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtLoop(StmtLoop stmtLoop) {
            return this.string("Primitive loop statement");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprStringVal(ExprStringVal exprStringVal) {
            return this.string("A string constant.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprNull(ExprNull exprNull) {
            return this.string("The null-reference");
        }

        @Override
        public List<Either<String, MarkedString>> case_ClassDefs(ClassDefs classDefs) {
            return this.string("A list of class definitions.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModuleInstanciation(ModuleInstanciation moduleInstanciation) {
            return this.string("A module instantiation.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprMemberArrayVarDot(ExprMemberArrayVarDot exprMemberArrayVarDot) {
            return this.description(exprMemberArrayVarDot);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprFuncRef(ExprFuncRef exprFuncRef) {
            return this.description(exprFuncRef);
        }

        @Override
        public List<Either<String, MarkedString>> case_TypeParamDefs(TypeParamDefs typeParamDefs) {
            return this.string("A list of type parameters.");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtForFrom(StmtForFrom stmtForFrom) {
            return this.string("The for-from loop takes an iterate and takes elements from the iterator until it is empty.");
        }

        @Override
        public List<Either<String, MarkedString>> case_Indexes(Indexes indexes) {
            return this.string("A list of indexes");
        }

        @Override
        public List<Either<String, MarkedString>> case_VisibilityPublicread(VisibilityPublicread visibilityPublicread) {
            return this.string("This variable can be read from everywhere but only written to in this scope.");
        }

        @Override
        public List<Either<String, MarkedString>> case_EnumMember(EnumMember enumMember) {
            return this.description(enumMember);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprInstanceOf(ExprInstanceOf exprInstanceOf) {
            return this.string("The instanceof expression checks if an object is an instance of a given type.");
        }

        @Override
        public List<Either<String, MarkedString>> case_WurstModel(WurstModel wurstModel) {
            return this.string("The wurst model.");
        }

        @Override
        public List<Either<String, MarkedString>> case_Identifier(Identifier identifier) {
            return identifier.getParent().match(this);
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtWhile(StmtWhile stmtWhile) {
            return this.string("A while loop");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprMemberMethodDotDot(ExprMemberMethodDotDot exprMemberMethodDotDot) {
            return this.description(exprMemberMethodDotDot);
        }

        @Override
        public List<Either<String, MarkedString>> case_TypeParamDef(TypeParamDef typeParamDef) {
            return this.description(typeParamDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_IdentifierWithTypeParamDefs(IdentifierWithTypeParamDefs identifierWithTypeParamDefs) {
            return identifierWithTypeParamDefs.getParent().match(this);
        }

        @Override
        public List<Either<String, MarkedString>> case_GlobalVarDefs(GlobalVarDefs globalVarDefs) {
            return this.string("A list of global variables.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprThis(ExprThis exprThis) {
            return this.string("'this' refers to the current object (of type " + exprThis.attrTyp() + ")");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtReturn(StmtReturn stmtReturn) {
            return this.string("Returns from the current function.");
        }

        @Override
        public List<Either<String, MarkedString>> case_WPackages(WPackages wPackages) {
            return this.string("A list of packages.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprIfElse(ExprIfElse exprIfElse) {
            return this.string("A conditional expression (condition ? ifTrue : ifFalse).");
        }

        @Override
        public List<Either<String, MarkedString>> case_WurstDoc(WurstDoc wurstDoc) {
            return wurstDoc.getParent().match(this);
        }

        @Override
        public List<Either<String, MarkedString>> case_NoSuperConstructorCall(NoSuperConstructorCall noSuperConstructorCall) {
            return this.string("no super constructor called");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtIf(StmtIf stmtIf) {
            return this.string("An if-statement.");
        }

        @Override
        public List<Either<String, MarkedString>> case_WPackage(WPackage wPackage) {
            return this.description(wPackage);
        }

        @Override
        public List<Either<String, MarkedString>> case_OnDestroyDef(OnDestroyDef onDestroyDef) {
            return this.string("This is called when an object of this type is destroyed.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ModVararg(ModVararg modVararg) {
            return this.string("Declares the parameter to be a array of variable length");
        }

        @Override
        public List<Either<String, MarkedString>> case_TypeExprResolved(TypeExprResolved typeExprResolved) {
            return this.typeExpr(typeExprResolved);
        }

        @Override
        public List<Either<String, MarkedString>> case_VisibilityPublic(VisibilityPublic visibilityPublic) {
            return this.string("This element can be used everywhere");
        }

        @Override
        public List<Either<String, MarkedString>> case_TopLevelDeclarations(TopLevelDeclarations topLevelDeclarations) {
            return this.string("A list of declarations.");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtSet(StmtSet stmtSet) {
            return this.string("An assignment.");
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprDestroy(ExprDestroy exprDestroy) {
            return this.string("Destroys the given object.");
        }

        @Override
        public List<Either<String, MarkedString>> case_WEntities(WEntities wEntities) {
            return this.string("A list of entities");
        }

        @Override
        public List<Either<String, MarkedString>> case_ArraySizes(ArraySizes arraySizes) {
            return this.string("A list of array-sizes");
        }

        @Override
        public List<Either<String, MarkedString>> case_EnumDef(EnumDef enumDef) {
            return this.description(enumDef);
        }

        @Override
        public List<Either<String, MarkedString>> case_SwitchCase(SwitchCase switchCase) {
            return this.string("A case in a switch-statement");
        }

        @Override
        public List<Either<String, MarkedString>> case_EnumMembers(EnumMembers enumMembers) {
            return this.string("A list of enum-members.");
        }

        @Override
        public List<Either<String, MarkedString>> case_TypeExprThis(TypeExprThis typeExprThis) {
            return this.typeExpr(typeExprThis);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprUnary(ExprUnary exprUnary) {
            return this.string("A unary expression");
        }

        @Override
        public List<Either<String, MarkedString>> case_JassGlobalBlock(JassGlobalBlock jassGlobalBlock) {
            return this.string("A block of global variables.");
        }

        @Override
        public List<Either<String, MarkedString>> case_StmtForIn(StmtForIn stmtForIn) {
            return this.string("The for-in loop executes the loop body for every element in the given collection using its iterator method.");
        }

        @Override
        public List<Either<String, MarkedString>> case_InitBlock(InitBlock initBlock) {
            return this.string("The init block is called at the start of the program.");
        }

        @Override
        public List<Either<String, MarkedString>> case_WParameter(WParameter wParameter) {
            return this.description(wParameter);
        }

        @Override
        public List<Either<String, MarkedString>> case_WShortParameter(WShortParameter wShortParameter) {
            return this.description(wShortParameter);
        }

        @Override
        public List<Either<String, MarkedString>> case_ExprMemberVarDot(ExprMemberVarDot exprMemberVarDot) {
            return this.description(exprMemberVarDot);
        }

        @Override
        public List<Either<String, MarkedString>> case_WParameters(WParameters wParameters) {
            return this.string("A list of parameters");
        }
    }
}

