/*
 * Decompiled with CFR 0.152.
 */
package workers;

import file.ZipArchiveExtractor;
import global.InstallationManager;
import global.Log;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import workers.ExtractWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\nH\u0014R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lworkers/ExtractWorker;", "Ljavax/swing/SwingWorker;", "", "Ljava/lang/Void;", "filePath", "Ljava/nio/file/Path;", "progressBar", "Ljavax/swing/JProgressBar;", "callback", "Lkotlin/Function1;", "", "(Ljava/nio/file/Path;Ljavax/swing/JProgressBar;Lkotlin/jvm/functions/Function1;)V", "getCallback", "()Lkotlin/jvm/functions/Function1;", "extractSuccess", "log", "Lmu/KLogger;", "getProgressBar", "()Ljavax/swing/JProgressBar;", "doInBackground", "()Ljava/lang/Boolean;", "done", "WurstSetup"})
public final class ExtractWorker
extends SwingWorker<Boolean, Void> {
    @NotNull
    private final Path filePath;
    @Nullable
    private final JProgressBar progressBar;
    @NotNull
    private final Function1<Boolean, Unit> callback;
    @NotNull
    private final KLogger log;
    private boolean extractSuccess;

    public ExtractWorker(@NotNull Path filePath, @Nullable JProgressBar progressBar, @NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.filePath = filePath;
        this.progressBar = progressBar;
        this.callback = callback;
        this.log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    }

    @Nullable
    public final JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @NotNull
    public final Function1<Boolean, Unit> getCallback() {
        return this.callback;
    }

    @Override
    @Nullable
    protected Boolean doInBackground() throws Exception {
        try {
            if (this.progressBar != null) {
                SwingUtilities.invokeLater(() -> ExtractWorker.doInBackground$lambda$0(this));
            }
            Log.INSTANCE.print("Extracting compiler..");
            this.log.debug("extract compiler");
            this.extractSuccess = ZipArchiveExtractor.INSTANCE.extractArchive(this.filePath, InstallationManager.INSTANCE.getInstallDir());
            Files.delete(this.filePath);
        }
        catch (Exception e) {
            this.log.error(e.getLocalizedMessage());
            this.callback.invoke((Object)false);
        }
        return null;
    }

    @Override
    protected void done() {
        if (this.progressBar != null) {
            SwingUtilities.invokeLater(() -> ExtractWorker.done$lambda$1(this));
        }
        this.callback.invoke((Object)this.extractSuccess);
    }

    private static final void doInBackground$lambda$0(ExtractWorker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.progressBar.setIndeterminate(true);
    }

    private static final void done$lambda$1(ExtractWorker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.progressBar.setIndeterminate(false);
    }
}

