/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.util.LinkedHashSet;
import java.util.Set;

public class ObservableLinkedHashSet<T>
extends LinkedHashSet<T> {
    protected final Set<Listener<T>> _listeners = new LinkedHashSet<Listener<T>>();

    public void onAdd(T val) {
    }

    @Override
    public boolean add(T val) {
        boolean ret = super.add(val);
        if (ret) {
            this.onAdd(val);
        }
        for (Listener<T> listener : this._listeners) {
            listener.onAdd(val);
        }
        return ret;
    }

    public void onRemove(T val) {
    }

    @Override
    public boolean remove(Object val) {
        boolean ret = super.remove(val);
        if (ret) {
            this.onRemove(val);
        }
        for (Listener<Object> listener : this._listeners) {
            listener.onRemove(val);
        }
        return ret;
    }

    public void onClear() {
        for (Listener<T> listener : this._listeners) {
            listener.clear();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.onClear();
    }

    public static interface Listener<T> {
        public void onAdd(T var1);

        public void onRemove(T var1);

        public void clear();
    }
}

