/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.jurst;

import de.peeeq.wurstscript.jurst.antlr.JurstLexer;
import de.peeeq.wurstscript.utils.LineOffsets;
import java.util.LinkedList;
import java.util.Queue;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.misc.Pair;
import org.eclipse.jdt.annotation.Nullable;

public class ExtendedJurstLexer
implements TokenSource {
    private final JurstLexer orig;
    private final Queue<Token> nextTokens = new LinkedList<Token>();
    private State state = State.INIT;
    private @Nullable Token eof = null;
    private @Nullable Token firstNewline;
    private final LineOffsets lineOffsets = new LineOffsets();
    public StringBuilder debugSb = new StringBuilder();
    private final boolean debug = false;
    private final Pair<TokenSource, CharStream> sourcePair;
    private boolean isWurst = false;

    public ExtendedJurstLexer(CharStream input) {
        this.orig = new JurstLexer(input);
        this.sourcePair = new Pair((Object)this.orig, (Object)input);
    }

    public int getCharPositionInLine() {
        return this.orig.getCharPositionInLine();
    }

    public CharStream getInputStream() {
        return this.orig.getInputStream();
    }

    public int getLine() {
        return this.orig.getLine();
    }

    public String getSourceName() {
        return this.orig.getSourceName();
    }

    public TokenFactory<?> getTokenFactory() {
        return this.orig.getTokenFactory();
    }

    public Token nextToken() {
        Token t = this.nextTokenIntern();
        this.debugSb.append(t.getText()).append(" ");
        return t;
    }

    private Token nextTokenIntern() {
        if (!this.nextTokens.isEmpty()) {
            return this.nextTokens.poll();
        }
        Token eof_local = this.eof;
        if (eof_local != null) {
            return this.makeToken(-1, "$EOF", eof_local.getStartIndex(), eof_local.getStopIndex());
        }
        while (true) {
            Token token;
            if ((token = this.orig.nextToken()) == null) {
                continue;
            }
            if (this.isWurst) {
                if (token.getType() == 14 || token.getType() == 74 || token.getType() == 76) {
                    this.isWurst = false;
                }
            } else if (token.getType() == 13 || token.getType() == 73 || token.getType() == 75) {
                this.isWurst = true;
            } else if (this.isWurstOnlyKeyword(token)) {
                token = this.makeToken(137, token.getText(), token.getStartIndex(), token.getStopIndex());
                assert (token != null);
            } else if (token.getType() == 144) continue;
            if (token.getType() == 136) {
                this.lineOffsets.set(token.getLine(), token.getStopIndex());
            }
            if (token.getType() == -1) {
                this.eof = token;
                if (this.isWurst) {
                    this.nextTokens.add(this.makeToken(14, "endpackage", token.getStartIndex(), token.getStopIndex()));
                    this.nextTokens.add(this.makeToken(136, "$NL", token.getStartIndex(), token.getStopIndex()));
                }
                return this.makeToken(136, "$NL", token.getStartIndex(), token.getStopIndex());
            }
            if (token.getType() == 137 && token.getText().equals("debug") && this.state == State.NEWLINES) continue;
            switch (this.state) {
                case INIT: {
                    if (this.isWrapCharEndLine(token.getType())) {
                        this.state(State.WRAP_CHAR);
                        return token;
                    }
                    if (token.getType() == 136) {
                        this.firstNewline = token;
                        this.state(State.NEWLINES);
                        break;
                    }
                    return token;
                }
                case NEWLINES: {
                    if (this.isWrapCharBeginLine(token.getType())) {
                        this.state(State.WRAP_CHAR);
                        return token;
                    }
                    if (token.getType() == 136) break;
                    this.nextTokens.add(token);
                    this.state(State.INIT);
                    return this.firstNewline;
                }
                case WRAP_CHAR: {
                    if (this.isWrapCharEndLine(token.getType())) {
                        return token;
                    }
                    if (token.getType() == 136) break;
                    this.state(State.INIT);
                    return token;
                }
                case BEGIN_LINE: {
                    if (token.getType() == 136) {
                        this.state(State.NEWLINES);
                        break;
                    }
                    if (this.isWrapCharBeginLine(token.getType())) {
                        this.state(State.WRAP_CHAR);
                        return token;
                    }
                    this.state(State.INIT);
                    this.nextTokens.add(token);
                    return this.firstNewline;
                }
            }
        }
    }

    private boolean isWurstOnlyKeyword(Token token) {
        switch (token.getType()) {
            case 56: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    private void state(State s) {
        this.state = s;
    }

    private boolean isWrapChar(int type) {
        switch (type) {
            case 40: 
            case 41: 
            case 54: 
            case 55: 
            case 105: 
            case 106: 
            case 108: 
            case 110: 
            case 111: 
            case 112: {
                return true;
            }
        }
        return false;
    }

    private boolean isWrapCharEndLine(int type) {
        switch (type) {
            case 115: 
            case 117: {
                return true;
            }
        }
        return this.isWrapChar(type);
    }

    private boolean isWrapCharBeginLine(int type) {
        switch (type) {
            case 113: 
            case 114: 
            case 116: 
            case 118: {
                return true;
            }
        }
        return this.isWrapChar(type);
    }

    private Token makeToken(int type, String text, int start, int stop) {
        Pair<TokenSource, CharStream> source = this.sourcePair;
        int channel = 0;
        CommonToken t = new CommonToken(source, type, channel, start, stop);
        return t;
    }

    public void setTokenFactory(TokenFactory<?> factory) {
        this.orig.setTokenFactory(factory);
    }

    public LineOffsets getLineOffsets() {
        return this.lineOffsets;
    }

    public void addErrorListener(ANTLRErrorListener listener) {
        this.orig.addErrorListener(listener);
    }

    static enum State {
        INIT,
        WRAP_CHAR,
        NEWLINES,
        BEGIN_LINE;

    }
}

