/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.bytes;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 ]2\u00020\u0001:\u0001]B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0004J\b\u0010\u001e\u001a\u00020\u0006H\u0017J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0014J\b\u0010 \u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010 \u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0003H\u0002J\b\u0010%\u001a\u00020\u0019H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0003H\u0016J \u0010,\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020\u0003H\u0016J\b\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u0010(\u001a\u00020\u0003H\u0016J\b\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010(\u001a\u00020\u0003H\u0016J\b\u00109\u001a\u00020\u0003H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010(\u001a\u00020\u0003H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010(\u001a\u00020\u0003H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\u0003H\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010(\u001a\u00020\u0003H\u0016J\n\u0010E\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010F\u001a\n\u0018\u00010Gj\u0004\u0018\u0001`HH\u0016J\u0010\u0010I\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0018\u0010J\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010K\u001a\u00020\u0003H\u0002J\u0010\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0019H\u0016J\b\u0010N\u001a\u00020\u0019H\u0016J\u0010\u0010N\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0019H\u0016J\u0010\u0010O\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0019H\u0002J\u0010\u0010P\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0019H\u0002J\u0010\u0010Q\u001a\u00020=2\u0006\u0010M\u001a\u00020\u0019H\u0016J\u0010\u0010R\u001a\u00020=2\u0006\u0010M\u001a\u00020\u0019H\u0002J\u0010\u0010S\u001a\u00020\u00032\u0006\u0010T\u001a\u00020\u0003H\u0014J\b\u0010U\u001a\u00020\u001cH\u0016J\u000e\u0010V\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010V\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J \u0010V\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010W\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\u0003H\u0016J\u0010\u0010Z\u001a\u00020\u001c2\u0006\u0010[\u001a\u00020\u0003H\u0016J\u0010\u0010\\\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\\\u001a\u00020=2\u0006\u0010\b\u001a\u00020=H\u0016R\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Ldorkbox/bytes/ByteBufInput;", "Lcom/esotericsoftware/kryo/io/Input;", "bufferSize", "", "(I)V", "bytes", "", "offset", "count", "([BII)V", "buffer", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;)V", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "(Ljava/io/InputStream;I)V", "<set-?>", "byteBuf", "getByteBuf", "()Lio/netty/buffer/ByteBuf;", "initialReaderIndex", "initialWriterIndex", "tempBuffer", "canReadVarInt", "", "canReadVarLong", "close", "", "fill", "getBuffer", "optional", "read", "readAsciiString", "", "readAscii_slow", "charCount", "readBoolean", "readBooleans", "", "length", "readByte", "", "readByteUnsigned", "readBytes", "readChar", "", "readChars", "", "readDouble", "", "readDoubles", "", "readFloat", "", "readFloats", "", "readInt", "readInts", "", "readLong", "", "readLongs", "", "readShort", "", "readShortUnsigned", "readShorts", "", "readString", "readStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "readUtf8Chars", "readUtf8Chars_slow", "charIndex", "readVarInt", "optimizePositive", "readVarIntFlag", "readVarIntFlag_slow", "readVarInt_slow", "readVarLong", "readVarLong_slow", "require", "required", "reset", "setBuffer", "setInputStream", "setLimit", "limit", "setPosition", "position", "skip", "Companion", "ByteUtilities"})
@SourceDebugExtension(value={"SMAP\nByteBufInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBufInput.kt\ndorkbox/bytes/ByteBufInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,933:1\n1#2:934\n*E\n"})
public final class ByteBufInput
extends Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ByteBuf byteBuf;
    private int initialReaderIndex;
    private int initialWriterIndex;
    @Nullable
    private byte[] tempBuffer;
    @NotNull
    public static final String version = "2.0";

    @NotNull
    public final ByteBuf getByteBuf() {
        ByteBuf byteBuf = this.byteBuf;
        if (byteBuf != null) {
            return byteBuf;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"byteBuf");
        return null;
    }

    public ByteBufInput(int bufferSize) {
        this.capacity = bufferSize;
        ByteBuf byteBuf = Unpooled.buffer((int)bufferSize);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(bufferSize)");
        this.byteBuf = byteBuf;
    }

    public ByteBufInput(@NotNull byte[] bytes, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes, (int)offset, (int)count);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(bytes, offset, count)");
        this.setBuffer(byteBuf);
    }

    public /* synthetic */ ByteBufInput(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        this(byArray, n, n2);
    }

    public ByteBufInput(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.setBuffer(buffer);
    }

    public ByteBufInput(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this(4096);
        this.inputStream = inputStream;
    }

    public ByteBufInput(@NotNull InputStream inputStream, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this(bufferSize);
        this.inputStream = inputStream;
    }

    @Deprecated(message="Use getByteBuf() instead", replaceWith=@ReplaceWith(expression="getByteBuf()", imports={}))
    @NotNull
    public byte[] getBuffer() {
        throw new UnsupportedOperationException("This input does not used a byte[], see #getByteBuf().");
    }

    @Deprecated(message="Use setByteBuf() instead", replaceWith=@ReplaceWith(expression="setBuffer(ByteBuf)", imports={}))
    public void setBuffer(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        throw new UnsupportedOperationException("This input does not used a byte[], see #setBuffer(ByteBuf).");
    }

    @Deprecated(message="This input does not used a byte[], see #setByteBuf().", replaceWith=@ReplaceWith(expression="setBuffer(ByteBuf)", imports={}))
    public void setBuffer(@NotNull byte[] bytes, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        throw new UnsupportedOperationException("This input does not used a byte[], see #setBuffer().");
    }

    public final void setBuffer(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.byteBuf = buffer;
        this.initialReaderIndex = this.getByteBuf().readerIndex();
        this.initialWriterIndex = this.getByteBuf().writerIndex();
        this.position = this.initialReaderIndex;
        this.limit = this.initialWriterIndex;
        this.capacity = buffer.capacity();
        this.total = 0L;
        this.inputStream = null;
    }

    public void setInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.inputStream = inputStream;
        this.limit = 0;
        this.reset();
    }

    public void reset() {
        super.reset();
        this.getByteBuf().setIndex(this.initialReaderIndex, this.initialWriterIndex);
    }

    protected final int fill(@Nullable ByteBuf buffer, int offset, int count) throws KryoException {
        int n;
        int count2 = count;
        if (this.inputStream == null) {
            n = -1;
        } else {
            int n2;
            try {
                if (this.tempBuffer == null) {
                    this.tempBuffer = new byte[2048];
                }
                ByteBuf byteBuf = buffer;
                Intrinsics.checkNotNull((Object)byteBuf);
                byteBuf.readerIndex(offset);
                int total = 0;
                while (count2 > 0) {
                    Intrinsics.checkNotNull((Object)this.tempBuffer);
                    int read = this.inputStream.read(this.tempBuffer, 0, Math.min(this.tempBuffer.length, count2));
                    if (read == -1) {
                        if (total != 0) break;
                        return -1;
                    }
                    buffer.writeBytes(this.tempBuffer, 0, read);
                    count2 -= read;
                    total += read;
                }
                buffer.readerIndex(offset);
                n2 = total;
            }
            catch (IOException ex) {
                throw new KryoException((Throwable)ex);
            }
            n = n2;
        }
        return n;
    }

    protected int require(int required) throws KryoException {
        int remaining = this.limit - this.position;
        if (remaining >= required) {
            return remaining;
        }
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        int count = 0;
        if (remaining > 0) {
            count = this.fill(this.getByteBuf(), this.limit, this.capacity - this.limit);
            if (count == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((remaining += count) >= required) {
                this.limit += count;
                return remaining;
            }
        }
        return remaining;
    }

    protected int optional(int optional) throws KryoException {
        int remaining = this.limit - this.position;
        int optional2 = optional;
        if (remaining >= optional2) {
            return optional2;
        }
        optional2 = Math.min(optional2, this.capacity);
        int count = this.fill(this.getByteBuf(), this.limit, this.capacity - this.limit);
        if (count == -1) {
            return remaining == 0 ? -1 : Math.min(remaining, optional2);
        }
        if ((remaining += count) >= optional2) {
            this.limit += count;
            return optional2;
        }
        return remaining == 0 ? -1 : Math.min(remaining, optional2);
    }

    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        int n = this.position;
        this.position = n + 1;
        return this.getByteBuf().readByte() & 0xFF;
    }

    public int read(@NotNull byte[] bytes) throws KryoException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.read(bytes, 0, bytes.length);
    }

    public int read(@NotNull byte[] bytes, int offset, int count) throws KryoException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int offset2 = offset;
        int count2 = count;
        int startingCount = count2;
        int copyCount = Math.min(this.limit - this.position, count2);
        do {
            this.getByteBuf().getBytes(this.position, bytes, offset2, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset2 += copyCount;
            copyCount = this.optional(count2);
            if (copyCount != -1) continue;
            if (startingCount == count2) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return startingCount - count2;
    }

    public void setPosition(int position) {
        this.position = position;
        this.getByteBuf().readerIndex(position);
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.getByteBuf().writerIndex(limit);
    }

    public void skip(int count) throws KryoException {
        super.skip(count);
        this.getByteBuf().readerIndex(this.position);
    }

    public long skip(long count) throws KryoException {
        int skip;
        for (long remaining = count; remaining > 0L; remaining -= (long)skip) {
            skip = (int)Math.min(0x7FFFFFF7L, remaining);
            this.skip(skip);
        }
        return count;
    }

    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte readByte() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        int n = this.position;
        this.position = n + 1;
        return this.getByteBuf().readByte();
    }

    public int readByteUnsigned() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        int n = this.position;
        this.position = n + 1;
        return this.getByteBuf().readByte() & 0xFF;
    }

    @NotNull
    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return bytes;
    }

    public void readBytes(@NotNull byte[] bytes, int offset, int count) throws KryoException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int offset2 = offset;
        int count2 = count;
        int copyCount = Math.min(this.limit - this.position, count2);
        while (true) {
            this.getByteBuf().readBytes(bytes, offset2, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset2 += copyCount;
            copyCount = Math.min(count2, this.capacity);
            this.require(copyCount);
        }
    }

    public int readInt() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.getByteBuf().readInt();
    }

    public int readVarInt(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 5) {
            return this.readVarInt_slow(optimizePositive);
        }
        ByteBuf byteBuf = this.getByteBuf();
        byte b = byteBuf.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = byteBuf.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = byteBuf.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = byteBuf.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = byteBuf.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        this.position = byteBuf.readerIndex();
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    private final int readVarInt_slow(boolean optimizePositive) {
        int n = this.position;
        this.position = n + 1;
        ByteBuf byteBuf = this.getByteBuf();
        byte b = byteBuf.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int n2 = this.position;
            this.position = n2 + 1;
            b = byteBuf.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                n2 = this.position;
                this.position = n2 + 1;
                b = byteBuf.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    n2 = this.position;
                    this.position = n2 + 1;
                    b = byteBuf.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        n2 = this.position;
                        this.position = n2 + 1;
                        b = byteBuf.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public boolean canReadVarInt() throws KryoException {
        if (this.limit - this.position >= 5) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        int limit = this.limit;
        ByteBuf byteBuf = this.getByteBuf();
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        return p != limit;
    }

    public boolean readVarIntFlag() {
        if (this.position == this.limit) {
            this.require(1);
        }
        return (this.getByteBuf().getByte(this.position) & 0x80) != 0;
    }

    public int readVarIntFlag(boolean optimizePositive) {
        if (this.require(1) < 5) {
            return this.readVarIntFlag_slow(optimizePositive);
        }
        ByteBuf byteBuf = this.getByteBuf();
        byte b = byteBuf.readByte();
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            b = byteBuf.readByte();
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                b = byteBuf.readByte();
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    b = byteBuf.readByte();
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        b = byteBuf.readByte();
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        this.position = byteBuf.readerIndex();
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    private final int readVarIntFlag_slow(boolean optimizePositive) {
        int n = this.position;
        this.position = n + 1;
        byte b = this.getByteBuf().readByte();
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int n2 = this.position;
            this.position = n2 + 1;
            ByteBuf byteBuf = this.getByteBuf();
            b = byteBuf.readByte();
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                int n3 = this.position;
                this.position = n3 + 1;
                b = byteBuf.readByte();
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    n3 = this.position;
                    this.position = n3 + 1;
                    b = byteBuf.readByte();
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        n3 = this.position;
                        this.position = n3 + 1;
                        b = byteBuf.readByte();
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public long readLong() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.getByteBuf().readLong();
    }

    public long readVarLong(boolean optimizePositive) throws KryoException {
        if (this.require(1) < 9) {
            return this.readVarLong_slow(optimizePositive);
        }
        ByteBuf byteBuf = this.getByteBuf();
        byte b = byteBuf.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = byteBuf.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = byteBuf.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = byteBuf.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = byteBuf.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = byteBuf.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = byteBuf.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = byteBuf.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = byteBuf.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.position = byteBuf.readerIndex();
        return optimizePositive ? result : result >>> 1 ^ -(result & 1L);
    }

    private final long readVarLong_slow(boolean optimizePositive) {
        int n = this.position;
        this.position = n + 1;
        ByteBuf byteBuf = this.getByteBuf();
        byte b = byteBuf.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int n2 = this.position;
            this.position = n2 + 1;
            b = byteBuf.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                if (this.position == this.limit) {
                    this.require(1);
                }
                n2 = this.position;
                this.position = n2 + 1;
                b = byteBuf.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    n2 = this.position;
                    this.position = n2 + 1;
                    b = byteBuf.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        if (this.position == this.limit) {
                            this.require(1);
                        }
                        n2 = this.position;
                        this.position = n2 + 1;
                        b = byteBuf.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            if (this.position == this.limit) {
                                this.require(1);
                            }
                            n2 = this.position;
                            this.position = n2 + 1;
                            b = byteBuf.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                if (this.position == this.limit) {
                                    this.require(1);
                                }
                                n2 = this.position;
                                this.position = n2 + 1;
                                b = byteBuf.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    if (this.position == this.limit) {
                                        this.require(1);
                                    }
                                    n2 = this.position;
                                    this.position = n2 + 1;
                                    b = byteBuf.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        if (this.position == this.limit) {
                                            this.require(1);
                                        }
                                        n2 = this.position;
                                        this.position = n2 + 1;
                                        b = byteBuf.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1L);
    }

    public boolean canReadVarLong() throws KryoException {
        if (this.limit - this.position >= 9) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        int limit = this.limit;
        ByteBuf byteBuf = this.getByteBuf();
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        if (p == limit) {
            return false;
        }
        if ((byteBuf.getByte(p++) & 0x80) == 0) {
            return true;
        }
        return p != limit;
    }

    public float readFloat() throws KryoException {
        this.require(4);
        int p = this.position;
        this.position = p + 4;
        return this.getByteBuf().readFloat();
    }

    public double readDouble() throws KryoException {
        this.require(8);
        int p = this.position;
        this.position = p + 8;
        return this.getByteBuf().readDouble();
    }

    public boolean readBoolean() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        int n = this.position;
        this.position = n + 1;
        return this.getByteBuf().readByte() == 1;
    }

    public short readShort() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.getByteBuf().readShort();
    }

    public int readShortUnsigned() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.getByteBuf().readUnsignedShort();
    }

    public char readChar() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.getByteBuf().readChar();
    }

    @Nullable
    public String readString() {
        if (!this.readVarIntFlag()) {
            return this.readAsciiString();
        }
        int charCount = this.readVarIntFlag(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        this.readUtf8Chars(--charCount);
        Intrinsics.checkNotNullExpressionValue((Object)this.chars, (String)"chars");
        char[] cArray = this.chars;
        int n = 0;
        return new String(cArray, n, charCount);
    }

    @Nullable
    public StringBuilder readStringBuilder() {
        if (!this.readVarIntFlag()) {
            return new StringBuilder(this.readAsciiString());
        }
        int charCount = this.readVarIntFlag(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        this.readUtf8Chars(--charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }

    private final void readUtf8Chars(int charCount) {
        byte b;
        if (this.chars.length < charCount) {
            this.chars = new char[charCount];
        }
        char[] chars = this.chars;
        ByteBuf byteBuf = this.getByteBuf();
        int charIndex = 0;
        int count = RangesKt.coerceAtMost((int)this.require(1), (int)charCount);
        while (charIndex < count && (b = byteBuf.readByte()) >= 0) {
            chars[charIndex++] = (char)b;
        }
        this.position += charIndex;
        if (charIndex < charCount) {
            byteBuf.readerIndex(this.position);
            this.readUtf8Chars_slow(charCount, charIndex);
        }
    }

    private final void readUtf8Chars_slow(int charCount, int charIndex) {
        ByteBuf byteBuf = this.getByteBuf();
        char[] chars = this.chars;
        block5: for (int index = charIndex; index < charCount; ++index) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int n = this.position;
            this.position = n + 1;
            int b = byteBuf.readByte() & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[index] = (char)b;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    int n2 = this.position;
                    this.position = n2 + 1;
                    chars[index] = (char)((b & 0x1F) << 6 | byteBuf.readByte() & 0x3F);
                    continue block5;
                }
                case 14: {
                    this.require(2);
                    this.position += 2;
                    byte b2 = byteBuf.readByte();
                    byte b3 = byteBuf.readByte();
                    chars[index] = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                }
            }
        }
    }

    private final String readAsciiString() {
        int charCount;
        char[] chars = this.chars;
        ByteBuf byteBuf = this.getByteBuf();
        int n = Math.min(chars.length, this.limit - this.position);
        for (charCount = 0; charCount < n; ++charCount) {
            byte b = byteBuf.readByte();
            if ((b & 0x80) == 128) {
                this.position = byteBuf.readerIndex();
                chars[charCount] = (char)(b & 0x7F);
                Intrinsics.checkNotNullExpressionValue((Object)chars, (String)"chars");
                return new String(chars, 0, charCount + 1);
            }
            chars[charCount] = (char)b;
        }
        this.position = byteBuf.readerIndex();
        return this.readAscii_slow(charCount);
    }

    private final String readAscii_slow(int charCount) {
        int charCount2 = charCount;
        char[] chars = this.chars;
        ByteBuf byteBuf = this.getByteBuf();
        while (true) {
            if (this.position == this.limit) {
                this.require(1);
            }
            int n = this.position;
            this.position = n + 1;
            byte b = byteBuf.readByte();
            if (charCount2 == chars.length) {
                char[] newChars = new char[charCount2 * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount2);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b & 0x80) == 128) {
                chars[charCount2] = (char)(b & 0x7F);
                Intrinsics.checkNotNullExpressionValue((Object)chars, (String)"chars");
                char[] cArray = chars;
                int n2 = 0;
                int n3 = charCount2 + 1;
                return new String(cArray, n2, n3);
            }
            chars[charCount2++] = (char)b;
        }
    }

    @NotNull
    public int[] readInts(int length) throws KryoException {
        int[] array = new int[length];
        if (this.optional(length << 2) == length << 2) {
            ByteBuf byteBuf = this.getByteBuf();
            for (int i = 0; i < length; ++i) {
                array[i] = byteBuf.readInt();
            }
            this.position = byteBuf.readerIndex();
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readInt();
            }
        }
        return array;
    }

    @NotNull
    public long[] readLongs(int length) throws KryoException {
        long[] array = new long[length];
        if (this.optional(length << 3) == length << 3) {
            ByteBuf byteBuf = this.getByteBuf();
            for (int i = 0; i < length; ++i) {
                array[i] = byteBuf.readLong();
            }
            this.position = byteBuf.readerIndex();
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readLong();
            }
        }
        return array;
    }

    @NotNull
    public float[] readFloats(int length) throws KryoException {
        float[] array = new float[length];
        if (this.optional(length << 2) == length << 2) {
            ByteBuf byteBuf = this.getByteBuf();
            for (int i = 0; i < length; ++i) {
                array[i] = byteBuf.readFloat();
            }
            this.position = byteBuf.readerIndex();
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readFloat();
            }
        }
        return array;
    }

    @NotNull
    public double[] readDoubles(int length) throws KryoException {
        double[] array = new double[length];
        if (this.optional(length << 3) == length << 3) {
            ByteBuf byteBuf = this.getByteBuf();
            for (int i = 0; i < length; ++i) {
                array[i] = byteBuf.readDouble();
            }
            this.position = byteBuf.readerIndex();
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readDouble();
            }
        }
        return array;
    }

    @NotNull
    public short[] readShorts(int length) throws KryoException {
        short[] array = new short[length];
        if (this.optional(length << 1) == length << 1) {
            ByteBuf byteBuf = this.getByteBuf();
            for (int i = 0; i < length; ++i) {
                array[i] = (short)(byteBuf.readByte() & 0xFF | (byteBuf.readByte() & 0xFF) << 8);
            }
            this.position = byteBuf.readerIndex();
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readShort();
            }
        }
        return array;
    }

    @NotNull
    public char[] readChars(int length) throws KryoException {
        char[] array = new char[length];
        if (this.optional(length << 1) == length << 1) {
            ByteBuf byteBuf = this.getByteBuf();
            for (int i = 0; i < length; ++i) {
                array[i] = (char)(byteBuf.readByte() & 0xFF | (byteBuf.readByte() & 0xFF) << 8);
            }
            this.position = byteBuf.readerIndex();
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readChar();
            }
        }
        return array;
    }

    @NotNull
    public boolean[] readBooleans(int length) throws KryoException {
        boolean[] array = new boolean[length];
        if (this.optional(length) == length) {
            ByteBuf byteBuf = this.getByteBuf();
            for (int i = 0; i < length; ++i) {
                array[i] = byteBuf.readByte() != 0;
            }
            this.position = byteBuf.readerIndex();
        } else {
            for (int i = 0; i < length; ++i) {
                array[i] = this.readBoolean();
            }
        }
        return array;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/bytes/ByteBufInput$Companion;", "", "()V", "version", "", "ByteUtilities"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

