/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.parser;

import de.peeeq.wurstscript.utils.LineOffsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public class WPos {
    private final String file;
    private final @Nullable LineOffsets lineOffsets;
    private final int leftPos;
    private final int rightPos;
    private static final Pattern p = Pattern.compile("^.*[/\\\\]([^/\\\\]+)\\.[^.]*$");

    public WPos(String file, @Nullable LineOffsets lineOffsets, int leftPos, int rightPos) {
        this.file = file;
        this.lineOffsets = lineOffsets;
        this.leftPos = leftPos;
        this.rightPos = rightPos;
    }

    public String getFile() {
        return this.file;
    }

    public @Nullable LineOffsets getLineOffsets() {
        return this.lineOffsets;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getRightPos() {
        return this.rightPos;
    }

    public int getLine() {
        LineOffsets lo = this.lineOffsets;
        if (lo == null) {
            return 0;
        }
        return lo.getLine(this.leftPos);
    }

    public int getEndLine() {
        LineOffsets lo = this.lineOffsets;
        if (lo == null) {
            return 0;
        }
        return lo.getLine(this.rightPos);
    }

    public int getStartColumn() {
        LineOffsets lo = this.lineOffsets;
        if (lo == null) {
            return 0;
        }
        return lo.getColumn(this.leftPos);
    }

    public int getEndColumn() {
        LineOffsets lo = this.lineOffsets;
        if (lo == null) {
            return 0;
        }
        return lo.getColumn(this.rightPos);
    }

    public WPos withRightPos(int rightPos) {
        return new WPos(this.file, this.lineOffsets, this.leftPos, rightPos);
    }

    public String toString() {
        return "";
    }

    public String print() {
        return "[" + this.file + " line " + this.getLine() + "]";
    }

    public String printShort() {
        String shortFile = this.file;
        Matcher m = p.matcher(this.file);
        if (m.find()) {
            shortFile = m.group(1);
        }
        return shortFile + ", line " + this.getLine();
    }

    public WPos withLeftPos(int leftPos) {
        return new WPos(this.file, this.lineOffsets, leftPos, this.rightPos);
    }

    public WPos withFile(String file) {
        return new WPos(file, this.lineOffsets, this.leftPos, this.rightPos);
    }

    public String shortFile() {
        String s = this.getFile();
        s = s.substring(s.lastIndexOf("lib/") + 4);
        s = s.replace(".wurst", "");
        return s;
    }

    public WPos artificial() {
        return new WPos(this.file, this.lineOffsets, this.leftPos, this.leftPos - 1);
    }

    public boolean isArtificial() {
        return this.getRightPos() < this.getLeftPos();
    }
}

