/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.misc.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Packed {
    private static final Logger log = LoggerFactory.getLogger((String)FlagsInt.class.getName());

    public static Wc3BinOutputStream compress(@Nonnull Wc3BinInputStream inStream) throws BinStream.StreamException {
        Vector<byte[]> blocks = new Vector<byte[]>();
        Vector<byte[]> uncompressedBlocks = new Vector<byte[]>();
        long compressedSize = 0L;
        long uncompressedSize = 0L;
        while (!inStream.eof()) {
            Deflater deflater = new Deflater();
            byte[] uncompressedBlock = new byte[(int)Math.min(1024L, inStream.size() - inStream.getPos())];
            uncompressedBlocks.add(uncompressedBlock);
            uncompressedSize += (long)uncompressedBlock.length;
            deflater.setInput(inStream.readBytes(uncompressedBlock.length));
            int len = deflater.deflate(uncompressedBlock);
            byte[] block = Arrays.copyOf(uncompressedBlock, len);
            blocks.add(block);
            compressedSize += (long)block.length;
        }
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(new ByteArrayOutputStream());
        String startTokenS = "Warcraft III recorded game \u0000x1A";
        outStream.writeBytes(startTokenS.getBytes(StandardCharsets.US_ASCII));
        outStream.writeUInt32(68L);
        outStream.writeUInt32(compressedSize);
        outStream.writeUInt32(1L);
        outStream.writeUInt32(uncompressedSize);
        outStream.writeUInt32(blocks.size());
        outStream.writeId(Id.valueOf("W3XP"));
        outStream.writeUInt32(0L);
        outStream.writeUInt16(0);
        outStream.writeUInt16(0);
        outStream.writeUInt32(0L);
        CRC32 crc = new CRC32();
        int i = 0;
        while ((long)i < outStream.size()) {
            crc.update(outStream.get(i));
            ++i;
        }
        outStream.writeUInt32(crc.getValue());
        int c = 0;
        for (byte[] block : blocks) {
            outStream.writeUInt16(block.length);
            outStream.writeUInt16(((byte[])uncompressedBlocks.get(c)).length);
            outStream.writeBytes(block);
            ++c;
        }
        return outStream;
    }

    public static Wc3BinInputStream decompress(@Nonnull Wc3BinInputStream inStream) throws BinStream.StreamException {
        byte[] startToken = inStream.readBytes(28);
        long headerSize = inStream.readUInt32();
        long compressedFileSize = inStream.readUInt32();
        long headerVersion = inStream.readUInt32();
        long uncompressedFileSize = inStream.readUInt32();
        long blocksCount = inStream.readUInt32();
        switch ((int)headerVersion) {
            case 0: {
                int unknown = inStream.readUInt16();
                long version = inStream.readUInt32();
                break;
            }
            default: {
                Id id = inStream.readId();
                long version = inStream.readUInt32();
            }
        }
        int buildNum = inStream.readUInt16();
        int flags = inStream.readUInt16();
        long len = inStream.readUInt32();
        long crc32 = inStream.readUInt32();
        Vector<byte[]> blocks = new Vector<byte[]>();
        Vector<byte[]> uncompressedBlocks = new Vector<byte[]>();
        int i = 0;
        while ((long)i < blocksCount) {
            int compressedSize = inStream.readUInt16();
            int uncompressedSize = inStream.readUInt16();
            long hash = inStream.readUInt32();
            blocks.add(inStream.readBytes(compressedSize));
            uncompressedBlocks.add(new byte[uncompressedSize]);
            ++i;
        }
        int c = 0;
        for (byte[] block : blocks) {
            Inflater inflater = new Inflater();
            inflater.setInput(block);
            try {
                inflater.inflate((byte[])uncompressedBlocks.get(c));
            }
            catch (DataFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ++c;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            for (byte[] block : uncompressedBlocks) {
                outStream.write(block);
            }
            outStream.close();
            return new Wc3BinInputStream(new ByteArrayInputStream(outStream.toByteArray()));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

