/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import systems.crigges.jmpq3.JMpqException;
import systems.crigges.jmpq3.security.MPQHashGenerator;

public class HashTable {
    private static final int ENTRY_UNUSED = -1;
    private static final int ENTRY_DELETED = -2;
    public static final short DEFAULT_LOCALE = 0;
    private final Bucket[] buckets;
    private int mappingNumber = 0;

    public HashTable(int capacity) {
        if (capacity <= 0 || (capacity & capacity - 1) != 0) {
            throw new IllegalArgumentException("Capacity must be power of 2.");
        }
        this.buckets = new Bucket[capacity];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Bucket();
        }
    }

    public void readFromBuffer(ByteBuffer src) {
        for (Bucket entry : this.buckets) {
            entry.readFromBuffer(src);
            int blockIndex = entry.blockTableIndex;
            if (blockIndex == -1 || blockIndex == -2) continue;
            ++this.mappingNumber;
        }
    }

    public void writeToBuffer(ByteBuffer dest) {
        for (Bucket bucket : this.buckets) {
            bucket.writeToBuffer(dest);
        }
    }

    private int getFileEntryIndex(FileIdentifier file) {
        int mask = this.buckets.length - 1;
        int start = file.offset & mask;
        int bestEntryIndex = -1;
        for (int c = 0; c < this.buckets.length; ++c) {
            int index = start + c & mask;
            Bucket entry = this.buckets[index];
            if (entry.blockTableIndex == -1) break;
            if (entry.blockTableIndex == -2 || entry.key != file.key) continue;
            if (entry.locale == file.locale) {
                return index;
            }
            if (bestEntryIndex != -1 && entry.locale != 0) continue;
            bestEntryIndex = index;
        }
        return bestEntryIndex;
    }

    private Bucket getFileEntry(FileIdentifier file) {
        int index = this.getFileEntryIndex(file);
        return index != -1 ? this.buckets[index] : null;
    }

    public boolean hasFile(String file) {
        return this.getFileEntryIndex(new FileIdentifier(file, 0)) != -1;
    }

    public int getBlockIndexOfFile(String name) throws IOException {
        return this.getFileBlockIndex(name, (short)0);
    }

    public int getFileBlockIndex(String name, short locale) throws IOException {
        FileIdentifier fid = new FileIdentifier(name, locale);
        Bucket entry = this.getFileEntry(fid);
        if (entry == null) {
            throw new JMpqException("File Not Found <" + name + ">.");
        }
        if (entry.blockTableIndex < 0) {
            throw new JMpqException("File has invalid block table index <" + entry.blockTableIndex + ">.");
        }
        return entry.blockTableIndex;
    }

    public void setFileBlockIndex(String name, short locale, int blockIndex) throws IOException {
        if (blockIndex < 0) {
            throw new IllegalArgumentException("Block index numbers cannot be negative.");
        }
        FileIdentifier fid = new FileIdentifier(name, locale);
        Bucket exist = this.getFileEntry(fid);
        if (exist != null && exist.locale == locale) {
            exist.blockTableIndex = blockIndex;
            return;
        }
        if (this.mappingNumber == this.buckets.length) {
            throw new JMpqException("Hash table cannot fit another mapping.");
        }
        int mask = this.buckets.length - 1;
        int start = fid.offset & mask;
        Bucket newEntry = null;
        for (int c = 0; c < this.buckets.length; ++c) {
            Bucket entry = this.buckets[start + c & mask];
            if (entry.blockTableIndex != -1 && entry.blockTableIndex != -2) continue;
            newEntry = entry;
            break;
        }
        if (newEntry != null) {
            newEntry.key = fid.key;
            newEntry.locale = fid.locale;
            newEntry.blockTableIndex = blockIndex;
            ++this.mappingNumber;
        }
    }

    private void removeFileEntry(int index) {
        int bi = this.buckets[index].blockTableIndex;
        if (bi == -1 || bi == -2) {
            throw new IllegalArgumentException("Bucket already clear.");
        }
        Bucket newEntry = new Bucket();
        newEntry.blockTableIndex = -2;
        this.buckets[index] = newEntry;
        --this.mappingNumber;
        int mask = this.buckets.length - 1;
        if (this.buckets[index + 1 & mask].blockTableIndex == -1) {
            int i = index;
            while (true) {
                Bucket entry = this.buckets[i];
                if (entry.blockTableIndex != -2) break;
                entry.blockTableIndex = -1;
                i = i - 1 & mask;
            }
        }
    }

    public void removeFile(String name, short locale) throws IOException {
        FileIdentifier fid = new FileIdentifier(name, locale);
        int index = this.getFileEntryIndex(fid);
        if (index == -1 || this.buckets[index].locale != locale) {
            throw new JMpqException("File Not Found <" + name + ">");
        }
        this.removeFileEntry(index);
    }

    public int removeFileAll(String name) throws IOException {
        int index;
        FileIdentifier fid = new FileIdentifier(name, 0);
        int count = 0;
        while ((index = this.getFileEntryIndex(fid)) != -1) {
            this.removeFileEntry(index);
            ++count;
        }
        if (count == 0) {
            throw new JMpqException("File Not Found <" + name + ">");
        }
        return count;
    }

    public static long calculateFileKey(String name) {
        MPQHashGenerator key1Gen = MPQHashGenerator.getTableKey1Generator();
        key1Gen.process(name);
        int key1 = key1Gen.getHash();
        MPQHashGenerator key2Gen = MPQHashGenerator.getTableKey2Generator();
        key2Gen.process(name);
        int key2 = key2Gen.getHash();
        return (long)key2 << 32 | Integer.toUnsignedLong(key1);
    }

    private static class Bucket {
        private long key = 0L;
        private short locale = 0;
        private int blockTableIndex = -1;

        public void readFromBuffer(ByteBuffer src) {
            src.order(ByteOrder.LITTLE_ENDIAN);
            this.key = src.getLong();
            this.locale = src.getShort();
            src.getShort();
            this.blockTableIndex = src.getInt();
        }

        public void writeToBuffer(ByteBuffer dest) {
            dest.order(ByteOrder.LITTLE_ENDIAN);
            dest.putLong(this.key);
            dest.putShort(this.locale);
            dest.putShort((short)0);
            dest.putInt(this.blockTableIndex);
        }

        public String toString() {
            return "Entry [key=" + this.key + ",\tlcLocale=" + this.locale + ",\tdwBlockIndex=" + this.blockTableIndex + "]";
        }
    }

    private static class FileIdentifier {
        private final long key;
        private final int offset;
        private final short locale;

        public FileIdentifier(String name, short locale) {
            MPQHashGenerator offsetGen = MPQHashGenerator.getTableOffsetGenerator();
            offsetGen.process(name);
            this.offset = offsetGen.getHash();
            this.key = HashTable.calculateFileKey(name);
            this.locale = locale;
        }
    }
}

