/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaTableField;
import de.peeeq.wurstscript.luaAst.LuaTableSingleField;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.function.Consumer;

class LuaTableSingleFieldImpl
implements LuaTableSingleField {
    private Element parent;
    private LuaExpr val;

    LuaTableSingleFieldImpl(LuaExpr val) {
        if (val == null) {
            throw new IllegalArgumentException("Element val must not be null.");
        }
        this.val = val;
        val.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setVal(LuaExpr val) {
        if (val == null) {
            throw new IllegalArgumentException();
        }
        this.val.setParent(null);
        val.setParent(this);
        this.val = val;
    }

    @Override
    public LuaExpr getVal() {
        return this.val;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.val;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaExpr oldElem = this.val;
                this.setVal((LuaExpr)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.val);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public LuaTableSingleField copy() {
        LuaTableSingleFieldImpl result = new LuaTableSingleFieldImpl(this.val.copy());
        return result;
    }

    @Override
    public LuaTableSingleField copyWithRefs() {
        final LuaTableSingleField res = this.copy();
        final LuaTableSingleFieldImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.val.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaTableSingleField(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaTableSingleField(this);
    }

    @Override
    public <T> T match(LuaTableField.Matcher<T> matcher) {
        return matcher.case_LuaTableSingleField(this);
    }

    @Override
    public void match(LuaTableField.MatcherVoid matcher) {
        matcher.case_LuaTableSingleField(this);
    }

    public String toString() {
        return "LuaTableSingleField(" + this.val + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaTableSingleField) {
            LuaTableSingleField o = (LuaTableSingleField)e;
            return this.val.structuralEquals(o.getVal());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

