/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Format<T> {
    private static final Map<Class<? extends Format>, Map<Integer, Format>> _instanceMap = new LinkedHashMap<Class<? extends Format>, Map<Integer, Format>>();
    private final T _enumVal;
    private final Integer _version;

    @Nonnull
    public static <FormatType extends Format> Map<Integer, Format> getAll(@Nonnull Class<FormatType> formatClass) {
        return _instanceMap.get(formatClass);
    }

    @Nullable
    public static <FormatType extends Format> FormatType get(@Nonnull Class<FormatType> formatClass, int version) {
        return (FormatType)_instanceMap.get(formatClass).get(version);
    }

    @Nullable
    public static Format valueOf(@Nonnull Integer version) {
        return null;
    }

    @Nonnull
    public T toEnum() {
        return this._enumVal;
    }

    @Nonnull
    public Integer getVersion() {
        return this._version;
    }

    public Format(@Nonnull T enumVal, @Nullable Integer val) {
        this._enumVal = enumVal;
        this._version = val;
        if (this._version != null) {
            if (!_instanceMap.containsKey(this.getClass())) {
                _instanceMap.put(this.getClass(), new LinkedHashMap());
            }
            if (_instanceMap.get(this.getClass()).containsKey(this._version)) {
                throw new RuntimeException(this._version + " already used");
            }
            _instanceMap.get(this.getClass()).put(this._version, this);
        }
    }

    public static class InvalidFormatException
    extends RuntimeException {
        private final Integer _version;
        private final Format _format;

        @Override
        @Nonnull
        public String toString() {
            if (this._format != null) {
                return this._format.toString();
            }
            if (this._version != null) {
                return this._version.toString();
            }
            return super.toString();
        }

        public InvalidFormatException(int version) {
            this._version = version;
            this._format = null;
        }

        public InvalidFormatException(@Nonnull Format format) {
            this._version = null;
            this._format = format;
        }
    }
}

