/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.HasModifier;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.ModAbstract;
import de.peeeq.wurstscript.ast.ModConstant;
import de.peeeq.wurstscript.ast.ModOverride;
import de.peeeq.wurstscript.ast.ModStatic;
import de.peeeq.wurstscript.ast.ModVararg;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.VisibilityPrivate;
import de.peeeq.wurstscript.ast.VisibilityProtected;
import de.peeeq.wurstscript.ast.VisibilityPublic;
import de.peeeq.wurstscript.ast.VisibilityPublicread;
import de.peeeq.wurstscript.attributes.HasAnnotation;

public class ModifiersHelper {
    public static boolean isPublic(HasModifier e) {
        return ModifiersHelper.containsType(e.getModifiers(), VisibilityPublic.class);
    }

    public static boolean isProtected(HasModifier e) {
        return ModifiersHelper.containsType(e.getModifiers(), VisibilityProtected.class);
    }

    public static boolean isPublicRead(HasModifier e) {
        return ModifiersHelper.containsType(e.getModifiers(), VisibilityPublicread.class);
    }

    public static boolean isPrivate(HasModifier e) {
        return ModifiersHelper.containsType(e.getModifiers(), VisibilityPrivate.class);
    }

    public static boolean isStatic(HasModifier e) {
        return ModifiersHelper.containsType(e.getModifiers(), ModStatic.class);
    }

    public static boolean isOverride(HasModifier e) {
        return ModifiersHelper.containsType(e.getModifiers(), ModOverride.class);
    }

    public static boolean isVararg(HasModifier e) {
        return ModifiersHelper.containsType(e.getModifiers(), ModVararg.class);
    }

    public static boolean isAbstract(HasModifier e) {
        if (e instanceof FuncDef && e.attrNearestStructureDef() instanceof InterfaceDef) {
            FuncDef f = (FuncDef)e;
            return f.attrHasEmptyBody();
        }
        return ModifiersHelper.containsType(e.getModifiers(), ModAbstract.class);
    }

    public static boolean isConstant(HasModifier e) {
        return ModifiersHelper.containsType(e.getModifiers(), ModConstant.class);
    }

    static boolean containsType(Modifiers modifiers, Class<? extends Modifier> class1) {
        if (modifiers.size() > 0) {
            for (Modifier m : modifiers) {
                if (!m.getClass().getName().startsWith(class1.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCompiletime(HasModifier e) {
        if (e instanceof HasModifier) {
            return ModifiersHelper.hasAnnotation(e, "compiletime");
        }
        return false;
    }

    public static boolean hasAnnotation(HasModifier e, String name) {
        return ModifiersHelper.hasAnnotation(e.getModifiers(), name);
    }

    public static Annotation getAnnotation(HasModifier e, String name) {
        return ModifiersHelper.getAnnotation(e.getModifiers(), name);
    }

    private static Annotation getAnnotation(Modifiers modifiers, String name) {
        String searchName = HasAnnotation.normalizeAnnotation(name);
        for (Modifier m : modifiers) {
            Annotation annotation;
            if (!(m instanceof Annotation) || !HasAnnotation.normalizeAnnotation((annotation = (Annotation)m).getAnnotationType()).equals(searchName)) continue;
            return annotation;
        }
        return null;
    }

    private static boolean hasAnnotation(Modifiers modifiers, String name) {
        String searchName = HasAnnotation.normalizeAnnotation(name);
        for (Modifier m : modifiers) {
            Annotation annotation;
            if (!(m instanceof Annotation) || !HasAnnotation.normalizeAnnotation((annotation = (Annotation)m).getAnnotationType()).equals(searchName)) continue;
            return true;
        }
        return false;
    }
}

