/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.terrainArts;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.AlphaMode;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.SoundLabel;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.dataTypes.app.WeatherId;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.RawSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.SLKState;

public class WeatherSLK
extends ObjSLK<WeatherSLK, WeatherId, Obj> {
    public static final File GAME_PATH = new File("TerrainArt\\Weather.slk");

    @Override
    @Nonnull
    public Map<WeatherId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((WeatherId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(WeatherId.valueOf(id));
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull WeatherId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    @Override
    public void merge(@Nonnull WeatherSLK other, boolean overwrite) {
        for (Obj otherObj : other.getObjs().values()) {
            WeatherId objId = (WeatherId)otherObj.getId();
            Obj obj = this.addObj(objId);
            obj.merge(otherObj, true);
        }
    }

    private void reduce() {
        for (Obj obj : this.getObjs().values()) {
            obj.reduce();
        }
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        WeatherSLK other = new WeatherSLK();
        System.out.println("read " + slk.getObjs().size());
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            other.addObj(obj);
            obj.merge(slkObj);
        }
        this.merge(other);
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        this.read(new RawSLK(file));
        this.read(this);
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        WeatherSLK other = new WeatherSLK();
        other.merge(this);
    }

    public WeatherSLK(SLK slk) {
        this();
        this.read(slk);
    }

    public WeatherSLK(File file) throws IOException {
        this();
        this.read(new RawSLK(file));
    }

    public void toJSON() {
    }

    public WeatherSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    public static class Obj
    extends SLK.Obj<WeatherId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public Path getTex() {
            return Paths.get(this.get(State.ART_TEX_DIR).getVal(), this.get(State.ART_TEX_FILE).getVal());
        }

        public void setTex(Path path) {
            this.set(State.ART_TEX_DIR, War3String.valueOf(path.getParent().toString()));
            this.set(State.ART_TEX_FILE, War3String.valueOf(path.getFileName().toString()));
        }

        public AlphaMode getAlphaMode() {
            return this.get(State.ART_ALPHA_MODE);
        }

        public void setAlphaMode(WeatherId val) {
            this.set((SLKState)State.ART_ALPHA_MODE, (DataType)val);
        }

        public War3Bool getUseFog() {
            return this.get(State.ART_USE_FOG);
        }

        public void setUseFog(War3Bool val) {
            this.set(State.ART_USE_FOG, val);
        }

        public War3Real getHeight() {
            return this.get(State.ART_HEIGHT);
        }

        public void setHeight(War3Real val) {
            this.set(State.ART_HEIGHT, val);
        }

        public War3Real getAngX() {
            return this.get(State.ART_ANGLE_X);
        }

        public War3Real getAngY() {
            return this.get(State.ART_ANGLE_Y);
        }

        public void setAng(War3Real x, War3Real y) {
            this.set(State.ART_ANGLE_X, x);
            this.set(State.ART_ANGLE_Y, y);
        }

        public War3Real getEmissionRate() {
            return this.get(State.ART_EMISSION_RATE);
        }

        public void setEmissionRate(War3Real val) {
            this.set(State.ART_EMISSION_RATE, val);
        }

        public War3Real getLifespan() {
            return this.get(State.ART_LIFESPAN);
        }

        public void setLifespan(War3Real val) {
            this.set(State.ART_LIFESPAN, val);
        }

        public War3Int getParticles() {
            return this.get(State.ART_PARTICLES);
        }

        public void setParticles(War3Int val) {
            this.set(State.ART_PARTICLES, val);
        }

        public War3Real getSpeed() {
            return this.get(State.ART_SPEED);
        }

        public War3Real getAccel() {
            return this.get(State.ART_SPEED_ACCEL);
        }

        public void setSpeed(War3Real speed, War3Real accel) {
            this.set(State.ART_SPEED, speed);
            this.set(State.ART_SPEED_ACCEL, accel);
        }

        public War3Real getVariance() {
            return this.get(State.ART_VARIANCE);
        }

        public void setVariance(War3Real val) {
            this.set(State.ART_VARIANCE, val);
        }

        public War3Real getTexC() {
            return this.get(State.ART_TEX_C);
        }

        public War3Real getTexR() {
            return this.get(State.ART_TEX_R);
        }

        public void setTexOffsets(War3Real texC, War3Real texR) {
            this.set(State.ART_TEX_C, texC);
            this.set(State.ART_TEX_R, texR);
        }

        public War3Bool getHead() {
            return this.get(State.ART_USE_HEAD);
        }

        public void setHead(War3Bool val) {
            this.set(State.ART_USE_HEAD, val);
        }

        public War3Bool getTail() {
            return this.get(State.ART_USE_TAIL);
        }

        public War3Real getTailLen() {
            return this.get(State.ART_TAIL_LEN);
        }

        public void setTail(War3Bool val, War3Real len) {
            this.set(State.ART_USE_TAIL, val);
            this.set(State.ART_TAIL_LEN, len);
        }

        public War3Real getLatitude() {
            return this.get(State.ART_LATITUDE);
        }

        public void setLatitude(War3Real val) {
            this.set(State.ART_LATITUDE, val);
        }

        public War3Real getLongitude() {
            return this.get(State.ART_LONGITUDE);
        }

        public void setLongitude(War3Real val) {
            this.set(State.ART_LONGITUDE, val);
        }

        public War3Real getMidTime() {
            return this.get(State.ART_MID_TIME);
        }

        public void setMidTime(War3Real val) {
            this.set(State.ART_MID_TIME, val);
        }

        public Color getColorStart() {
            return Color.fromBGRA255(this.get(State.ART_START_BLUE).toInt(), this.get(State.ART_START_GREEN).toInt(), this.get(State.ART_START_RED).toInt(), this.get(State.ART_START_ALPHA).toInt());
        }

        public void setColorStart(Color val) {
            this.set(State.ART_START_RED, War3Int.valueOf(val.getRed255()));
            this.set(State.ART_START_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_START_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_START_ALPHA, War3Int.valueOf(val.getAlpha255()));
        }

        public Color getColorMid() {
            return Color.fromBGRA255(this.get(State.ART_MID_BLUE).toInt(), this.get(State.ART_MID_GREEN).toInt(), this.get(State.ART_MID_RED).toInt(), this.get(State.ART_MID_ALPHA).toInt());
        }

        public void setColorMid(Color val) {
            this.set(State.ART_MID_RED, War3Int.valueOf(val.getRed255()));
            this.set(State.ART_MID_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_MID_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_MID_ALPHA, War3Int.valueOf(val.getAlpha255()));
        }

        public Color getColorEnd() {
            return Color.fromBGRA255(this.get(State.ART_END_BLUE).toInt(), this.get(State.ART_END_GREEN).toInt(), this.get(State.ART_END_RED).toInt(), this.get(State.ART_END_ALPHA).toInt());
        }

        public void setColorEnd(Color val) {
            this.set(State.ART_END_RED, War3Int.valueOf(val.getRed255()));
            this.set(State.ART_END_GREEN, War3Int.valueOf(val.getGreen255()));
            this.set(State.ART_END_BLUE, War3Int.valueOf(val.getBlue255()));
            this.set(State.ART_END_ALPHA, War3Int.valueOf(val.getAlpha255()));
        }

        public War3Real getScaleStart() {
            return this.get(State.ART_START_SCALE);
        }

        public War3Real getScaleMid() {
            return this.get(State.ART_MID_SCALE);
        }

        public War3Real getScaleEnd() {
            return this.get(State.ART_END_SCALE);
        }

        public void setScale(War3Real valStart, War3Real valMid, War3Real valEnd) {
            this.set(State.ART_START_SCALE, valStart);
            this.set(State.ART_MID_SCALE, valMid);
            this.set(State.ART_END_SCALE, valEnd);
        }

        public War3Real getHUVStart() {
            return this.get(State.ART_START_UV_H);
        }

        public War3Real getHUVMid() {
            return this.get(State.ART_MID_UV_H);
        }

        public War3Real getHUVEnd() {
            return this.get(State.ART_END_UV_H);
        }

        public void setHUV(War3Real valStart, War3Real valMid, War3Real valEnd) {
            this.set(State.ART_START_UV_H, valStart);
            this.set(State.ART_MID_UV_H, valMid);
            this.set(State.ART_END_UV_H, valEnd);
        }

        public War3Real getTUVStart() {
            return this.get(State.ART_START_UV_T);
        }

        public War3Real getTUVMid() {
            return this.get(State.ART_MID_UV_T);
        }

        public War3Real getTUVEnd() {
            return this.get(State.ART_END_UV_T);
        }

        public void setTUV(War3Real valStart, War3Real valMid, War3Real valEnd) {
            this.set(State.ART_START_UV_T, valStart);
            this.set(State.ART_MID_UV_T, valMid);
            this.set(State.ART_END_UV_T, valEnd);
        }

        public SoundLabel getSound() {
            return this.get(State.SOUND_AMBIENT);
        }

        public void setSound(SoundLabel val) {
            this.set(State.SOUND_AMBIENT, val);
        }

        public <T extends DataType> T get(State<T> state) {
            try {
                return state.tryCastVal(super.get(state));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        public <T extends DataType> void remove(State<T> state) {
            super.set(state, null);
        }

        @Override
        public void reduce() {
            if (this.get(State.SOUND_AMBIENT) != null && this.get(State.SOUND_AMBIENT).equals("-")) {
                this.remove(State.SOUND_AMBIENT);
            }
        }

        private void read(SLK.Obj<? extends ObjId> otherObj) {
            for (State state : State.values(State.class)) {
                Object field = state.getFieldId();
                try {
                    this.set((FieldId)field, (DataType)state.tryCastVal(otherObj.get((FieldId)field)));
                }
                catch (DataTypeInfo.CastException castException) {}
            }
        }

        public Obj(SLK.Obj<? extends ObjId> otherObj) {
            super(WeatherId.valueOf(otherObj.getId()));
            this.read(otherObj);
            this.reduce();
        }

        public Obj(WeatherId id) {
            super(id);
            for (State state : State.values(State.class)) {
                this.set((SLKState)state, (DataType)state.getDefVal());
            }
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<WeatherId> OBJ_ID = new State<WeatherId>("effectID", WeatherId.class);
        public static final State<AlphaMode> ART_ALPHA_MODE = new State<AlphaMode>("alphaMode", AlphaMode.class);
        public static final State<War3Real> ART_ANGLE_X = new State<War3Real>("angx", War3Real.class, War3Real.valueOf(-50.0f));
        public static final State<War3Real> ART_ANGLE_Y = new State<War3Real>("angy", War3Real.class, War3Real.valueOf(50.0f));
        public static final State<War3Real> ART_EMISSION_RATE = new State<War3Real>("emrate", War3Real.class, War3Real.valueOf(10.0f));
        public static final State<War3Int> ART_END_ALPHA = new State<War3Int>("alphaEnd", War3Int.class, War3Int.valueOf(0));
        public static final State<War3Int> ART_END_BLUE = new State<War3Int>("blueEnd", War3Int.class, War3Int.valueOf(0));
        public static final State<War3Int> ART_END_GREEN = new State<War3Int>("greenEnd", War3Int.class, War3Int.valueOf(0));
        public static final State<War3Int> ART_END_RED = new State<War3Int>("redEnd", War3Int.class, War3Int.valueOf(0));
        public static final State<War3Real> ART_END_SCALE = new State<War3Real>("scaleEnd", War3Real.class, War3Real.valueOf(100.0f));
        public static final State<War3Real> ART_END_UV_H = new State<War3Real>("hUVEnd", War3Real.class, War3Real.valueOf(0.0f));
        public static final State<War3Real> ART_END_UV_T = new State<War3Real>("tUVEnd", War3Real.class, War3Real.valueOf(0.0f));
        public static final State<War3Real> ART_HEIGHT = new State<War3Real>("height", War3Real.class, War3Real.valueOf(100.0f));
        public static final State<War3Real> ART_LATITUDE = new State<War3Real>("lati", War3Real.class, War3Real.valueOf(2.5f));
        public static final State<War3Real> ART_LIFESPAN = new State<War3Real>("lifespan", War3Real.class, War3Real.valueOf(5.0f));
        public static final State<War3Real> ART_LONGITUDE = new State<War3Real>("long", War3Real.class, War3Real.valueOf(180.0f));
        public static final State<War3Int> ART_MID_ALPHA = new State<War3Int>("alphaMid", War3Int.class, War3Int.valueOf(127));
        public static final State<War3Int> ART_MID_BLUE = new State<War3Int>("blueMid", War3Int.class, War3Int.valueOf(127));
        public static final State<War3Int> ART_MID_GREEN = new State<War3Int>("greenMid", War3Int.class, War3Int.valueOf(127));
        public static final State<War3Int> ART_MID_RED = new State<War3Int>("redMid", War3Int.class, War3Int.valueOf(127));
        public static final State<War3Real> ART_MID_SCALE = new State<War3Real>("scaleMid", War3Real.class, War3Real.valueOf(100.0f));
        public static final State<War3Real> ART_MID_TIME = new State<War3Real>("midTime", War3Real.class, War3Real.valueOf(0.5f));
        public static final State<War3Real> ART_MID_UV_H = new State<War3Real>("hUVMid", War3Real.class, War3Real.valueOf(0.0f));
        public static final State<War3Real> ART_MID_UV_T = new State<War3Real>("tUVMid", War3Real.class, War3Real.valueOf(0.0f));
        public static final State<War3Int> ART_PARTICLES = new State<War3Int>("particles", War3Int.class, War3Int.valueOf(1000));
        public static final State<War3Real> ART_SPEED = new State<War3Real>("veloc", War3Real.class, War3Real.valueOf(-100.0f));
        public static final State<War3Real> ART_SPEED_ACCEL = new State<War3Real>("accel", War3Real.class, War3Real.valueOf(0.0f));
        public static final State<War3Int> ART_START_ALPHA = new State<War3Int>("alphaStart", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_START_BLUE = new State<War3Int>("blueStart", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_START_GREEN = new State<War3Int>("greenStart", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Int> ART_START_RED = new State<War3Int>("redStart", War3Int.class, War3Int.valueOf(255));
        public static final State<War3Real> ART_START_SCALE = new State<War3Real>("scaleStart", War3Real.class, War3Real.valueOf(100.0f));
        public static final State<War3Real> ART_START_UV_H = new State<War3Real>("hUVStart", War3Real.class, War3Real.valueOf(0.0f));
        public static final State<War3Real> ART_START_UV_T = new State<War3Real>("tUVStart", War3Real.class, War3Real.valueOf(0.0f));
        public static final State<War3Real> ART_TAIL_LEN = new State<War3Real>("tailLen", War3Real.class, War3Real.valueOf(1.0f));
        public static final State<War3Real> ART_TEX_C = new State<War3Real>("texc", War3Real.class, War3Real.valueOf(10.0f));
        public static final State<War3String> ART_TEX_DIR = new State<War3String>("Dir", War3String.class);
        public static final State<War3String> ART_TEX_FILE = new State<War3String>("file", War3String.class);
        public static final State<War3Real> ART_TEX_R = new State<War3Real>("texr", War3Real.class, War3Real.valueOf(10.0f));
        public static final State<War3Bool> ART_USE_FOG = new State<War3Bool>("useFog", War3Bool.class, War3Bool.valueOf(true));
        public static final State<War3Bool> ART_USE_HEAD = new State<War3Bool>("head", War3Bool.class, War3Bool.valueOf(true));
        public static final State<War3Bool> ART_USE_TAIL = new State<War3Bool>("tail", War3Bool.class, War3Bool.valueOf(true));
        public static final State<War3Real> ART_VARIANCE = new State<War3Real>("var", War3Real.class, War3Real.valueOf(0.05f));
        public static final State<War3Int> EDITOR_VERSION = new State<War3Int>("version", War3Int.class, War3Int.valueOf(0));
        public static final State<SoundLabel> SOUND_AMBIENT = new State<SoundLabel>("AmbientSound", SoundLabel.class);

        public State(String idString, DataTypeInfo typeInfo, T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(String idString, DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(String idString, Class<T> type) {
            super(idString, type);
        }

        public State(String idString, Class<T> type, T defVal) {
            super(idString, type, defVal);
        }
    }
}

