/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation;

import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprMemberVar;
import de.peeeq.wurstscript.ast.LExpr;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.LoopStatement;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.attributes.names.NameLink;
import java.util.Collection;
import java.util.HashSet;

public class ValidateLocalUsage {
    public static void checkLocalsUsage(Collection<CompilationUnit> toCheck) {
        for (CompilationUnit cu : toCheck) {
            for (WPackage p : cu.getPackages()) {
                ValidateLocalUsage.checkLocalsUsage(p);
            }
        }
    }

    private static void checkLocalsUsage(WPackage p) {
        final HashSet locals = new HashSet();
        p.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LocalVarDef varDef) {
                super.visit(varDef);
                if (!(varDef.attrIsConstant() || varDef.getParent() instanceof LoopStatement || varDef.getInitialExpr() instanceof ExprClosure)) {
                    locals.add(varDef);
                }
            }
        });
        p.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(StmtSet set) {
                super.visit(set);
                LExpr updatedExpr = set.getUpdatedExpr();
                if (updatedExpr != null) {
                    NameLink nameLink = updatedExpr.attrNameLink();
                    if (nameLink != null) {
                        locals.remove(nameLink.getDef());
                    }
                    if (updatedExpr instanceof ExprMemberVar) {
                        this.checkLeftExpr((ExprMemberVar)updatedExpr);
                    }
                }
            }

            private void checkLeftExpr(ExprMemberVar updatedExpr) {
                if (updatedExpr.getLeft() != null) {
                    if (updatedExpr.getLeft() instanceof ExprMemberVar) {
                        this.checkLeftExpr((ExprMemberVar)updatedExpr.getLeft());
                    } else {
                        locals.remove(updatedExpr.getLeft().tryGetNameDef());
                    }
                }
            }
        });
        locals.forEach(local -> local.addWarning("Constant local variables should be defined using 'let'."));
    }
}

