/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class IntRange
implements Iterable<Integer> {
    final int start;
    final int end;

    public IntRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return this.start + "..<" + this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int i;
            {
                this.i = IntRange.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.i < IntRange.this.end;
            }

            @Override
            public Integer next() {
                return this.i++;
            }

            @Override
            public void remove() {
                throw new Error("Ranges are immutable");
            }
        };
    }

    public static List<IntRange> createFromIntList(List<Integer> list) {
        ArrayList l = Lists.newArrayList(list);
        Collections.sort(l);
        ArrayList result = Lists.newArrayList();
        boolean start = true;
        int min = 0;
        int max = 0;
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (start) {
                min = i;
                max = i;
                start = false;
                continue;
            }
            if (i == max + 1) {
                max = i;
                continue;
            }
            result.add(new IntRange(min, max));
            min = i;
            max = i;
        }
        if (!start) {
            result.add(new IntRange(min, max));
        }
        return result;
    }
}

