/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.port.War3MPQs;
import systems.crigges.jmpq3.JMpqEditor;
import systems.crigges.jmpq3.JMpqException;
import systems.crigges.jmpq3.MPQOpenOption;

public class JMpqPort
extends MpqPort {
    private static final File workDir = new File(Orient.getExecDir(), Orient.getExecPath().getName() + "_work");
    private static final File classWorkDir = new File(workDir, Orient.localClassPath().toString());
    private static final File tempDir = new File(classWorkDir, "temp");
    private static final File exportDir = new File(tempDir, "exported");

    public static String enquote(@Nonnull String s) {
        return "\"" + s + "\"";
    }

    @Override
    @Nonnull
    public List<File> listFiles(@Nonnull File mpqFile) throws IOException {
        ArrayList<File> arrayList;
        JMpqEditor jmpq = new JMpqEditor(mpqFile, new MPQOpenOption[]{MPQOpenOption.READ_ONLY});
        try {
            ArrayList<File> ret = new ArrayList<File>();
            for (String fileS : jmpq.getFileNames()) {
                ret.add(new File(fileS));
            }
            arrayList = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jmpq.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JMpqException e) {
                throw new IOException(e.getMessage());
            }
        }
        jmpq.close();
        return arrayList;
    }

    @Override
    public MpqPort.In createIn() {
        return new In();
    }

    @Override
    public MpqPort.Out createOut() {
        return new Out();
    }

    @Nonnull
    public static Vector<File> getWc3Mpqs(@Nonnull File wc3dir) {
        Vector<File> files = new Vector<File>();
        files.add(new File(wc3dir, War3MPQs.WAR3PATCH.toString()));
        files.add(new File(wc3dir, War3MPQs.WAR3X.toString()));
        files.add(new File(wc3dir, War3MPQs.WAR3.toString()));
        return files.stream().filter(File::exists).collect(Collectors.toCollection(Vector::new));
    }

    public static void importFile(@Nonnull Vector<File> mpqFiles, @Nonnull File outFile, @Nonnull File inFile) throws IOException {
        In port = new In();
        port.add(outFile, inFile);
        port.commit(mpqFiles);
    }

    public static void importFile(@Nonnull File mpqFile, @Nonnull File outFile, @Nonnull File inFile) throws IOException {
        Vector<File> mpqFiles = new Vector<File>();
        mpqFiles.add(mpqFile);
        JMpqPort.importFile(mpqFiles, outFile, inFile);
    }

    public static void extractFile(@Nonnull Vector<File> mpqFiles, @Nonnull File inFile, @Nonnull File outFile, boolean outFileIsDir) throws Exception {
        Out port = new Out();
        port.add(inFile, outFile, outFileIsDir);
        port.commit(mpqFiles);
    }

    public static void extractFile(@Nonnull File mpqFile, @Nonnull File inFile, @Nonnull File outFile, boolean outFileIsDir) throws Exception {
        Vector<File> mpqFiles = new Vector<File>();
        mpqFiles.add(mpqFile);
        JMpqPort.extractFile(mpqFiles, outFile, inFile, outFileIsDir);
    }

    @Override
    @Nonnull
    public MpqPort.Out.Result getGameFiles(File ... files) throws IOException, NotFoundException {
        Out portOut = new Out();
        for (File file : files) {
            portOut.add(file);
        }
        return ((MpqPort.Out)portOut).commit(MpqPort.getWar3Mpqs());
    }

    public static class Out
    extends MpqPort.Out {
        @Override
        @Nonnull
        public MpqPort.Out.Result commit(@Nonnull Vector<File> mpqFiles) throws IOException {
            Orient.removeDir(exportDir);
            Orient.createDir(exportDir);
            Vector<MpqPort.Out.FileExport> volExports = (Vector<MpqPort.Out.FileExport>)this.getFiles().clone();
            MpqPort.Out.Result result = new MpqPort.Out.Result();
            for (int c = 0; c < mpqFiles.size() && volExports.size() > 0; ++c) {
                OutputStream outStream;
                InputStream inStream;
                MpqPort.Out.DummyOutputStream dummyStream;
                int len;
                byte[] buf;
                MpqPort.Out.FileExport resultFileExport;
                File inFile;
                File outFile;
                Vector<MpqPort.Out.FileExport> failedExports;
                File mpqFile = mpqFiles.get(c);
                if (mpqFile instanceof MpqPort.ResourceFile) {
                    failedExports = new Vector<MpqPort.Out.FileExport>();
                    for (MpqPort.Out.FileExport fileExport : volExports) {
                        outFile = fileExport.getOutFile();
                        try {
                            inFile = fileExport.getInFile();
                            inFile = new File(mpqFile, inFile.toString());
                            resultFileExport = null;
                            if (outFile != null) {
                                if (fileExport.getOutDir() != null) {
                                    fileExport.getOutDir().mkdirs();
                                }
                                InputStream inStream2 = this.getClass().getResourceAsStream(inFile.getName());
                                try {
                                    if (inStream2 == null) {
                                        throw new FileNotFoundException();
                                    }
                                    FileOutputStream outStream2 = Orient.createFileOutputStream(outFile);
                                    try {
                                        buf = new byte[8192];
                                        len = 0;
                                        while ((len = inStream2.read(buf, 0, buf.length)) > 0) {
                                            ((OutputStream)outStream2).write(buf, 0, len);
                                        }
                                        resultFileExport = new MpqPort.Out.FileExport(inFile, outFile, false);
                                        result.addExport(mpqFile, resultFileExport);
                                        continue;
                                    }
                                    finally {
                                        if (outStream2 != null) {
                                            ((OutputStream)outStream2).close();
                                        }
                                        continue;
                                    }
                                }
                                finally {
                                    if (inStream2 == null) continue;
                                    inStream2.close();
                                    continue;
                                }
                            }
                            dummyStream = new MpqPort.Out.DummyOutputStream();
                            inStream = this.getClass().getClassLoader().getResourceAsStream(inFile.getName());
                            if (inStream == null) {
                                throw new FileNotFoundException();
                            }
                            buf = new byte[8192];
                            len = 0;
                            while ((len = inStream.read(buf, 0, buf.length)) > 0) {
                                dummyStream.write(buf, 0, len);
                            }
                            inStream.close();
                            outStream = fileExport.getOutStream();
                            if (outStream != null) {
                                dummyStream.close(outStream);
                            } else {
                                dummyStream.close();
                            }
                            resultFileExport = new MpqPort.Out.FileExport(inFile, outStream);
                            result.addExport(mpqFile, resultFileExport, dummyStream.getBytes());
                        }
                        catch (IOException e) {
                            failedExports.add(fileExport);
                        }
                    }
                    volExports = failedExports;
                    continue;
                }
                if (mpqFile.isDirectory()) {
                    failedExports = new Vector();
                    for (MpqPort.Out.FileExport fileExport : volExports) {
                        outFile = fileExport.getOutFile();
                        try {
                            inFile = new File(mpqFile, fileExport.getInFile().toString());
                            resultFileExport = null;
                            if (outFile != null) {
                                if (fileExport.getOutDir() != null) {
                                    fileExport.getOutDir().mkdirs();
                                }
                                Orient.copyFile(inFile, outFile);
                                resultFileExport = new MpqPort.Out.FileExport(inFile, outFile, false);
                                result.addExport(mpqFile, resultFileExport);
                                continue;
                            }
                            dummyStream = new MpqPort.Out.DummyOutputStream();
                            inStream = new FileInputStream(inFile);
                            buf = new byte[8192];
                            len = 0;
                            while ((len = ((FileInputStream)inStream).read(buf, 0, buf.length)) > 0) {
                                dummyStream.write(buf, 0, len);
                            }
                            ((FileInputStream)inStream).close();
                            outStream = fileExport.getOutStream();
                            if (outStream != null) {
                                dummyStream.close(outStream);
                            } else {
                                dummyStream.close();
                            }
                            resultFileExport = new MpqPort.Out.FileExport(inFile, outStream);
                            result.addExport(mpqFile, resultFileExport, dummyStream.getBytes());
                        }
                        catch (IOException e) {
                            failedExports.add(fileExport);
                        }
                    }
                    volExports = failedExports;
                    continue;
                }
                if (Orient.fileIsLocked(mpqFile)) {
                    File tempFile = new File(tempDir, Orient.getFileName(mpqFile));
                    Orient.copyFileIfNewer(mpqFile, tempFile);
                    mpqFile = tempFile;
                }
                try (JMpqEditor jmpq = new JMpqEditor(mpqFile, new MPQOpenOption[]{MPQOpenOption.READ_ONLY});){
                    Vector<MpqPort.Out.FileExport> failedExports2 = new Vector<MpqPort.Out.FileExport>();
                    for (MpqPort.Out.FileExport fileExport : volExports) {
                        File outFile2 = fileExport.getOutFile();
                        try {
                            File inFile2 = fileExport.getInFile();
                            MpqPort.Out.FileExport resultFileExport2 = null;
                            if (outFile2 != null) {
                                if (fileExport.getOutDir() != null) {
                                    fileExport.getOutDir().mkdirs();
                                }
                                jmpq.extractFile(inFile2.toString(), outFile2);
                                resultFileExport2 = new MpqPort.Out.FileExport(inFile2, outFile2, false);
                                result.addExport(mpqFile, resultFileExport2);
                            } else {
                                MpqPort.Out.DummyOutputStream dummyStream2 = new MpqPort.Out.DummyOutputStream();
                                jmpq.extractFile(inFile2.toString(), (OutputStream)dummyStream2);
                                OutputStream outStream3 = fileExport.getOutStream();
                                if (outStream3 != null) {
                                    dummyStream2.close(outStream3);
                                } else {
                                    dummyStream2.close();
                                }
                                resultFileExport2 = new MpqPort.Out.FileExport(inFile2, outStream3);
                                result.addExport(mpqFile, resultFileExport2, dummyStream2.getBytes());
                            }
                            volExports = failedExports2;
                        }
                        catch (JMpqException e) {
                            failedExports2.add(fileExport);
                        }
                    }
                    continue;
                }
            }
            return result;
        }
    }

    public static class In
    extends MpqPort.In {
        private void commitJ(@Nonnull Vector<File> mpqFiles) throws IOException {
            for (File mpqFile : mpqFiles) {
                try (JMpqEditor jmpq = new JMpqEditor(mpqFile, new MPQOpenOption[]{MPQOpenOption.FORCE_V0});){
                    for (MpqPort.In.FileImport fileImport : this.getFiles()) {
                        if (fileImport.getOutFile() != null) {
                            jmpq.insertFile(fileImport.getInFile().toString(), fileImport.getOutFile(), false);
                            continue;
                        }
                        jmpq.deleteFile(fileImport.getInFile().toString());
                    }
                }
            }
        }

        @Override
        public void commit(@Nonnull Vector<File> mpqFiles) throws MpqPort.PortException {
            try {
                this.commitJ(mpqFiles);
            }
            catch (IOException e) {
                throw new MpqPort.PortException(e);
            }
        }
    }
}

