/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Bounds;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DF;
import net.moonlightflower.wc3libs.dataTypes.app.Coords2DI;
import net.moonlightflower.wc3libs.misc.Boundable;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.Printable;
import net.moonlightflower.wc3libs.misc.Printer;
import net.moonlightflower.wc3libs.misc.Raster;
import net.moonlightflower.wc3libs.misc.Size;

public class W3E
extends Raster<Tile>
implements Boundable {
    public static final File GAME_PATH = new File("war3map.w3e");
    public final Id START_TOKEN = Id.valueOf("W3E!");
    public static final int CELL_SIZE = 128;
    private char _tileset;
    private int _customTilesetFlag = 0;
    private final Map<Integer, Id> _groundTiles = new LinkedHashMap<Integer, Id>();
    private final Map<Integer, Id> _cliffTiles = new LinkedHashMap<Integer, Id>();

    @Override
    public int getCellSize() {
        return 128;
    }

    @Override
    public void setSize(int cellsCount) {
        this._cells = new Tile[cellsCount];
    }

    @Override
    public Tile mergeCellVal(@Nonnull Tile oldVal, @Nonnull Tile other) {
        return other;
    }

    public char getTileset() {
        return this._tileset;
    }

    public int getCustomTilesetUsedFlag() {
        return this._customTilesetFlag;
    }

    public void setCustomTilesetFlag(int val) {
        this._customTilesetFlag = val;
    }

    public void setTileset(char val) {
        this._tileset = val;
    }

    public Id getGroundTile(int index) {
        return this._groundTiles.get(index);
    }

    public void setGroundTile(int index, Id val) {
        this._groundTiles.put(index, val);
    }

    public Id getCliffTile(int index) {
        return this._cliffTiles.get(index);
    }

    public void setCliffTile(int index, Id val) {
        this._cliffTiles.put(index, val);
    }

    public void write(@Nonnull Writer writer) throws BinStream.StreamException {
        writer.exec();
    }

    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(new Writer(stream));
    }

    public W3E read(@Nonnull Reader reader) throws IOException {
        return reader.exec(this);
    }

    private W3E read(@Nonnull Wc3BinInputStream stream) throws IOException {
        return this.read(new Reader(stream));
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    @Override
    @Nonnull
    public W3E clone() {
        W3E other = this.getBounds() == null ? new W3E(new Bounds(0, 0, 0, 0)) : new W3E(this.getBounds());
        other.mergeCells(this);
        return other;
    }

    public W3E(@Nonnull Bounds bounds) {
        super(bounds);
        this.setBounds(bounds, false, false);
    }

    public W3E(@Nonnull Reader reader) throws IOException {
        super(new Bounds(0, 0, 0, 0));
        this.read(reader);
    }

    public W3E(@Nonnull Wc3BinInputStream stream) throws IOException {
        this(new Reader(stream));
    }

    public W3E(@Nonnull File file) throws IOException {
        super(new Bounds(0, 0, 0, 0));
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(new Reader(inStream));
        inStream.close();
    }

    public static class Reader
    extends net.moonlightflower.wc3libs.bin.Reader<EncodingFormat> {
        private W3E _w3e;

        public Reader(@Nonnull Wc3BinInputStream stream) {
            super(stream);
        }

        @Override
        public EncodingFormat getAutoFormat() {
            return EncodingFormat.AUTO;
        }

        @Nonnull
        public W3E exec() throws IOException {
            return this.exec(new W3E(new Bounds(0, 0, 0, 0)));
        }

        private W3E exec(@Nonnull W3E w3e) throws IOException {
            this._w3e = w3e;
            this.read((EncodingFormat)this.getFormat());
            return this._w3e;
        }

        @Nonnull
        private W3E read(@Nonnull EncodingFormat format) throws IOException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case AUTO: {
                    return this.read_auto();
                }
                case W3E_0xB: {
                    return this.read_0xB();
                }
            }
            throw new Format.InvalidFormatException(format);
        }

        @Nonnull
        private W3E read_0xB() throws BinStream.StreamException {
            Wc3BinInputStream stream = this.getStream();
            Id startToken = stream.readId();
            int version = stream.readInt32("version");
            stream.checkFormatVersion(EncodingFormat.W3E_0xB.getVersion(), version);
            this._w3e.setTileset(stream.readChar("tileset").charValue());
            this._w3e.setCustomTilesetFlag(stream.readInt32("customTilesetFlag"));
            int groundTilesUsedCount = stream.readInt32("groundTilesUsedCount");
            for (int i = 0; i < groundTilesUsedCount; ++i) {
                this._w3e.setGroundTile(i, stream.readId("groundTilesUsed" + i));
            }
            int cliffTilesUsedCount = stream.readInt32("cliffTileUsedCount");
            for (int i = 0; i < cliffTilesUsedCount; ++i) {
                this._w3e.setCliffTile(i, stream.readId("cliffTilesUsed" + i));
            }
            this._w3e.setBounds(new Bounds(new Size(stream.readInt32("width"), stream.readInt32("height")), new Coords2DF(stream.readFloat32("x").floatValue(), stream.readFloat32("y").floatValue())), false, false);
            int width = this._w3e.getWidth();
            int height = this._w3e.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this._w3e.set(new Coords2DI(x, y), new Tile(new Tile.Reader(stream, EncodingFormat.W3E_0xB)));
                }
            }
            return this._w3e;
        }

        @Nonnull
        private W3E read_auto() throws IOException {
            Wc3BinInputStream stream = this.getStream();
            Id startToken = stream.readId();
            int version = stream.readInt32();
            stream.rewind();
            EncodingFormat format = this.getStream().getFormat(EncodingFormat.class, version);
            if (format == null) {
                throw new Format.InvalidFormatException(version);
            }
            return this.read(format);
        }
    }

    public class Writer
    extends net.moonlightflower.wc3libs.bin.Writer<EncodingFormat> {
        @Override
        public EncodingFormat getAutoFormat() {
            return EncodingFormat.AUTO;
        }

        private void write_0xB(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
            stream.writeId(W3E.this.START_TOKEN);
            stream.writeInt32(EncodingFormat.W3E_0xB.getVersion());
            stream.writeChar(W3E.this.getTileset());
            stream.writeInt32(W3E.this.getCustomTilesetUsedFlag());
            stream.writeInt32(W3E.this._groundTiles.size());
            for (Id groundTile : W3E.this._groundTiles.values()) {
                stream.writeId(groundTile);
            }
            stream.writeInt32(W3E.this._cliffTiles.size());
            for (Id cliffTile : W3E.this._cliffTiles.values()) {
                stream.writeId(cliffTile);
            }
            int width = W3E.this.getWidth();
            int height = W3E.this.getHeight();
            stream.writeInt32(width);
            stream.writeInt32(height);
            Coords2DF center = W3E.this.getCenter();
            stream.writeFloat32(center.getX());
            stream.writeFloat32(center.getY());
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    Tile tile = (Tile)W3E.this.get(new Coords2DI(x, y));
                    tile.write(new Tile.Writer(stream, EncodingFormat.W3E_0xB));
                }
            }
        }

        public void exec() throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)((EncodingFormat)this.getFormat()).toEnum())) {
                case AUTO: 
                case W3E_0xB: {
                    this.write_0xB(this.getStream());
                }
            }
        }

        public Writer(Wc3BinOutputStream stream) {
            super(stream);
        }
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, null);
        public static final EncodingFormat W3E_0xB = new EncodingFormat(Enum.W3E_0xB, (Integer)11);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, @Nullable Integer version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            W3E_0xB;

        }
    }

    public static class Tile
    implements Printable {
        public static final int GROUND_ZERO = 8192;
        public static final float WATER_ZERO = 89.6f;
        public static final int CLIFF_HEIGHT = 512;
        private short _groundHeight = 0;
        private short _waterLevel = 0;
        private int _boundary = 0;
        private int _boundary2;
        private int _water = 0;
        private int _blight = 0;
        private int _ramp = 0;
        private int _tex = 0;
        private int _cliffTex = 0;
        private int _cliffLayer = 0;
        private int _texDetails = 0;
        private int _cliff = 0;

        public float rawToFinalGroundHeight(float rawVal, int cliffLevel) {
            return (rawVal - 8192.0f + (float)((cliffLevel - 2) * 512)) / 4.0f;
        }

        public float finalGroundToRawHeight(float finalVal, int cliffLevel) {
            return finalVal * 4.0f - (float)((cliffLevel - 2) * 512) + 8192.0f;
        }

        public float rawToFinalWaterHeight(float rawVal) {
            return (rawVal - 8192.0f) / 4.0f - 89.6f;
        }

        public float finalWaterToRawHeight(float finalVal) {
            return (finalVal + 89.6f) * 4.0f + 8192.0f;
        }

        public short getGroundHeight() {
            return this._groundHeight;
        }

        public void setGroundHeight(short val) {
            this._groundHeight = val;
        }

        public short getWaterLevel() {
            return this._waterLevel;
        }

        public void setWaterLevel(short val) {
            this._waterLevel = val;
        }

        public int getBoundary() {
            return this._boundary;
        }

        public void setBoundary(int val) {
            this._boundary = val;
        }

        public int getBoundary2() {
            return this._boundary2;
        }

        public void setBoundary2(int val) {
            this._boundary2 = val;
        }

        public int getWater() {
            return this._water;
        }

        public void setWater(int val) {
            this._water = val;
        }

        public int getBlight() {
            return this._blight;
        }

        public void setBlight(int val) {
            this._blight = val;
        }

        public int getRamp() {
            return this._ramp;
        }

        public void setRamp(int val) {
            this._ramp = val;
        }

        public int getTex() {
            return this._tex;
        }

        public void setTex(int val) {
            this._tex = val;
        }

        public int getCliffTex() {
            return this._cliffTex;
        }

        public void setCliffTex(int val) {
            this._cliffTex = val;
        }

        public int getCliffLayer() {
            return this._cliffLayer;
        }

        public void setCliffLayer(int val) {
            this._cliffLayer = val;
        }

        public int getTexDetails() {
            return this._texDetails;
        }

        public void setTexDetails(int val) {
            this._texDetails = val;
        }

        public int getCliff() {
            return this._cliff;
        }

        public void setCliff(int val) {
            this._cliff = val;
        }

        @Override
        public void print(@Nonnull Printer printer) {
            printer.print(this.getBlight());
            printer.print(this.getBoundary());
        }

        private void write(@Nonnull Writer writer) throws BinStream.StreamException {
            writer.exec(this);
        }

        public Tile(@Nonnull Reader reader) throws BinStream.StreamException {
            reader.exec(this);
        }

        public Tile(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            new Reader(stream).exec();
        }

        public Tile() {
        }

        public static class Reader
        extends net.moonlightflower.wc3libs.bin.Reader<EncodingFormat> {
            private Tile _tile;

            public Reader(@Nonnull Wc3BinInputStream stream) {
                super(stream);
            }

            public Reader(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) {
                super(stream, format);
            }

            public Tile exec() throws BinStream.StreamException {
                return this.exec(new Tile());
            }

            private Tile exec(@Nonnull Tile tile) throws BinStream.StreamException {
                this._tile = tile;
                this.read();
                return this._tile;
            }

            private void read() throws BinStream.StreamException {
                this.read((EncodingFormat)this.getFormat());
            }

            private void read(@Nonnull EncodingFormat format) throws BinStream.StreamException {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case W3E_0xB: {
                        this.read_0xB();
                        break;
                    }
                    default: {
                        throw new Format.InvalidFormatException(format);
                    }
                }
            }

            private void read_0xB() throws BinStream.StreamException {
                Wc3BinInputStream stream = this.getStream();
                this._tile.setGroundHeight(stream.readInt16("groundHeight"));
                short waterLevel = stream.readInt16("waterLevelAndFlag");
                this._tile.setWaterLevel((short)(waterLevel & Short.MAX_VALUE));
                this._tile.setBoundary(waterLevel >> 15);
                short flags = stream.readUByte("flags");
                this._tile.setBoundary2(flags & 1);
                this._tile.setWater(flags >> 1 & 1);
                this._tile.setBlight(flags >> 2 & 1);
                this._tile.setRamp(flags >> 3 & 1);
                this._tile.setTex(flags >> 4);
                this._tile.setTexDetails(stream.readUByte("texDetails").shortValue());
                byte cliff = stream.readByte("cliffTexAndLayer");
                this._tile.setCliffTex(cliff >> 4 & 0xF);
                this._tile.setCliffLayer(cliff & 0xF);
            }

            @Override
            public EncodingFormat getAutoFormat() {
                return EncodingFormat.AUTO;
            }
        }

        public static class Writer
        extends net.moonlightflower.wc3libs.bin.Writer<EncodingFormat> {
            private Tile _tile;

            public Writer(@Nonnull Wc3BinOutputStream stream) {
                super(stream);
            }

            public Writer(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                super(stream, format);
            }

            @Override
            public EncodingFormat getAutoFormat() {
                return EncodingFormat.AUTO;
            }

            public void exec(@Nonnull Tile tile) throws BinStream.StreamException {
                this._tile = tile;
                this.write();
            }

            private void write() {
                switch ((EncodingFormat.Enum)((Object)((EncodingFormat)this.getFormat()).toEnum())) {
                    case AUTO: 
                    case W3E_0xB: {
                        this.write_0xB();
                    }
                }
            }

            private void write_0xB() {
                Wc3BinOutputStream stream = this.getStream();
                stream.writeInt16(this._tile.getGroundHeight());
                short waterLevel = this._tile.getWaterLevel();
                waterLevel = (short)(waterLevel | this._tile.getBoundary() << 15);
                stream.writeInt16(waterLevel);
                int flags = this._tile.getBoundary2();
                flags |= this._tile.getWater() << 1;
                flags |= this._tile.getBlight() << 2;
                flags |= this._tile.getRamp() << 3;
                stream.writeUByte(flags |= this._tile.getTex() << 4);
                stream.writeUByte(this._tile.getTexDetails());
                int cliff = this._tile.getCliffTex() << 4;
                int layer = Math.min(this._tile.getCliffLayer(), 14);
                stream.writeUByte(cliff |= layer);
            }
        }
    }
}

