/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imoptimizer;

import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImIntVal;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imoptimizer.OptimizerPass;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import java.util.ListIterator;

public class UselessFunctionCallsRemover
implements OptimizerPass {
    public int totalCallsRemoved = 0;
    private static final Set<String> functionsWithoutSideEffects = HashSet.of((Object[])new String[]{"AbilityId", "AbilityId2String", "Acos", "And", "Asin", "Atan", "Atan2", "ConvertAIDifficulty", "ConvertAllianceType", "ConvertAttackType", "ConvertBlendMode", "ConvertCameraField", "ConvertDamageType", "ConvertDialogEvent", "ConvertEffectType", "ConvertFGameState", "ConvertFogState", "ConvertGameDifficulty", "ConvertGameEvent", "ConvertGameSpeed", "ConvertGameType", "ConvertIGameState", "ConvertItemType", "ConvertLimitOp", "ConvertMapControl", "ConvertMapDensity", "ConvertMapFlag", "ConvertMapSetting", "ConvertMapVisibility", "ConvertPathingType", "ConvertPlacement", "ConvertPlayerColor", "ConvertPlayerEvent", "ConvertPlayerGameResult", "ConvertPlayerScore", "ConvertPlayerSlotState", "ConvertPlayerState", "ConvertPlayerUnitEvent", "ConvertRace", "ConvertRacePref", "ConvertRarityControl", "ConvertSoundType", "ConvertStartLocPrio", "ConvertTexMapFlags", "ConvertUnitEvent", "ConvertUnitState", "ConvertUnitType", "ConvertVersion", "ConvertVolumeGroup", "ConvertWeaponType", "ConvertWidgetEvent", "Cos", "Deg2Rad", "FirstOfGroup", "GetAbilityEffect", "GetAbilityEffectById", "GetAbilitySound", "GetAbilitySoundById", "GetAllyColorFilterState", "GetAttacker", "GetBuyingUnit", "GetCameraBoundMaxX", "GetCameraBoundMaxY", "GetCameraBoundMinX", "GetCameraBoundMinY", "GetCameraEyePositionLoc", "GetCameraEyePositionX", "GetCameraEyePositionY", "GetCameraEyePositionZ", "GetCameraField", "GetCameraMargin", "GetCameraTargetPositionLoc", "GetCameraTargetPositionX", "GetCameraTargetPositionY", "GetCameraTargetPositionZ", "GetCancelledStructure", "GetChangingUnit", "GetChangingUnitPrevOwner", "GetClickedButton", "GetClickedDialog", "GetConstructedStructure", "GetConstructingStructure", "GetCreatureDensity", "GetCreepCampFilterState", "GetCustomCampaignButtonVisible", "GetDecayingUnit", "GetDefaultDifficulty", "GetDestructableLife", "GetDestructableMaxLife", "GetDestructableName", "GetDestructableOccluderHeight", "GetDestructableTypeId", "GetDestructableX", "GetDestructableY", "GetDetectedUnit", "GetDyingUnit", "GetEnteringUnit", "GetEnumDestructable", "GetEnumItem", "GetEnumPlayer", "GetEnumUnit", "GetEventDamage", "GetEventDamageSource", "GetEventDetectingPlayer", "GetEventGameState", "GetEventPlayerChatString", "GetEventPlayerChatStringMatched", "GetEventPlayerState", "GetEventTargetUnit", "GetEventUnitState", "GetExpiredTimer", "GetFilterDestructable", "GetFilterItem", "GetFilterPlayer", "GetFilterUnit", "GetFloatGameState", "GetFoodMade", "GetFoodUsed", "GetGameDifficulty", "GetGamePlacement", "GetGameSpeed", "GetGameTypeSelected", "GetHandleId", "GetHeroAgi", "GetHeroInt", "GetHeroLevel", "GetHeroProperName", "GetHeroSkillPoints", "GetHeroStr", "GetHeroXP", "GetIntegerGameState", "GetIssuedOrderId", "GetItemCharges", "GetItemLevel", "GetItemName", "GetItemPlayer", "GetItemType", "GetItemTypeId", "GetItemUserData", "GetItemX", "GetItemY", "GetKillingUnit", "GetLearnedSkill", "GetLearnedSkillLevel", "GetLearningUnit", "GetLeavingUnit", "GetLevelingUnit", "GetLightningColorA", "GetLightningColorB", "GetLightningColorG", "GetLightningColorR", "GetLoadedUnit", "GetLocalizedHotkey", "GetLocalizedString", "GetLocationX", "GetLocationY", "GetLocationZ", "GetManipulatedItem", "GetManipulatingUnit", "GetObjectName", "GetOrderedUnit", "GetOrderPointLoc", "GetOrderPointX", "GetOrderPointY", "GetOrderTarget", "GetOrderTargetDestructable", "GetOrderTargetItem", "GetOrderTargetUnit", "GetOwningPlayer", "GetPlayerAlliance", "GetPlayerColor", "GetPlayerController", "GetPlayerHandicap", "GetPlayerHandicapXP", "GetPlayerId", "GetPlayerName", "GetPlayerRace", "GetPlayers", "GetPlayerScore", "GetPlayerSelectable", "GetPlayerSlotState", "GetPlayerStartLocation", "GetPlayerState", "GetPlayerStructureCount", "GetPlayerTaxRate", "GetPlayerTeam", "GetPlayerTechCount", "GetPlayerTechMaxAllowed", "GetPlayerTechResearched", "GetPlayerTypedUnitCount", "GetPlayerUnitCount", "GetRectCenterX", "GetRectCenterY", "GetRectMaxX", "GetRectMaxY", "GetRectMinX", "GetRectMinY", "GetRescuer", "GetResearched", "GetResearchingUnit", "GetResourceAmount", "GetResourceDensity", "GetRevivableUnit", "GetRevivingUnit", "GetSaveBasicFilename", "GetSelectedUnit", "GetSellingUnit", "GetSoldItem", "GetSoldUnit", "GetSoundDuration", "GetSoundFileDuration", "GetSoundIsLoading", "GetSoundIsPlaying", "GetSpellAbility", "GetSpellAbilityId", "GetSpellAbilityUnit", "GetSpellTargetDestructable", "GetSpellTargetItem", "GetSpellTargetLoc", "GetSpellTargetUnit", "GetSpellTargetX", "GetSpellTargetY", "GetStartLocationLoc", "GetStartLocationX", "GetStartLocationY", "GetStartLocPrio", "GetStartLocPrioSlot", "GetStoredBoolean", "GetStoredInteger", "GetStoredReal", "GetStoredString", "GetSummonedUnit", "GetSummoningUnit", "GetTeams", "GetTerrainCliffLevel", "GetTerrainType", "GetTerrainVariance", "GetTournamentFinishNowPlayer", "GetTournamentFinishNowRule", "GetTournamentFinishSoonTimeRemaining", "GetTournamentScore", "GetTrainedUnit", "GetTrainedUnitType", "GetTransportUnit", "GetTriggerDestructable", "GetTriggerEvalCount", "GetTriggerEventId", "GetTriggerExecCount", "GetTriggeringRegion", "GetTriggeringTrackable", "GetTriggeringTrigger", "GetTriggerPlayer", "GetTriggerUnit", "GetTriggerWidget", "GetUnitAbilityLevel", "GetUnitAcquireRange", "GetUnitCurrentOrder", "GetUnitDefaultAcquireRange", "GetUnitDefaultFlyHeight", "GetUnitDefaultMoveSpeed", "GetUnitDefaultPropWindow", "GetUnitDefaultTurnSpeed", "GetUnitFacing", "GetUnitFlyHeight", "GetUnitFoodMade", "GetUnitFoodUsed", "GetUnitLevel", "GetUnitLoc", "GetUnitMoveSpeed", "GetUnitName", "GetUnitPointValue", "GetUnitPointValueByType", "GetUnitPropWindow", "GetUnitRace", "GetUnitRallyDestructable", "GetUnitRallyPoint", "GetUnitRallyUnit", "GetUnitState", "GetUnitTurnSpeed", "GetUnitTypeId", "GetUnitUserData", "GetUnitX", "GetUnitY", "GetWidgetLife", "GetWidgetX", "GetWidgetY", "GetWinningPlayer", "GetWorldBounds", "HaveSavedBoolean", "HaveSavedHandle", "HaveSavedInteger", "HaveSavedReal", "HaveSavedString", "HaveStoredBoolean", "HaveStoredInteger", "HaveStoredReal", "HaveStoredString", "HaveStoredUnit", "I2R", "I2S", "IsCineFilterDisplayed", "IsDestructableInvulnerable", "IsFogEnabled", "IsFoggedToPlayer", "IsFogMaskEnabled", "IsGameTypeSupported", "IsHeroUnitId", "IsItemIdPawnable", "IsItemIdPowerup", "IsItemIdSellable", "IsItemInvulnerable", "IsItemOwned", "IsItemPawnable", "IsItemPowerup", "IsItemSellable", "IsItemVisible", "IsLeaderboardDisplayed", "IsLocationFoggedToPlayer", "IsLocationInRegion", "IsLocationMaskedToPlayer", "IsLocationVisibleToPlayer", "IsMapFlagSet", "IsMaskedToPlayer", "IsMultiboardDisplayed", "IsMultiboardMinimized", "IsNoDefeatCheat", "IsNoVictoryCheat", "IsPlayerAlly", "IsPlayerEnemy", "IsPlayerInForce", "IsPlayerObserver", "IsPlayerRacePrefSet", "IsPointBlighted", "IsPointInRegion", "IsQuestCompleted", "IsQuestDiscovered", "IsQuestEnabled", "IsQuestFailed", "IsQuestItemCompleted", "IsQuestRequired", "IsSuspendedXP", "IsTerrainPathable", "IsTimerDialogDisplayed", "IsTriggerEnabled", "IsTriggerWaitOnSleeps", "IsUnit", "IsUnitAlly", "IsUnitDetected", "IsUnitEnemy", "IsUnitFogged", "IsUnitHidden", "IsUnitIdType", "IsUnitIllusion", "IsUnitInForce", "IsUnitInGroup", "IsUnitInRange", "IsUnitInRangeLoc", "IsUnitInRangeXY", "IsUnitInRegion", "IsUnitInTransport", "IsUnitInvisible", "IsUnitLoaded", "IsUnitMasked", "IsUnitOwnedByPlayer", "IsUnitPaused", "IsUnitRace", "IsUnitSelected", "IsUnitType", "IsUnitVisible", "IsVisibleToPlayer", "LoadAbilityHandle", "LoadBoolean", "LoadBooleanExprHandle", "LoadButtonHandle", "LoadDefeatConditionHandle", "LoadDestructableHandle", "LoadDialogHandle", "LoadEffectHandle", "LoadFogModifierHandle", "LoadFogStateHandle", "LoadForceHandle", "LoadGroupHandle", "LoadHashtableHandle", "LoadImageHandle", "LoadInteger", "LoadItemHandle", "LoadItemPoolHandle", "LoadLeaderboardHandle", "LoadLightningHandle", "LoadLocationHandle", "LoadMultiboardHandle", "LoadMultiboardItemHandle", "LoadPlayerHandle", "LoadQuestHandle", "LoadQuestItemHandle", "LoadReal", "LoadRectHandle", "LoadRegionHandle", "LoadSoundHandle", "LoadStr", "LoadTextTagHandle", "LoadTimerDialogHandle", "LoadTimerHandle", "LoadTrackableHandle", "LoadTriggerActionHandle", "LoadTriggerConditionHandle", "LoadTriggerEventHandle", "LoadTriggerHandle", "LoadUbersplatHandle", "LoadUnitHandle", "LoadUnitPoolHandle", "LoadWidgetHandle", "Not", "Or", "OrderId", "OrderId2String", "Player", "Pow", "R2I", "R2S", "R2SW", "Rad2Deg", "S2I", "S2R", "Sin", "SquareRoot", "StringCase", "StringHash", "StringLength", "SubString", "Tan", "TimerGetElapsed", "TimerGetRemaining", "TimerGetTimeout", "VersionGet", "WaygateGetDestinationX", "WaygateGetDestinationY", "WaygateIsActive", "BlzGetTriggerPlayerMouseX", "BlzGetTriggerPlayerMouseY", "BlzGetTriggerPlayerMousePosition", "BlzGetTriggerPlayerMouseButton", "BlzGetAbilityTooltip", "BlzGetAbilityActivatedTooltip", "BlzGetAbilityExtendedTooltip", "BlzGetAbilityActivatedExtendedTooltip", "BlzGetAbilityResearchTooltip", "BlzGetAbilityResearchExtendedTooltip", "BlzGetAbilityIcon", "BlzGetAbilityActivatedIcon", "BlzGetAbilityPosX", "BlzGetAbilityPosY", "BlzGetAbilityActivatedPosX", "BlzGetAbilityActivatedPosY", "BlzGetUnitMaxHP", "BlzGetUnitMaxMana", "BlzGetItemDescription", "BlzGetItemTooltip", "BlzGetItemExtendedTooltip", "BlzGetItemIconPath", "BlzGetUnitBaseDamage", "BlzGetUnitDiceNumber", "BlzGetUnitDiceSides", "BlzGetUnitAttackCooldown", "BlzGetLocalSpecialEffectX", "BlzGetLocalSpecialEffectY", "BlzGetLocalSpecialEffectZ", "BlzGetAnimName", "BlzGetUnitArmor", "BlzIsUnitSelectable", "BlzIsUnitInvulnerable", "BlzGetUnitCollisionSize", "BlzGetAbilityManaCost", "BlzGetAbilityCooldown", "BlzGetUnitAbilityCooldown", "BlzGetUnitAbilityCooldownRemaining", "BlzGetUnitAbilityManaCost", "BlzGetLocalUnitZ", "BlzGetEventDamageTarget", "BlzGetEventAttackType", "BlzGetEventDamageType", "BlzGetEventWeaponType", "BlzGetEventIsAttack", "BlzGetUnitZ", "BlzIsSelectionEnabled", "BlzIsSelectionCircleEnabled", "BlzIsTargetIndicatorEnabled", "BlzGetOriginFrame", "BlzGetFrameByName", "BlzFrameGetName", "BlzFrameGetText", "BlzFrameGetTextSizeLimit", "BlzFrameGetEnable", "BlzFrameGetAlpha", "BlzFrameGetValue", "BlzFrameGetParent", "BlzFrameGetHeight", "BlzFrameGetWidth", "BlzGetTriggerFrame", "BlzGetTriggerFrameEvent", "BlzGetTriggerFrameValue", "BlzGetTriggerFrameText", "BlzGetTriggerSyncPrefix", "BlzGetTriggerPlayerKey", "BlzGetTriggerPlayerMetaKey", "BlzGetTriggerPlayerIsKeyDown", "BlzGetLocalClientWidth", "BlzGetLocalClientHeight", "BlzIsLocalClientActive", "BlzGetMouseFocusUnit", "BlzGetLocale", "BlzGetSpecialEffectScale", "BlzGetUnitAbility", "BlzGetUnitAbilityByIndex", "BlzBitOr", "BlzBitAnd", "BlzBitXor", "BlzGetAbilityBooleanField", "BlzGetAbilityIntegerField", "BlzGetAbilityRealField", "BlzGetAbilityStringField", "BlzGetAbilityBooleanLevelField", "BlzGetAbilityIntegerLevelField", "BlzGetAbilityRealLevelField", "BlzGetAbilityStringLevelField", "BlzGetAbilityBooleanLevelArrayField", "BlzGetAbilityIntegerLevelArrayField", "BlzGetAbilityRealLevelArrayField", "BlzGetAbilityStringLevelArrayField", "BlzGetItemAbilityByIndex", "BlzGetItemAbility", "BlzGetItemBooleanField", "BlzGetItemIntegerField", "BlzGetItemRealField", "BlzGetItemStringField", "BlzGetUnitBooleanField", "BlzGetUnitIntegerField", "BlzGetUnitRealField", "BlzGetUnitStringField", "BlzGetUnitWeaponBooleanField", "BlzGetUnitWeaponIntegerField", "BlzGetUnitWeaponRealField", "BlzGetUnitWeaponStringField", "BlzGetUnitSkin", "BlzGetItemSkin", "BlzGetPlayerTownHallCount"});
    private static final Set<String> pureFunctions = HashSet.of((Object[])new String[]{"AbilityId", "AbilityId2String", "Acos", "And", "Asin", "Atan", "Atan2", "ConvertAIDifficulty", "ConvertAllianceType", "ConvertAttackType", "ConvertBlendMode", "ConvertCameraField", "ConvertDamageType", "ConvertDialogEvent", "ConvertEffectType", "ConvertFGameState", "ConvertFogState", "ConvertGameDifficulty", "ConvertGameEvent", "ConvertGameSpeed", "ConvertGameType", "ConvertIGameState", "ConvertItemType", "ConvertLimitOp", "ConvertMapControl", "ConvertMapDensity", "ConvertMapFlag", "ConvertMapSetting", "ConvertMapVisibility", "ConvertPathingType", "ConvertPlacement", "ConvertPlayerColor", "ConvertPlayerEvent", "ConvertPlayerGameResult", "ConvertPlayerScore", "ConvertPlayerSlotState", "ConvertPlayerState", "ConvertPlayerUnitEvent", "ConvertRace", "ConvertRacePref", "ConvertRarityControl", "ConvertSoundType", "ConvertStartLocPrio", "ConvertTexMapFlags", "ConvertUnitEvent", "ConvertUnitState", "ConvertUnitType", "ConvertVersion", "ConvertVolumeGroup", "ConvertWeaponType", "ConvertWidgetEvent", "Cos", "Deg2Rad", "GetAbilityEffect", "GetAbilityEffectById", "GetAbilitySound", "GetAbilitySoundById", "GetAllyColorFilterState", "GetPlayerColor", "GetPlayerController", "GetPlayerId", "GetPlayerRace", "GetPlayerSelectable", "GetPlayerStartLocation", "GetPlayerTeam", "GetSoundDuration", "GetSoundFileDuration", "GetStartLocationLoc", "GetStartLocationX", "GetStartLocationY", "GetStartLocPrio", "GetStartLocPrioSlot", "GetSummonedUnit", "GetSummoningUnit", "GetTeams", "GetUnitDefaultAcquireRange", "GetUnitDefaultFlyHeight", "GetUnitDefaultMoveSpeed", "GetUnitDefaultPropWindow", "GetUnitDefaultTurnSpeed", "GetUnitName", "GetWinningPlayer", "GetWorldBounds", "I2R", "I2S", "Not", "Or", "OrderId", "OrderId2String", "Player", "Pow", "R2I", "R2S", "R2SW", "Rad2Deg", "S2I", "S2R", "Sin", "SquareRoot", "StringCase", "StringHash", "StringLength", "SubString", "Tan", "VersionGet", "BlzBitOr", "BlzBitAnd", "BlzBitXor"});

    @Override
    public int optimize(ImTranslator trans) {
        this.totalCallsRemoved = 0;
        ImProg prog = trans.getImProg();
        for (ImFunction func : prog.getFunctions()) {
            this.optimizeFunc(func, trans);
        }
        return this.totalCallsRemoved;
    }

    @Override
    public String getName() {
        return "Useless function calls removed";
    }

    private void optimizeFunc(ImFunction func, ImTranslator trans) {
        this.optimizeStmts(func.getBody());
        func.flatten(trans);
    }

    private void optimizeStmts(ImStmts stmts) {
        ListIterator it = stmts.listIterator();
        while (it.hasNext()) {
            ImFunctionCall fc;
            ImStmt s = (ImStmt)it.next();
            if (s instanceof ImFunctionCall && this.isNativeWithoutSideEffect((fc = (ImFunctionCall)s).getFunc()) && !this.isWantedError(fc)) {
                ImStmts newStmts = JassIm.ImStmts(new ImStmt[0]);
                for (ImExpr arg : fc.getArguments()) {
                    arg.setParent(null);
                    newStmts.add(arg);
                }
                s = ImHelper.statementExprVoid(newStmts);
                it.set(s);
                ++this.totalCallsRemoved;
            }
            this.optimizeChildren(s);
        }
    }

    private boolean isWantedError(ImFunctionCall fc) {
        if (fc.getArguments().size() != 1) {
            return false;
        }
        return this.isDivisionByZero((ImExpr)fc.getArguments().get(0));
    }

    private boolean isDivisionByZero(ImExpr e) {
        ImExpr dividend;
        ImOperatorCall oc;
        if (e instanceof ImOperatorCall && (oc = (ImOperatorCall)e).getOp() == WurstOperator.DIV_INT && (dividend = (ImExpr)oc.getArguments().get(1)) instanceof ImIntVal) {
            ImIntVal v = (ImIntVal)dividend;
            return v.getValI() == 0;
        }
        return false;
    }

    private void optimizeChildren(Element e) {
        for (int i = 0; i < e.size(); ++i) {
            this.optimizeElement(e.get(i));
        }
    }

    private void optimizeElement(Element e) {
        if (e instanceof ImStmts) {
            ImStmts stmts = (ImStmts)e;
            this.optimizeStmts(stmts);
        } else {
            this.optimizeChildren(e);
        }
    }

    private boolean isNativeWithoutSideEffect(ImFunction func) {
        return func.isNative() && UselessFunctionCallsRemover.isFunctionWithoutSideEffect(func.getName());
    }

    public static boolean isFunctionWithoutSideEffect(String funcName) {
        return functionsWithoutSideEffects.contains((Object)funcName);
    }

    public static boolean isFunctionPure(String funcName) {
        return pureFunctions.contains((Object)funcName);
    }
}

