/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import config.WurstProjectConfig;
import config.WurstProjectConfigData;
import de.peeeq.wurstio.gui.WurstGuiImpl;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.WurstLanguageServer;
import de.peeeq.wurstio.languageserver.requests.MapRequest;
import de.peeeq.wurstio.languageserver.requests.RequestFailedException;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.Orient;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.lsp4j.MessageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunMap
extends MapRequest {
    @Nullable
    private File customTarget = null;

    public RunMap(WurstLanguageServer langServer, WFile workspaceRoot, Optional<String> wc3Path, Optional<File> map, List<String> compileArgs) {
        super(langServer, map, compileArgs, workspaceRoot, wc3Path);
        this.safeCompilation = MapRequest.SafetyLevel.QuickAndDirty;
    }

    @Override
    public Object execute(ModelManager modelManager) throws IOException {
        WLogger.info("Execute RunMap, \nwc3Path =" + this.wc3Path + ",\n map = " + this.map + ",\n compileArgs = " + this.compileArgs + ",\n workspaceRoot = " + this.workspaceRoot + ",\n runArgs = " + this.compileArgs);
        if (modelManager.hasErrors()) {
            throw new RequestFailedException(MessageType.Error, "Fix errors in your code before running.\n" + modelManager.getFirstErrorDescription());
        }
        WurstProjectConfigData projectConfig = WurstProjectConfig.INSTANCE.loadProject(this.workspaceRoot.getFile().toPath().resolve("wurst.build"));
        if (projectConfig == null) {
            throw new RequestFailedException(MessageType.Error, "wurst.build file doesn't exist or is invalid. Please install your project using grill or the wurst setup tool.");
        }
        WurstGuiImpl gui = new WurstGuiImpl(this.getWorkspaceAbsolute());
        try {
            String ok = this.compileMap(modelManager, gui, projectConfig);
            if (ok != null) {
                String string = ok;
                return string;
            }
        }
        catch (CompileError e) {
            WLogger.info(e);
            throw new RequestFailedException(MessageType.Error, "A compilation error occurred when running the map:\n" + e);
        }
        catch (Exception e) {
            WLogger.warning("Exception occurred", e);
            throw new RequestFailedException(MessageType.Error, "An exception was thrown when running the map:\n" + e);
        }
        finally {
            if (gui.getErrorCount() == 0) {
                ((WurstGui)gui).sendFinished();
            }
        }
        return "ok";
    }

    @Nullable
    private String compileMap(ModelManager modelManager, WurstGui gui, WurstProjectConfigData projectConfig) throws Exception {
        if (this.map.isPresent() && !((File)this.map.get()).exists()) {
            throw new RequestFailedException(MessageType.Error, ((File)this.map.get()).getAbsolutePath() + " does not exist.");
        }
        gui.sendProgress("Copying map");
        File buildDir = this.getBuildDir();
        if (this.map.isPresent()) {
            mapLastModified = ((File)this.map.get()).lastModified();
            mapPath = ((File)this.map.get()).getAbsolutePath();
        }
        Optional<File> testMap = this.map.map($ -> new File(buildDir, "WurstRunMap.w3x"));
        MapRequest.CompilationResult result = this.compileScript(modelManager, gui, testMap, projectConfig, buildDir, false);
        if (this.runArgs.isHotReload()) {
            gui.sendProgress("Calling JHCR update");
            this.callJhcrUpdate(result.script);
            gui.sendProgress("update complete");
            return "ok";
        }
        if (testMap.isPresent()) {
            this.startGame(gui, testMap, result);
        }
        return null;
    }

    private void startGame(WurstGui gui, Optional<File> testMap, MapRequest.CompilationResult result) throws Exception {
        this.injectMapData(gui, testMap, result);
        File mapCopy = this.copyToWarcraftMapDir(testMap.get());
        gui.sendProgress("Starting Warcraft 3...");
        WLogger.info("Starting wc3 ... ");
        String path = "";
        if (this.customTarget != null) {
            path = new File(this.customTarget, testMap.get().getName()).getAbsolutePath();
        } else if (mapCopy != null) {
            path = mapCopy.getAbsolutePath();
        }
        if (!path.isEmpty()) {
            File gameExe = this.w3data.getGameExe().get();
            if (!this.w3data.getWc3PatchVersion().isPresent()) {
                throw new RequestFailedException(MessageType.Error, this.wc3Path + " does not exist.");
            }
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{gameExe.getAbsolutePath()});
            Optional<String> wc3RunArgs = this.langServer.getConfigProvider().getWc3RunArgs();
            if (!wc3RunArgs.isPresent() || StringUtils.isBlank((String)wc3RunArgs.get())) {
                if (this.w3data.getWc3PatchVersion().get().compareTo(GameVersion.VERSION_1_32) >= 0) {
                    cmd.add("-launch");
                }
                if (this.w3data.getWc3PatchVersion().get().compareTo(GameVersion.VERSION_1_31) < 0) {
                    cmd.add("-window");
                } else {
                    cmd.add("-windowmode");
                    cmd.add("windowed");
                }
            } else {
                cmd.addAll(Arrays.asList(wc3RunArgs.get().split("\\s+")));
            }
            cmd.add("-loadfile");
            cmd.add(path);
            if (Orient.isLinuxSystem()) {
                cmd.add(0, "wine");
            }
            gui.sendProgress("running " + cmd);
            Runtime.getRuntime().exec(cmd.toArray(new String[0]));
            this.timeTaker.endPhase();
            this.timeTaker.printReport();
        }
    }

    private void callJhcrUpdate(File mapScript) throws IOException, InterruptedException {
        File mapScriptFolder = mapScript.getParentFile();
        File commonJ = new File(mapScriptFolder, "common.j");
        File blizzardJ = new File(mapScriptFolder, "blizzard.j");
        if (!commonJ.exists()) {
            throw new IOException("Could not find file " + commonJ.getAbsolutePath());
        }
        if (!blizzardJ.exists()) {
            throw new IOException("Could not find file " + blizzardJ.getAbsolutePath());
        }
        Path customMapDataPath = this.getCustomMapDataPath();
        ProcessBuilder pb = new ProcessBuilder(this.langServer.getConfigProvider().getJhcrExe(), "update", mapScript.getName(), "--asm", "--preload-path", customMapDataPath.toAbsolutePath().toString());
        pb.directory(mapScriptFolder);
        Utils.ExecResult $ = Utils.exec(pb, Duration.ofSeconds(30L), System.err::println);
    }

    private Path getCustomMapDataPath() {
        Path documents;
        String customMapDataPath = this.langServer.getConfigProvider().getConfig("customMapDataPath", "");
        if (!customMapDataPath.isEmpty()) {
            return Paths.get(customMapDataPath, new String[0]);
        }
        try {
            documents = FileSystemView.getFileSystemView().getDefaultDirectory().toPath();
        }
        catch (Throwable t) {
            WLogger.info(t);
            Path homeFolder = Paths.get(System.getProperty("user.home"), new String[0]);
            documents = homeFolder.resolve("Documents");
        }
        return documents.resolve(Paths.get("Warcraft III", "CustomMapData"));
    }

    @NotNull
    private String getWorkspaceAbsolute() {
        try {
            return this.workspaceRoot.getFile().getAbsolutePath();
        }
        catch (FileNotFoundException e) {
            throw new RequestFailedException(MessageType.Error, "Could not open workspace root: ", e);
        }
    }

    private File copyToWarcraftMapDir(File testMap) throws IOException {
        String testMapName = "WurstTestMap.w3x";
        for (String arg : this.compileArgs) {
            if (!arg.startsWith("-runmapTarget")) continue;
            String path2 = arg.substring(arg.indexOf(" ") + 1);
            this.customTarget = new File(path2);
            if (this.customTarget.exists() && this.customTarget.isDirectory()) {
                File testMap2 = new File(this.customTarget, testMapName);
                Files.copy((File)testMap, (File)testMap2);
                return testMap2;
            }
            WLogger.severe("Directory specified via -runmapTarget does not exists or is not a directory");
        }
        File myDocumentsFolder = FileSystemView.getFileSystemView().getDefaultDirectory();
        Optional<String> documentPath = this.findMapDocumentPath(testMapName, myDocumentsFolder);
        Optional<File> testFolder = documentPath.map(path -> new File((String)path, "Maps" + File.separator + "Test"));
        if (testFolder.isPresent() && (testFolder.get().mkdirs() || testFolder.get().exists())) {
            File testMap2 = new File(testFolder.get(), testMapName);
            while (true) {
                try {
                    Files.copy((File)testMap, (File)testMap2);
                }
                catch (IOException ex) {
                    JFrame jf = new JFrame();
                    jf.setAlwaysOnTop(true);
                    Object[] options = new Object[]{"Retry", "Rename", "Cancel"};
                    int result = JOptionPane.showOptionDialog(jf, "Can't write to target map file, it's probably in use.", "Run Map", 1, -1, null, options, null);
                    if (result == 2) {
                        return null;
                    }
                    if (result != 1) continue;
                    testMap2 = new File(testFolder.get(), testMapName + RandomStringUtils.randomNumeric((int)3));
                    continue;
                }
                break;
            }
            return testMap2;
        }
        WLogger.severe("Could not create Test folder");
        return null;
    }

    private Optional<String> findMapDocumentPath(String testMapName, File myDocumentsFolder) {
        Optional<Object> documentPath = Optional.of(this.langServer.getConfigProvider().getMapDocumentPath().orElseGet(() -> myDocumentsFolder.getAbsolutePath() + File.separator + "Warcraft III"));
        if (!new File(documentPath.get()).exists()) {
            WLogger.info("Warcraft folder " + documentPath + " does not exist.");
            documentPath = Optional.of(System.getProperty("user.home") + "/.wine/drive_c/users/" + System.getProperty("user.name") + "/My Documents/Warcraft III");
            if (!new File((String)documentPath.get()).exists()) {
                WLogger.severe("Severe: Wine Warcraft folder " + documentPath + " does not exist.");
            }
        }
        if (this.w3data.getWc3PatchVersion().get().compareTo(new GameVersion("1.27.9")) <= 0) {
            WLogger.info("Version 1.27 or lower detected, changing file location");
            documentPath = this.wc3Path;
        } else {
            Optional<File> oldFile = this.wc3Path.map(w3p -> new File((String)w3p, "Maps" + File.separator + "Test" + File.separator + testMapName));
            if (oldFile.isPresent() && oldFile.get().exists() && !oldFile.get().delete()) {
                WLogger.severe("Cannot delete old Wurst Test Map");
            }
        }
        return documentPath;
    }
}

