/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.NameLinkType;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypePackage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PackageLink
extends DefLink {
    private final WPackage def;

    public PackageLink(Visibility visibility, WScope definedIn, WPackage def) {
        super(visibility, definedIn, Collections.emptyList(), null);
        this.def = def;
    }

    public static PackageLink create(WPackage def, WScope definedIn) {
        return new PackageLink(PackageLink.calcVisibility(definedIn, def), definedIn, def);
    }

    @Override
    public String getName() {
        return this.def.getName();
    }

    @Override
    public WPackage getDef() {
        return this.def;
    }

    @Override
    public PackageLink withVisibility(Visibility newVis) {
        return new PackageLink(newVis, this.getDefinedIn(), this.def);
    }

    @Override
    public boolean receiverCompatibleWith(WurstType receiverType, Element location) {
        return receiverType == null;
    }

    @Override
    public NameLinkType getType() {
        return null;
    }

    @Override
    public PackageLink withTypeArgBinding(Element context, VariableBinding binding) {
        return this;
    }

    @Override
    public DefLink withGenericTypeParams(List<TypeParamDef> typeParams) {
        return this;
    }

    @Override
    public WurstType getTyp() {
        return new WurstTypePackage(this.def);
    }

    @Override
    public PackageLink withDef(NameDef def) {
        return new PackageLink(this.getVisibility(), this.getDefinedIn(), (WPackage)def);
    }

    @Override
    public PackageLink hidingPrivate() {
        return (PackageLink)super.hidingPrivate();
    }

    @Override
    public PackageLink hidingPrivateAndProtected() {
        return (PackageLink)super.hidingPrivateAndProtected();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageLink that = (PackageLink)o;
        return Objects.equals(this.def, that.def);
    }

    public int hashCode() {
        return Objects.hash(this.def);
    }
}

