/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.jassinterpreter;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.intermediatelang.interpreter.ProgramState;
import de.peeeq.wurstscript.parser.WPos;

public class InterpreterException
extends RuntimeException {
    private static final long serialVersionUID = 3387292080655779808L;
    private Element trace;
    private String stackTrace;

    public InterpreterException(ProgramState g, String msg) {
        super(msg);
        this.trace = g.getLastStatement().attrTrace();
    }

    public InterpreterException(String msg) {
        super(msg);
        this.trace = null;
    }

    public InterpreterException(Element trace, String msg) {
        super(msg);
        this.trace = trace;
    }

    public InterpreterException(Element trace, String msg, Throwable e) {
        super(msg, e);
        this.trace = trace;
    }

    @Override
    public String getMessage() {
        Object res = super.getMessage();
        if (this.trace != null) {
            WPos pos = this.trace.attrSource();
            res = (String)res + "\n  at " + pos.getFile() + " line " + pos.getLine();
        }
        return res;
    }

    @Override
    public String toString() {
        return this.getMessage() + (String)(this.stackTrace != null ? "\nStack trace:\n" + this.stackTrace : "");
    }

    public InterpreterException setStacktrace(String msg) {
        if (this.stackTrace == null) {
            this.stackTrace = msg;
        }
        return this;
    }

    public InterpreterException setTrace(Element trace) {
        if (this.trace == null) {
            this.trace = trace;
        }
        return null;
    }

    public Element getTrace() {
        return this.trace;
    }

    public String getWurstStackTrace() {
        return this.stackTrace;
    }
}

