/*
 * Decompiled with CFR 0.152.
 */
package tablelayout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import tablelayout.BaseTableLayout;
import tablelayout.Cell;
import tablelayout.SwingToolkit;
import tablelayout.Table;

class TableLayout
extends BaseTableLayout<Component, Table, TableLayout, SwingToolkit> {
    ArrayList<SwingToolkit.DebugRect> debugRects;

    public TableLayout() {
        super((SwingToolkit)SwingToolkit.instance);
    }

    public TableLayout(SwingToolkit toolkit) {
        super(toolkit);
    }

    public void layout() {
        Table table = (Table)this.getTable();
        Insets insets = table.getInsets();
        super.layout(insets.left, insets.top, table.getWidth() - insets.left - insets.right, table.getHeight() - insets.top - insets.bottom);
        List<Cell> cells = this.getCells();
        for (Cell c : cells) {
            Component component;
            if (c.getIgnore() || (component = (Component)c.getWidget()) == null) continue;
            component.setLocation((int)c.getWidgetX(), (int)c.getWidgetY());
            component.setSize((int)c.getWidgetWidth(), (int)c.getWidgetHeight());
        }
        if (this.getDebug() != BaseTableLayout.Debug.none) {
            SwingToolkit.startDebugTimer();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (((Table)this.getTable()).isValid()) {
            ((Table)this.getTable()).invalidate();
        }
    }

    @Override
    public void invalidateHierarchy() {
        if (((Table)this.getTable()).isValid()) {
            ((Table)this.getTable()).invalidate();
        }
    }

    void drawDebug() {
        Graphics2D g = (Graphics2D)((Table)this.getTable()).getGraphics();
        if (g == null) {
            return;
        }
        g.setColor(Color.red);
        for (SwingToolkit.DebugRect rect : this.debugRects) {
            if (rect.type == BaseTableLayout.Debug.cell) {
                g.setColor(Color.red);
            }
            if (rect.type == BaseTableLayout.Debug.widget) {
                g.setColor(Color.green);
            }
            if (rect.type == BaseTableLayout.Debug.table) {
                g.setColor(Color.blue);
            }
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }
}

