/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.bytes;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a8\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0006\u001a\n\u0010\r\u001a\u00020\u0004*\u00020\u000e\u001a\u001e\u0010\r\u001a\u00020\u0004*\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0011\u001a\u00020\u0004*\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0011\u001a\u00020\u0004*\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0012\u001a\u00020\u000f*\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"LINE_SEPARATOR", "", "kotlin.jvm.PlatformType", "print", "", "length", "", "includeByteCount", "", "inputOffset", "lineLength", "header", "printRaw", "toBytes", "", "", "start", "toBytes16", "toInts", "startPosition", "xor", "", "keyArray", "ByteUtilities"})
public final class ArrayExtensionsKt {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    @NotNull
    public static final byte[] toBytes16(@NotNull String $this$toBytes16, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$toBytes16, (String)"<this>");
        byte[] bytes = new byte[length * 2];
        int j = 0;
        int endPosition = start + length;
        for (int i = start; i < endPosition; ++i) {
            char code = $this$toBytes16.charAt(i);
            int srcIndx = j++;
            bytes[2 * srcIndx] = (byte)(code >> 8);
            bytes[2 * srcIndx + 1] = (byte)code;
        }
        return bytes;
    }

    public static /* synthetic */ byte[] toBytes16$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return ArrayExtensionsKt.toBytes16(string, n, n2);
    }

    @NotNull
    public static final byte[] toBytes16(@NotNull char[] $this$toBytes16, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$toBytes16, (String)"<this>");
        byte[] bytes = new byte[length * 2];
        int j = 0;
        int endPosition = start + length;
        for (int i = start; i < endPosition; ++i) {
            char code = $this$toBytes16[i];
            int srcIndx = j++;
            bytes[2 * srcIndx] = (byte)(code >> 8);
            bytes[2 * srcIndx + 1] = (byte)code;
        }
        return bytes;
    }

    public static /* synthetic */ byte[] toBytes16$default(char[] cArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = cArray.length;
        }
        return ArrayExtensionsKt.toBytes16(cArray, n, n2);
    }

    @NotNull
    public static final byte[] toBytes(@NotNull char[] $this$toBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$toBytes, (String)"<this>");
        int length = $this$toBytes.length;
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char charValue = $this$toBytes[i];
            bytes[i] = (byte)charValue;
        }
        return bytes;
    }

    @NotNull
    public static final byte[] toBytes(@NotNull int[] $this$toBytes, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$toBytes, (String)"<this>");
        byte[] bytes = new byte[length];
        int endPosition = start + length;
        int j = 0;
        for (int i = start; i < endPosition; ++i) {
            int intValue = $this$toBytes[i];
            if (intValue < 0 || intValue > 255) {
                throw new Exception("Int at index " + i + '(' + intValue + ") was not a valid byte value (0-255)");
            }
            bytes[j++] = (byte)intValue;
        }
        return bytes;
    }

    public static /* synthetic */ byte[] toBytes$default(int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = nArray.length;
        }
        return ArrayExtensionsKt.toBytes(nArray, n, n2);
    }

    @NotNull
    public static final int[] toInts(@NotNull byte[] $this$toInts, int startPosition, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$toInts, (String)"<this>");
        int[] ints = new int[length];
        int endPosition = startPosition + length;
        int j = 0;
        for (int i = startPosition; i < endPosition; ++i) {
            ints[j++] = $this$toInts[i] & 0xFF;
        }
        return ints;
    }

    public static /* synthetic */ int[] toInts$default(byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byArray.length;
        }
        return ArrayExtensionsKt.toInts(byArray, n, n2);
    }

    public static final void xor(@NotNull byte[] $this$xor, @NotNull byte[] keyArray) {
        Intrinsics.checkNotNullParameter((Object)$this$xor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyArray, (String)"keyArray");
        int keyIndex = 0;
        int keyLength = keyArray.length;
        int n = $this$xor.length;
        for (int i = 0; i < n; ++i) {
            $this$xor[i] = (byte)($this$xor[i] ^ keyArray[keyIndex++ % keyLength]);
        }
    }

    @NotNull
    public static final String printRaw(@NotNull byte[] $this$printRaw, int lineLength) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$printRaw, (String)"<this>");
        if (lineLength > 0) {
            int length = $this$printRaw.length;
            int comma = length - 1;
            StringBuilder builder = new StringBuilder(length + length / lineLength);
            for (int i = 0; i < length; ++i) {
                builder.append($this$printRaw[i]);
                if (i < comma) {
                    builder.append(",");
                }
                if (i <= 0 || i % lineLength != 0) continue;
                builder.append(LINE_SEPARATOR);
            }
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        val length = t\u2026 builder.toString()\n    }");
            string = string2;
        } else {
            int length = $this$printRaw.length;
            int comma = length - 1;
            StringBuilder builder = new StringBuilder(length + length);
            for (int i = 0; i < length; ++i) {
                builder.append($this$printRaw[i]);
                if (i >= comma) continue;
                builder.append(",");
            }
            String string3 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n        val length = t\u2026 builder.toString()\n    }");
            string = string3;
        }
        return string;
    }

    public static /* synthetic */ String printRaw$default(byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return ArrayExtensionsKt.printRaw(byArray, n);
    }

    @NotNull
    public static final String print(@NotNull byte[] $this$print, int length, boolean includeByteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$print, (String)"<this>");
        return ArrayExtensionsKt.print($this$print, 0, length, includeByteCount, 40, null);
    }

    public static /* synthetic */ String print$default(byte[] byArray, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = byArray.length;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return ArrayExtensionsKt.print(byArray, n, bl);
    }

    @NotNull
    public static final String print(@NotNull byte[] $this$print, int inputOffset, int length, boolean includeByteCount, int lineLength, @Nullable String header) {
        Intrinsics.checkNotNullParameter((Object)$this$print, (String)"<this>");
        int comma = length - 1;
        int builderLength = length + comma + 2;
        if (includeByteCount) {
            builderLength += 7 + String.valueOf(length).length();
        }
        if (lineLength > 0) {
            builderLength += length / lineLength;
        }
        if (header != null) {
            builderLength += header.length() + 2;
        }
        StringBuilder builder = new StringBuilder(builderLength);
        if (header != null) {
            builder.append(header).append(LINE_SEPARATOR);
        }
        if (includeByteCount) {
            builder.append("Bytes: ").append(length).append(LINE_SEPARATOR);
        }
        builder.append("{");
        for (int i = inputOffset; i < length; ++i) {
            builder.append($this$print[i]);
            if (i < comma) {
                builder.append(",");
            }
            if (i <= inputOffset || lineLength <= 0 || i % lineLength != 0) continue;
            builder.append(LINE_SEPARATOR);
        }
        builder.append("}");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public static /* synthetic */ String print$default(byte[] byArray, int n, int n2, boolean bl, int n3, String string, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 40;
        }
        if ((n4 & 0x10) != 0) {
            string = null;
        }
        return ArrayExtensionsKt.print(byArray, n, n2, bl, n3, string);
    }
}

