/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WurstModel;
import org.eclipse.jdt.annotation.Nullable;

public class CofigOverridePackages {
    public static final String CONFIG_POSTFIX = "_config";

    public static ImmutableMap<WPackage, WPackage> calculate(WurstModel model) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableMap<String, WPackage> packages = model.attrPackages();
        for (WPackage p : packages.values()) {
            if (!p.getName().endsWith(CONFIG_POSTFIX)) continue;
            WPackage origP = CofigOverridePackages.getOriginalPackage(p);
            if (origP == null) {
                p.addError("No package named " + p.getName() + " exists, so it is not possible to have a config package for it.");
                continue;
            }
            result.put((Object)origP, (Object)p);
        }
        return result.build();
    }

    public static @Nullable WPackage getOriginalPackage(WPackage configPackage) {
        Preconditions.checkArgument((boolean)configPackage.getName().endsWith(CONFIG_POSTFIX));
        ImmutableMap<String, WPackage> packages = configPackage.getModel().attrPackages();
        String name = configPackage.getName();
        name = name.substring(0, name.length() - CONFIG_POSTFIX.length());
        WPackage origP = (WPackage)packages.get(name);
        return origP;
    }
}

