/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import de.peeeq.wurstio.languageserver.Convert;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.requests.HoverInfo;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstscript.ast.AstElementWithParameters;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrModule;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.HasModifier;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.NativeType;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;

public class DocumentSymbolRequest
extends UserRequest<List<Either<SymbolInformation, DocumentSymbol>>> {
    private final TextDocumentIdentifier textDocument;

    public DocumentSymbolRequest(DocumentSymbolParams params) {
        this.textDocument = params.getTextDocument();
    }

    @Override
    public List<Either<SymbolInformation, DocumentSymbol>> execute(ModelManager modelManager) {
        CompilationUnit cu = modelManager.getCompilationUnit(WFile.create(this.textDocument.getUri()));
        return this.symbolsFromCu(cu).stream().map(Either::forRight).collect(Collectors.toList());
    }

    private List<DocumentSymbol> symbolsFromCu(CompilationUnit cu) {
        if (cu == null) {
            return Collections.emptyList();
        }
        ArrayList<DocumentSymbol> result = new ArrayList<DocumentSymbol>();
        for (WPackage p : cu.getPackages()) {
            this.addSymbolsForPackage(result, p);
        }
        return result;
    }

    private void addSymbolsForPackage(List<DocumentSymbol> result, WPackage p) {
        String name = p.getName();
        result.add(this.makeDocumentSymbol(p.getNameId(), SymbolKind.Package, name, null));
        for (WEntity e : p.getElements()) {
            this.addSymbolsForEntity(result, e);
        }
    }

    @NotNull
    private DocumentSymbol makeDocumentSymbol(Element p, SymbolKind kind, String name, List<DocumentSymbol> children) {
        String detail = null;
        if (p instanceof AstElementWithParameters) {
            detail = "(" + HoverInfo.getParameterString((AstElementWithParameters)p) + ")";
        }
        return new DocumentSymbol(name, kind, Convert.range(p), Convert.errorRange(p), detail, children);
    }

    private void addSymbolsForEntity(final List<DocumentSymbol> result, final WEntity e) {
        e.match(new WEntity.MatcherVoid(){

            private void add(String name, SymbolKind kind) {
                this.add(name, kind, Collections.emptyList());
            }

            private void add(String name, SymbolKind kind, List<DocumentSymbol> children) {
                if (!e.attrSource().isArtificial()) {
                    result.add(DocumentSymbolRequest.this.makeDocumentSymbol(e, kind, name, children));
                }
            }

            @Override
            public void case_ExtensionFuncDef(ExtensionFuncDef extensionFuncDef) {
                this.add(Utils.printTypeExpr(extensionFuncDef.getExtendedType()) + "." + extensionFuncDef.getName(), SymbolKind.Function);
            }

            @Override
            public void case_ClassDef(ClassDef classDef) {
                this.case_ClassOrModule(classDef);
            }

            @Override
            public void case_InterfaceDef(InterfaceDef interfaceDef) {
                String name = interfaceDef.getName();
                ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
                this.add(name, SymbolKind.Interface, children);
                for (FuncDef f : interfaceDef.getMethods()) {
                    DocumentSymbolRequest.this.addSymbolsForEntity(children, f);
                }
                for (GlobalVarDef v : interfaceDef.getVars()) {
                    DocumentSymbolRequest.this.addSymbolsForEntity(children, v);
                }
            }

            @Override
            public void case_ModuleInstanciation(ModuleInstanciation moduleInstanciation) {
            }

            @Override
            public void case_NativeType(NativeType nativeType) {
                this.add(nativeType.getName(), SymbolKind.Class);
            }

            @Override
            public void case_InitBlock(InitBlock initBlock) {
                this.add("init", SymbolKind.Function);
            }

            @Override
            public void case_TupleDef(TupleDef tupleDef) {
                this.add(tupleDef.getName(), SymbolKind.Class);
            }

            @Override
            public void case_FuncDef(FuncDef funcDef) {
                SymbolKind kind = funcDef.attrIsDynamicClassMember() ? SymbolKind.Method : SymbolKind.Function;
                this.add(funcDef.getName(), kind);
            }

            @Override
            public void case_NativeFunc(NativeFunc nativeFunc) {
                this.add(nativeFunc.getName(), SymbolKind.Function);
            }

            @Override
            public void case_GlobalVarDef(GlobalVarDef g) {
                SymbolKind kind = g.attrIsDynamicClassMember() ? SymbolKind.Field : SymbolKind.Variable;
                this.add(g.getName(), kind);
            }

            @Override
            public void case_EnumDef(EnumDef enumDef) {
                this.add(enumDef.getName(), SymbolKind.Class);
            }

            @Override
            public void case_TypeParamDef(TypeParamDef typeParamDef) {
                this.add(typeParamDef.getName(), SymbolKind.Class);
            }

            @Override
            public void case_ModuleDef(ModuleDef moduleDef) {
                this.case_ClassOrModule(moduleDef);
            }

            public void case_ClassOrModule(ClassOrModule def) {
                String name = def.getName();
                ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
                this.add(name, SymbolKind.Class, children);
                for (HasModifier c : def.getInnerClasses()) {
                    DocumentSymbolRequest.this.addSymbolsForEntity(children, (WEntity)((Object)c));
                }
                for (FuncDef f : def.getMethods()) {
                    DocumentSymbolRequest.this.addSymbolsForEntity(children, f);
                }
                for (GlobalVarDef v : def.getVars()) {
                    DocumentSymbolRequest.this.addSymbolsForEntity(children, v);
                }
                for (HasModifier c : def.getConstructors()) {
                    if (c.attrSource().isArtificial()) continue;
                    children.add(DocumentSymbolRequest.this.makeDocumentSymbol(c, SymbolKind.Constructor, "construct", Collections.emptyList()));
                }
            }
        });
    }
}

