/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3.compression;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;

class Huffman {
    private Node nodes = null;
    private final TreeMap<Integer, Node> sorted2 = new TreeMap();
    private Node root = null;
    private int bitBuffer;
    private byte bitNumber;
    private ByteBuffer source;
    private static final byte[][] PROBABILITY_TABLES = new byte[][]{{10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1}, {84, 22, 22, 13, 12, 8, 6, 5, 6, 5, 6, 3, 4, 4, 3, 5, 14, 11, 20, 19, 19, 9, 11, 6, 5, 4, 3, 2, 3, 2, 2, 2, 13, 7, 9, 6, 6, 4, 3, 2, 4, 3, 3, 3, 3, 3, 2, 2, 9, 6, 4, 4, 4, 4, 3, 2, 3, 2, 2, 2, 2, 3, 2, 4, 8, 3, 4, 7, 9, 5, 3, 3, 3, 3, 2, 2, 2, 3, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 2, 2, 6, 10, 8, 8, 6, 7, 4, 3, 4, 4, 2, 2, 4, 2, 3, 3, 4, 3, 7, 7, 9, 6, 4, 3, 3, 2, 1, 2, 2, 2, 2, 2, 10, 2, 2, 3, 2, 2, 1, 1, 2, 2, 2, 6, 3, 5, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 4, 4, 4, 7, 9, 8, 12, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 4, 1, 2, 4, 5, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 4, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 2, 6, 75, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 39, 0, 0, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 6, 14, 16, 4, 6, 8, 5, 4, 4, 3, 3, 2, 2, 3, 3, 1, 1, 2, 1, 1, 1, 4, 2, 4, 2, 2, 2, 1, 1, 4, 1, 1, 2, 3, 3, 2, 3, 1, 3, 6, 4, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 41, 7, 22, 18, 64, 10, 10, 17, 37, 1, 3, 23, 16, 38, 42, 16, 1, 35, 35, 47, 16, 6, 7, 2, 9, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}, {-1, 11, 7, 5, 11, 2, 2, 2, 6, 2, 2, 1, 4, 2, 1, 3, 9, 1, 1, 1, 3, 4, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 5, 1, 1, 1, 13, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 10, 4, 2, 1, 6, 3, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 5, 2, 3, 4, 3, 3, 3, 2, 1, 1, 1, 2, 1, 2, 3, 3, 1, 3, 1, 1, 2, 5, 1, 1, 4, 3, 5, 1, 3, 1, 3, 3, 2, 1, 4, 3, 10, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 10, 2, 5, 1, 1, 2, 7, 2, 23, 1, 5, 1, 1, 14, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 2, 1, 4, 5, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 17, 1, 1}, {-1, -5, -104, -102, -124, -123, 99, 100, 62, 62, 34, 34, 19, 19, 24, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}, {-1, -15, -99, -98, -102, -101, -102, -105, -109, -109, -116, -114, -122, -120, -128, -126, 124, 124, 114, 115, 105, 107, 95, 96, 85, 86, 74, 75, 64, 65, 55, 55, 47, 47, 39, 39, 33, 33, 27, 28, 23, 23, 19, 19, 16, 16, 13, 13, 11, 11, 9, 9, 8, 8, 7, 7, 6, 5, 5, 4, 4, 4, 25, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}, {-61, -53, -11, 65, -1, 123, -9, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -65, -52, -14, 64, -3, 124, -9, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}, {-61, -39, -17, 61, -7, 124, -23, 30, -3, -85, -15, 44, -4, 91, -2, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -67, -39, -20, 61, -11, 125, -24, 29, -5, -82, -16, 44, -5, 92, -1, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}, {-70, -59, -38, 51, -29, 109, -40, 24, -27, -108, -38, 35, -33, 74, -47, 16, -18, -81, -28, 44, -22, 90, -34, 21, -12, -121, -23, 33, -10, 67, -4, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -80, -57, -40, 51, -29, 107, -42, 24, -25, -107, -40, 35, -37, 73, -48, 17, -23, -78, -30, 43, -24, 92, -35, 21, -15, -121, -25, 32, -9, 68, -1, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, -98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}};

    Huffman() {
    }

    private void setSource(ByteBuffer source) {
        this.source = source;
        this.bitBuffer = 0;
        this.bitNumber = 0;
    }

    private int getBits(int bits) {
        while (this.bitNumber < bits) {
            this.bitBuffer |= (this.source.get() & 0xFF) << this.bitNumber;
            this.bitNumber = (byte)(this.bitNumber + 8);
        }
        int result = this.bitBuffer & (1 << bits) - 1;
        this.bitBuffer >>>= bits;
        this.bitNumber = (byte)(this.bitNumber - bits);
        return result;
    }

    private Node getNode() {
        Node node;
        if (this.nodes == null) {
            node = new Node();
        } else {
            node = this.nodes;
            this.nodes = this.nodes.removeFromList();
        }
        return node;
    }

    private void destroyTree(Node root) {
        if (this.nodes == null) {
            this.nodes = root;
        } else {
            this.nodes.joinList(root);
        }
        this.root = null;
        this.sorted2.clear();
    }

    private void insertNode(Node node) {
        Map.Entry<Integer, Node> test2 = this.sorted2.ceilingEntry(node.probability);
        if (test2 != null) {
            Node current = test2.getValue();
            node.insertAfter(current);
        } else {
            if (this.root != null) {
                node.insertAfter(this.root.prev);
            } else {
                node.newList();
            }
            this.root = node;
        }
        this.sorted2.put(node.probability, node);
    }

    private Node addValueToTree(int value) {
        Node node = this.getNode();
        node.value = value;
        node.probability = 0;
        node.child[0] = null;
        node.child[1] = null;
        this.insertNode(node);
        Node node2 = this.getNode();
        Node child1 = this.root.prev;
        Node child2 = child1.prev;
        node2.value = -1;
        node2.probability = child1.probability + child2.probability;
        node2.child[0] = child1;
        node2.child[1] = child2;
        node2.parent = child2.parent;
        node2.insertAfter(child2.prev);
        if (node2.parent.child[0] == child2) {
            node2.parent.child[0] = node2;
        } else {
            node2.parent.child[1] = node2;
        }
        child1.parent = node2;
        child2.parent = node2;
        return node;
    }

    private void incrementProbability(Node node) {
        while (node != null) {
            if (this.sorted2.get(node.probability) == node) {
                if (node.probability == node.prev.probability) {
                    this.sorted2.put(node.probability, node.prev);
                } else {
                    this.sorted2.remove(node.probability);
                }
            }
            ++node.probability;
            Map.Entry<Integer, Node> test2 = this.sorted2.ceilingEntry(node.probability);
            Node where = test2 != null ? test2.getValue().next : this.root;
            if (where != node) {
                node.listSwap(where);
                node.treeSwap(where);
                if (where.probability != where.next.probability) {
                    this.sorted2.put(where.probability, where);
                }
            }
            this.sorted2.put(node.probability, node);
            node = node.parent;
        }
    }

    private void buildTree(byte tree) {
        byte[] probabilities = PROBABILITY_TABLES[tree];
        if (this.root != null) {
            this.destroyTree(this.root);
        }
        for (int i = 0; i < 258; ++i) {
            int prob = probabilities[i] & 0xFF;
            if (prob == 0) continue;
            Node node = this.getNode();
            node.value = i;
            node.probability = prob;
            node.child[0] = null;
            node.child[1] = null;
            this.insertNode(node);
        }
        Node current = this.root.prev;
        while (current != this.root) {
            Node node = this.getNode();
            Node child1 = current;
            Node child2 = current = current.prev;
            child1.parent = node;
            child2.parent = node;
            node.value = -1;
            node.probability = child1.probability + child2.probability;
            node.child[0] = child1;
            node.child[1] = child2;
            this.insertNode(node);
            current = current.prev;
        }
        this.root.parent = null;
    }

    void Decompress(ByteBuffer in, ByteBuffer out) {
        this.setSource(in);
        byte type = (byte)this.getBits(8);
        this.buildTree(type);
        boolean adjustProbability = type == 0;
        while (true) {
            Node current = this.root;
            while (current.value == -1) {
                current = current.child[this.getBits(1)];
            }
            if (current.value == 257) {
                int value = this.getBits(8);
                current = this.addValueToTree(value);
                this.incrementProbability(current);
                if (!adjustProbability) {
                    this.incrementProbability(current);
                }
            } else if (current.value == 256) break;
            out.put((byte)current.value);
            if (!adjustProbability) continue;
            this.incrementProbability(current);
        }
    }

    private static class Node {
        Node parent;
        final Node[] child = new Node[2];
        Node next;
        Node prev;
        int value;
        int probability;

        private Node() {
        }

        void treeSwap(Node with) {
            Node temp;
            if (this.parent == with.parent) {
                temp = this.parent.child[0];
                this.parent.child[0] = this.parent.child[1];
                this.parent.child[1] = temp;
            } else {
                if (with.parent.child[0] == with) {
                    with.parent.child[0] = this;
                } else {
                    with.parent.child[1] = this;
                }
                if (this.parent.child[0] == this) {
                    this.parent.child[0] = with;
                } else {
                    this.parent.child[1] = with;
                }
            }
            temp = this.parent;
            this.parent = with.parent;
            with.parent = temp;
        }

        void insertAfter(Node where) {
            this.prev = where;
            this.next = where.next;
            where.next = this;
            this.next.prev = this;
        }

        void listSwap(Node with) {
            if (this.next == with) {
                this.next = with.next;
                with.next = this;
                with.prev = this.prev;
                this.prev = with;
                with.prev.next = with;
                this.next.prev = this;
            } else if (this.prev == with) {
                this.prev = with.prev;
                with.prev = this;
                with.next = this.next;
                this.next = with;
                with.next.prev = with;
                this.prev.next = this;
            } else {
                Node temp = this.prev;
                this.prev = with.prev;
                with.prev = temp;
                temp = this.next;
                this.next = with.next;
                with.next = temp;
                this.prev.next = this;
                this.next.prev = this;
                with.prev.next = with;
                with.next.prev = with;
            }
        }

        void newList() {
            this.prev = this.next = this;
        }

        Node removeFromList() {
            if (this == this.next) {
                return null;
            }
            this.prev.next = this.next;
            this.next.prev = this.prev;
            return this.next;
        }

        void joinList(Node list) {
            Node tail = this.prev;
            this.prev = list.prev;
            this.prev.next = this;
            list.prev = tail;
            tail.next = list;
        }
    }
}

