/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.utils.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class AttrImportedPackage {
    public static @Nullable WPackage getImportedPackage(WImport i) {
        try {
            WurstModel root = i.getModel();
            WPackage p = (WPackage)root.attrPackages().get((Object)i.getPackagename());
            if (p == null && !i.getPackagename().equals("NoWurst")) {
                i.addError("Could not find imported package " + i.getPackagename());
            }
            return p;
        }
        catch (Error e) {
            i.addError("Could not find imported package " + i.getPackagename() + "\n" + e.getMessage());
            return null;
        }
    }

    public static WurstModel getModel(Element elem) {
        for (Element e = elem; e != null; e = e.getParent()) {
            if (!(e instanceof WurstModel)) continue;
            return (WurstModel)e;
        }
        throw new Error("trying to get model for element " + Utils.printElement(elem) + ", which is not attached to a model");
    }

    public static ImmutableMap<String, WPackage> getPackages(WurstModel wurstModel) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (CompilationUnit cu : wurstModel) {
            for (WPackage p : cu.getPackages()) {
                WPackage old = result.put(p.getName(), p);
                if (old == null || p.getName().equals("Wurst")) continue;
                p.addError("Package " + p.getName() + " is already defined in " + Utils.printPos(old.getSource()));
                old.addError("Package " + p.getName() + " is already defined in " + Utils.printPos(p.getSource()));
            }
        }
        return ImmutableMap.copyOf((Map)result);
    }
}

