/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.simple.registry;

import de.ralleytn.simple.registry.Key;
import de.ralleytn.simple.registry.Registry;
import de.ralleytn.simple.registry.Reloadable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;

public final class Value
implements Reloadable {
    private String name;
    private String path;
    private Type type;
    private String rawValue;
    private Object value;

    Value(String name, Type type, String rawValue, String path) {
        this.name = name;
        this.type = type;
        this.rawValue = rawValue;
        this.value = type.parseValue(rawValue);
        this.path = path;
    }

    @Override
    public final void reload() throws IOException {
        Value value = Registry.getValue(this.path, this.name);
        this.name = value.name;
        this.path = value.path;
        this.type = value.type;
        this.rawValue = value.rawValue;
        this.value = value;
    }

    public final String getName() {
        return this.name;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getRawValue() {
        return this.rawValue;
    }

    public final Key getKey() throws IOException {
        return Registry.getKey(this.path);
    }

    public final Object getValue() {
        return this.value;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append('|');
        builder.append(this.type.name());
        builder.append('|');
        builder.append(this.rawValue);
        return builder.toString();
    }

    public static enum Type {
        REG_BINARY{

            @Override
            protected final Object parseValue(String toParse) {
                byte[] value = null;
                try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                    for (int index = 0; index < toParse.length(); index += 2) {
                        buffer.write(Integer.parseInt(toParse.substring(index, index + 2), 16));
                    }
                    value = buffer.toByteArray();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                return value;
            }
        }
        ,
        REG_DWORD{

            @Override
            protected final Object parseValue(String toParse) {
                return Integer.parseInt(toParse.substring(2), 16);
            }
        }
        ,
        REG_QWORD{

            @Override
            protected final Object parseValue(String toParse) {
                return Long.parseLong(toParse.substring(2), 16);
            }
        }
        ,
        REG_SZ{

            @Override
            protected final Object parseValue(String toParse) {
                return toParse;
            }
        }
        ,
        REG_EXPAND_SZ{

            @Override
            protected final Object parseValue(String toParse) {
                String value = toParse;
                for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                    value = Pattern.compile('%' + entry.getKey() + '%', 2).matcher(value).replaceAll(entry.getValue().replace("\\", "\\\\"));
                }
                return value;
            }
        }
        ,
        REG_MULTI_SZ{

            @Override
            protected final Object parseValue(String toParse) {
                ArrayList<String> value = new ArrayList<String>();
                for (String string : toParse.split("\u0000")) {
                    if (string.isEmpty()) break;
                    value.add(string);
                }
                return value;
            }
        }
        ,
        REG_FULL_RESOURCE_DESCRIPTOR{

            @Override
            protected final Object parseValue(String toParse) {
                return toParse;
            }
        }
        ,
        REG_NONE{

            @Override
            protected final Object parseValue(String toParse) {
                return toParse;
            }
        };


        protected abstract Object parseValue(String var1);

        public static final Type getTypeByName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

