/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.peParser.headers;

import dorkbox.peParser.ByteArray;
import dorkbox.peParser.headers.Header;
import dorkbox.peParser.types.AsciiString;
import dorkbox.peParser.types.ByteDefinition;
import dorkbox.peParser.types.DWORD;
import dorkbox.peParser.types.HeaderDefinition;
import dorkbox.peParser.types.SectionCharacteristics;
import dorkbox.peParser.types.WORD;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 %2\u00020\u0001:\u0001%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\u001f\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u0011\u0010!\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u0011\u0010#\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001a\u00a8\u0006&"}, d2={"Ldorkbox/peParser/headers/SectionTableEntry;", "Ldorkbox/peParser/headers/Header;", "bytes", "Ldorkbox/peParser/ByteArray;", "entryNumber", "", "offset", "size", "(Ldorkbox/peParser/ByteArray;III)V", "CHARACTERISTICS", "Ldorkbox/peParser/types/SectionCharacteristics;", "getCHARACTERISTICS", "()Ldorkbox/peParser/types/SectionCharacteristics;", "NAME", "Ldorkbox/peParser/types/AsciiString;", "getNAME", "()Ldorkbox/peParser/types/AsciiString;", "NUMBER_OF_LINE_NUMBERS", "Ldorkbox/peParser/types/WORD;", "getNUMBER_OF_LINE_NUMBERS", "()Ldorkbox/peParser/types/WORD;", "NUMBER_OF_RELOCATIONS", "getNUMBER_OF_RELOCATIONS", "POINTER_TO_LINE_NUMBERS", "Ldorkbox/peParser/types/DWORD;", "getPOINTER_TO_LINE_NUMBERS", "()Ldorkbox/peParser/types/DWORD;", "POINTER_TO_RAW_DATA", "getPOINTER_TO_RAW_DATA", "POINTER_TO_RELOCATIONS", "getPOINTER_TO_RELOCATIONS", "SIZE_OF_RAW_DATA", "getSIZE_OF_RAW_DATA", "VIRTUAL_ADDRESS", "getVIRTUAL_ADDRESS", "VIRTUAL_SIZE", "getVIRTUAL_SIZE", "Companion", "PeParser"})
public final class SectionTableEntry
extends Header {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AsciiString NAME;
    @NotNull
    private final DWORD VIRTUAL_SIZE;
    @NotNull
    private final DWORD VIRTUAL_ADDRESS;
    @NotNull
    private final DWORD SIZE_OF_RAW_DATA;
    @NotNull
    private final DWORD POINTER_TO_RAW_DATA;
    @NotNull
    private final DWORD POINTER_TO_RELOCATIONS;
    @NotNull
    private final DWORD POINTER_TO_LINE_NUMBERS;
    @NotNull
    private final WORD NUMBER_OF_RELOCATIONS;
    @NotNull
    private final WORD NUMBER_OF_LINE_NUMBERS;
    @NotNull
    private final SectionCharacteristics CHARACTERISTICS;
    public static final int ENTRY_SIZE = 40;

    public SectionTableEntry(@NotNull ByteArray bytes, int entryNumber, int offset, int size) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.h((ByteDefinition)new HeaderDefinition("Section table entry: " + entryNumber));
        this.NAME = (AsciiString)this.h((ByteDefinition)new AsciiString(bytes, 8, "name"));
        this.VIRTUAL_SIZE = (DWORD)this.h((ByteDefinition)new DWORD(bytes.readUInt-OGnWXxg(4), "virtual size", null));
        this.VIRTUAL_ADDRESS = (DWORD)this.h((ByteDefinition)new DWORD(bytes.readUInt-OGnWXxg(4), "virtual address", null));
        this.SIZE_OF_RAW_DATA = (DWORD)this.h((ByteDefinition)new DWORD(bytes.readUInt-OGnWXxg(4), "size of raw data", null));
        this.POINTER_TO_RAW_DATA = (DWORD)this.h((ByteDefinition)new DWORD(bytes.readUInt-OGnWXxg(4), "pointer to raw data", null));
        this.POINTER_TO_RELOCATIONS = (DWORD)this.h((ByteDefinition)new DWORD(bytes.readUInt-OGnWXxg(4), "pointer to relocations", null));
        this.POINTER_TO_LINE_NUMBERS = (DWORD)this.h((ByteDefinition)new DWORD(bytes.readUInt-OGnWXxg(4), "pointer to line numbers", null));
        this.NUMBER_OF_RELOCATIONS = (WORD)this.h((ByteDefinition)new WORD(bytes.readUShort-BwKQO78(2), "number of relocations", null));
        this.NUMBER_OF_LINE_NUMBERS = (WORD)this.h((ByteDefinition)new WORD(bytes.readUShort-BwKQO78(2), "number of line numbers", null));
        this.CHARACTERISTICS = (SectionCharacteristics)this.h((ByteDefinition)new SectionCharacteristics(bytes.readUInt-OGnWXxg(4), "characteristics", null));
    }

    @NotNull
    public final AsciiString getNAME() {
        return this.NAME;
    }

    @NotNull
    public final DWORD getVIRTUAL_SIZE() {
        return this.VIRTUAL_SIZE;
    }

    @NotNull
    public final DWORD getVIRTUAL_ADDRESS() {
        return this.VIRTUAL_ADDRESS;
    }

    @NotNull
    public final DWORD getSIZE_OF_RAW_DATA() {
        return this.SIZE_OF_RAW_DATA;
    }

    @NotNull
    public final DWORD getPOINTER_TO_RAW_DATA() {
        return this.POINTER_TO_RAW_DATA;
    }

    @NotNull
    public final DWORD getPOINTER_TO_RELOCATIONS() {
        return this.POINTER_TO_RELOCATIONS;
    }

    @NotNull
    public final DWORD getPOINTER_TO_LINE_NUMBERS() {
        return this.POINTER_TO_LINE_NUMBERS;
    }

    @NotNull
    public final WORD getNUMBER_OF_RELOCATIONS() {
        return this.NUMBER_OF_RELOCATIONS;
    }

    @NotNull
    public final WORD getNUMBER_OF_LINE_NUMBERS() {
        return this.NUMBER_OF_LINE_NUMBERS;
    }

    @NotNull
    public final SectionCharacteristics getCHARACTERISTICS() {
        return this.CHARACTERISTICS;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/peParser/headers/SectionTableEntry$Companion;", "", "()V", "ENTRY_SIZE", "", "PeParser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

