/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imoptimizer;

import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.translation.imoptimizer.NameGenerator;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.validation.TRVEHelper;

public class ImCompressor {
    private final ImTranslator trans;
    private final ImProg prog;
    private final NameGenerator ng;

    public ImCompressor(ImTranslator translator) {
        this.trans = translator;
        this.prog = translator.getImProg();
        this.ng = new NameGenerator();
    }

    public void compressNames() {
        this.compressGlobals();
        this.compressFunctions();
    }

    public void compressGlobals() {
        for (ImVar global : this.prog.getGlobals()) {
            if (global.getIsBJ() || TRVEHelper.protectedVariables.contains(global.getName())) continue;
            String replacement = this.ng.getUniqueToken();
            global.setName(replacement);
        }
    }

    public void compressFunctions() {
        for (ImFunction func : ImHelper.calculateFunctionsOfProg(this.prog)) {
            if (func.isNative() || func.isBj() || func.isCompiletime() || func.isExtern()) continue;
            this.compressLocals(func);
            if (func.getName().equals("main") || func.getName().equals("config")) continue;
            String rname = this.ng.getUniqueToken();
            func.setName(rname);
        }
    }

    private void compressLocals(ImFunction func) {
        for (ImVar local : func.getParameters()) {
            local.setName(this.ng.getUniqueToken());
        }
        for (ImVar local : func.getLocals()) {
            local.setName(this.ng.getUniqueToken());
        }
    }
}

